/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.formats.avro;

import com.google.common.base.Verify;
import com.google.common.primitives.Longs;
import io.airlift.log.Logger;
import io.airlift.slice.Slice;
import io.trino.hive.formats.avro.AvroTypeException;
import io.trino.hive.formats.avro.AvroTypeManager;
import io.trino.hive.formats.avro.model.AvroLogicalType;
import io.trino.spi.block.Block;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Int128;
import io.trino.spi.type.SqlTimestamp;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.Timestamps;
import io.trino.spi.type.Type;
import io.trino.spi.type.UuidType;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.runtime.SwitchBootstraps;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.generic.GenericData;

public class NativeLogicalTypesAvroTypeManager
implements AvroTypeManager {
    private static final Logger log = Logger.get(NativeLogicalTypesAvroTypeManager.class);
    public static final Schema DATE_SCHEMA = Schema.create((Schema.Type)Schema.Type.INT);
    public static final Schema TIME_MILLIS_SCHEMA;
    public static final Schema TIME_MICROS_SCHEMA;
    public static final Schema TIMESTAMP_MILLIS_SCHEMA;
    public static final Schema TIMESTAMP_MICROS_SCHEMA;
    public static final Schema UUID_SCHEMA;
    private static final VarHandle BIG_ENDIAN_LONG_VIEW;

    @Override
    public Optional<BiFunction<Block, Integer, Object>> overrideBlockToAvroObject(Schema schema, Type type) throws AvroTypeException {
        Optional<AvroLogicalType> logicalType = NativeLogicalTypesAvroTypeManager.validateAndLogIssues(schema);
        if (logicalType.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(NativeLogicalTypesAvroTypeManager.getAvroFunction(logicalType.get(), schema, type));
    }

    static Type getAvroLogicalTypeSpiType(AvroLogicalType avroLogicalType) {
        AvroLogicalType avroLogicalType2 = avroLogicalType;
        Objects.requireNonNull(avroLogicalType2);
        AvroLogicalType avroLogicalType3 = avroLogicalType2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AvroLogicalType.DateLogicalType.class, AvroLogicalType.BytesDecimalLogicalType.class, AvroLogicalType.FixedDecimalLogicalType.class, AvroLogicalType.TimeMillisLogicalType.class, AvroLogicalType.TimeMicrosLogicalType.class, AvroLogicalType.TimestampMillisLogicalType.class, AvroLogicalType.TimestampMicrosLogicalType.class, AvroLogicalType.StringUUIDLogicalType.class}, (AvroLogicalType)avroLogicalType3, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                AvroLogicalType.DateLogicalType __ = (AvroLogicalType.DateLogicalType)avroLogicalType3;
                yield DateType.DATE;
            }
            case 1 -> {
                AvroLogicalType.BytesDecimalLogicalType bytesDecimalLogicalType = (AvroLogicalType.BytesDecimalLogicalType)avroLogicalType3;
                yield DecimalType.createDecimalType((int)bytesDecimalLogicalType.precision(), (int)bytesDecimalLogicalType.scale());
            }
            case 2 -> {
                AvroLogicalType.FixedDecimalLogicalType fixedDecimalLogicalType = (AvroLogicalType.FixedDecimalLogicalType)avroLogicalType3;
                yield DecimalType.createDecimalType((int)fixedDecimalLogicalType.precision(), (int)fixedDecimalLogicalType.scale());
            }
            case 3 -> {
                AvroLogicalType.TimeMillisLogicalType __ = (AvroLogicalType.TimeMillisLogicalType)avroLogicalType3;
                yield TimeType.TIME_MILLIS;
            }
            case 4 -> {
                AvroLogicalType.TimeMicrosLogicalType __ = (AvroLogicalType.TimeMicrosLogicalType)avroLogicalType3;
                yield TimeType.TIME_MICROS;
            }
            case 5 -> {
                AvroLogicalType.TimestampMillisLogicalType __ = (AvroLogicalType.TimestampMillisLogicalType)avroLogicalType3;
                yield TimestampType.TIMESTAMP_MILLIS;
            }
            case 6 -> {
                AvroLogicalType.TimestampMicrosLogicalType __ = (AvroLogicalType.TimestampMicrosLogicalType)avroLogicalType3;
                yield TimestampType.TIMESTAMP_MICROS;
            }
            case 7 -> {
                AvroLogicalType.StringUUIDLogicalType __ = (AvroLogicalType.StringUUIDLogicalType)avroLogicalType3;
                yield UuidType.UUID;
            }
        };
    }

    static Type getAvroLogicalTypeSpiType(LogicalType logicalType) {
        return switch (logicalType.getName()) {
            case "date" -> DateType.DATE;
            case "decimal" -> {
                LogicalTypes.Decimal decimal = (LogicalTypes.Decimal)logicalType;
                yield DecimalType.createDecimalType((int)decimal.getPrecision(), (int)decimal.getScale());
            }
            case "time-millis" -> TimeType.TIME_MILLIS;
            case "time-micros" -> TimeType.TIME_MICROS;
            case "timestamp-millis" -> TimestampType.TIMESTAMP_MILLIS;
            case "timestamp-micros" -> TimestampType.TIMESTAMP_MICROS;
            case "uuid" -> UuidType.UUID;
            default -> throw new IllegalStateException("Unreachable unfiltered logical type");
        };
    }

    private static BiFunction<Block, Integer, Object> getAvroFunction(AvroLogicalType logicalType, Schema schema, Type type) throws AvroTypeException {
        AvroLogicalType avroLogicalType = logicalType;
        Objects.requireNonNull(avroLogicalType);
        AvroLogicalType avroLogicalType2 = avroLogicalType;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AvroLogicalType.DateLogicalType.class, AvroLogicalType.BytesDecimalLogicalType.class, AvroLogicalType.FixedDecimalLogicalType.class, AvroLogicalType.TimeMillisLogicalType.class, AvroLogicalType.TimeMicrosLogicalType.class, AvroLogicalType.TimestampMillisLogicalType.class, AvroLogicalType.TimestampMicrosLogicalType.class, AvroLogicalType.StringUUIDLogicalType.class}, (AvroLogicalType)avroLogicalType2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                if (type != DateType.DATE) {
                    throw new AvroTypeException("Can't represent Avro logical type %s with Trino Type %s".formatted(logicalType, type));
                }
                yield (arg_0, arg_1) -> ((DateType)DateType.DATE).getLong(arg_0, arg_1);
            }
            case 1 -> {
                DecimalType decimalType = (DecimalType)NativeLogicalTypesAvroTypeManager.getAvroLogicalTypeSpiType(logicalType);
                if (decimalType.isShort()) {
                    yield (block, pos) -> ByteBuffer.wrap(Longs.toByteArray((long)decimalType.getLong(block, pos.intValue())));
                }
                yield (block, pos) -> ByteBuffer.wrap(((Int128)decimalType.getObject(block, pos.intValue())).toBigEndianBytes());
            }
            case 2 -> {
                DecimalType decimalType = (DecimalType)NativeLogicalTypesAvroTypeManager.getAvroLogicalTypeSpiType(logicalType);
                Function<byte[], Object> wrapBytes = bytes -> new GenericData.Fixed(schema, NativeLogicalTypesAvroTypeManager.fitBigEndianValueToByteArraySize(bytes, schema.getFixedSize()));
                if (decimalType.isShort()) {
                    yield (block, pos) -> wrapBytes.apply(Longs.toByteArray((long)decimalType.getLong(block, pos.intValue())));
                }
                yield (block, pos) -> wrapBytes.apply(((Int128)decimalType.getObject(block, pos.intValue())).toBigEndianBytes());
            }
            case 3 -> {
                if (!(type instanceof TimeType)) {
                    throw new AvroTypeException("Can't represent Avro logical type %s with Trino Type %s".formatted(logicalType, type));
                }
                TimeType timeType = (TimeType)type;
                if (timeType.getPrecision() > 3) {
                    throw new AvroTypeException("Can't write out Avro logical time-millis from Trino Time Type with precision %s".formatted(timeType.getPrecision()));
                }
                yield (block, pos) -> Timestamps.roundDiv((long)timeType.getLong(block, pos.intValue()), (long)1000000000L);
            }
            case 4 -> {
                if (!(type instanceof TimeType)) {
                    throw new AvroTypeException("Can't represent Avro logical type %s with Trino Type %s".formatted(logicalType, type));
                }
                TimeType timeType = (TimeType)type;
                if (timeType.getPrecision() > 6) {
                    throw new AvroTypeException("Can't write out Avro logical time-millis from Trino Time Type with precision %s".formatted(timeType.getPrecision()));
                }
                yield (block, pos) -> Timestamps.roundDiv((long)timeType.getLong(block, pos.intValue()), (long)1000000L);
            }
            case 5 -> {
                if (!(type instanceof TimestampType)) {
                    throw new AvroTypeException("Can't represent Avro logical type %s with Trino Type %s".formatted(logicalType, type));
                }
                TimestampType timestampType = (TimestampType)type;
                if (timestampType.isShort()) {
                    yield (block, integer) -> timestampType.getLong(block, integer.intValue()) / 1000L;
                }
                yield (block, integer) -> {
                    SqlTimestamp timestamp = (SqlTimestamp)timestampType.getObject(block, integer.intValue());
                    return timestamp.roundTo(3).getMillis();
                };
            }
            case 6 -> {
                if (!(type instanceof TimestampType)) {
                    throw new AvroTypeException("Can't represent Avro logical type %s with Trino Type %s".formatted(logicalType, type));
                }
                TimestampType timestampType = (TimestampType)type;
                if (timestampType.isShort()) {
                    yield (arg_0, arg_1) -> ((TimestampType)timestampType).getLong(arg_0, arg_1);
                }
                yield (block, position) -> {
                    SqlTimestamp timestamp = (SqlTimestamp)timestampType.getObject(block, position.intValue());
                    return timestamp.roundTo(6).getEpochMicros();
                };
            }
            case 7 -> {
                if (!(type instanceof UuidType)) {
                    throw new AvroTypeException("Can't represent Avro logical type %s with Trino Type %s".formatted(logicalType, type));
                }
                UuidType uuidType = (UuidType)type;
                yield (block, pos) -> UuidType.trinoUuidToJavaUuid((Slice)((Slice)uuidType.getObject(block, pos.intValue()))).toString();
            }
        };
    }

    static Optional<AvroLogicalType> validateAndLogIssues(Schema schema) {
        ValidateLogicalTypeResult validateLogicalTypeResult = NativeLogicalTypesAvroTypeManager.validateLogicalType(schema);
        Objects.requireNonNull(validateLogicalTypeResult);
        ValidateLogicalTypeResult validateLogicalTypeResult2 = validateLogicalTypeResult;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{NoLogicalType.class, NonNativeAvroLogicalType.class, InvalidNativeAvroLogicalType.class, ValidNativeAvroLogicalType.class}, (ValidateLogicalTypeResult)validateLogicalTypeResult2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                NoLogicalType ignored = (NoLogicalType)validateLogicalTypeResult2;
                return Optional.empty();
            }
            case 1: {
                NonNativeAvroLogicalType ignored = (NonNativeAvroLogicalType)validateLogicalTypeResult2;
                log.debug("Unrecognized logical type " + String.valueOf(schema));
                return Optional.empty();
            }
            case 2: {
                InvalidNativeAvroLogicalType invalidNativeAvroLogicalType = (InvalidNativeAvroLogicalType)validateLogicalTypeResult2;
                log.debug((Throwable)invalidNativeAvroLogicalType.getCause(), "Invalidly configured native Avro logical type");
                return Optional.empty();
            }
            case 3: 
        }
        ValidNativeAvroLogicalType validNativeAvroLogicalType = (ValidNativeAvroLogicalType)validateLogicalTypeResult2;
        return Optional.of(validNativeAvroLogicalType.getLogicalType());
    }

    public static ValidateLogicalTypeResult validateLogicalType(Schema schema) {
        LogicalType logicalType;
        String typeName = schema.getProp("logicalType");
        if (typeName == null) {
            return new NoLogicalType();
        }
        switch (typeName) {
            case "date": 
            case "decimal": 
            case "time-millis": 
            case "time-micros": 
            case "timestamp-millis": 
            case "timestamp-micros": 
            case "uuid": {
                logicalType = LogicalTypes.fromSchemaIgnoreInvalid((Schema)schema);
                break;
            }
            case "local-timestamp-microslocal-timestamp-millis": {
                log.debug("Logical type " + typeName + " not currently supported by by Trino");
            }
            default: {
                return new NonNativeAvroLogicalType(typeName);
            }
        }
        if (logicalType != null) {
            try {
                logicalType.validate(schema);
            }
            catch (RuntimeException e) {
                return new InvalidNativeAvroLogicalType(typeName, e);
            }
            return new ValidNativeAvroLogicalType(AvroLogicalType.fromAvroLogicalType(logicalType, schema));
        }
        return new NonNativeAvroLogicalType(typeName);
    }

    public static long fromBigEndian(byte[] bytes) {
        if (bytes.length > 8) {
            int offset = bytes.length - 8;
            long res = BIG_ENDIAN_LONG_VIEW.get(bytes, offset);
            int expectedSignExtensionByte = (int)(res >> 63);
            for (int i = 0; i < offset; ++i) {
                if (bytes[i] == expectedSignExtensionByte) continue;
                throw new ArithmeticException("Overflow");
            }
            return res;
        }
        if (bytes.length == 8) {
            return BIG_ENDIAN_LONG_VIEW.get(bytes, 0);
        }
        long res = bytes[0] >> 7;
        for (byte b : bytes) {
            res = res << 8 | (long)(b & 0xFF);
        }
        return res;
    }

    public static byte[] fitBigEndianValueToByteArraySize(long value, int byteSize) {
        return NativeLogicalTypesAvroTypeManager.fitBigEndianValueToByteArraySize(Longs.toByteArray((long)value), byteSize);
    }

    public static byte[] fitBigEndianValueToByteArraySize(Int128 value, int byteSize) {
        return NativeLogicalTypesAvroTypeManager.fitBigEndianValueToByteArraySize(value.toBigEndianBytes(), byteSize);
    }

    public static byte[] fitBigEndianValueToByteArraySize(byte[] value, int byteSize) {
        if (value.length == byteSize) {
            return value;
        }
        if (value.length < byteSize) {
            return NativeLogicalTypesAvroTypeManager.padBigEndianToSize(value, byteSize);
        }
        if (NativeLogicalTypesAvroTypeManager.canBigEndianValueBeRepresentedBySmallerByteSize(value, byteSize)) {
            byte[] dest = new byte[byteSize];
            System.arraycopy(value, value.length - byteSize, dest, 0, byteSize);
            return dest;
        }
        throw new ArithmeticException("Can't resize big endian bytes %s to size %s".formatted(Arrays.toString(value), byteSize));
    }

    private static boolean canBigEndianValueBeRepresentedBySmallerByteSize(byte[] bigEndianValue, int byteSize) {
        Verify.verify((byteSize < bigEndianValue.length ? 1 : 0) != 0);
        if (byteSize <= 0) {
            return false;
        }
        if (bigEndianValue[0] != 0 && bigEndianValue[0] != -1) {
            return false;
        }
        int firstSigByte = 0;
        byte padding = bigEndianValue[0];
        for (int i = 1; i < bigEndianValue.length; ++i) {
            if (bigEndianValue[i] == padding) {
                firstSigByte = i;
                continue;
            }
            if (padding == 0 && bigEndianValue[i] < 0) break;
            if (padding == 0 && bigEndianValue[i] > 0) {
                firstSigByte = i;
                break;
            }
            if (padding == -1 && bigEndianValue[i] >= 0) break;
            if (padding != -1 || bigEndianValue[i] >= 0) continue;
            firstSigByte = i;
            break;
        }
        return bigEndianValue.length - firstSigByte <= byteSize;
    }

    public static byte[] padBigEndianToSize(Int128 toPad, int byteSize) {
        return NativeLogicalTypesAvroTypeManager.padBigEndianToSize(toPad.toBigEndianBytes(), byteSize);
    }

    public static byte[] padBigEndianToSize(long toPad, int byteSize) {
        return NativeLogicalTypesAvroTypeManager.padBigEndianToSize(Longs.toByteArray((long)toPad), byteSize);
    }

    public static byte[] padBigEndianToSize(byte[] toPad, int byteSize) {
        int endianSize = toPad.length;
        if (byteSize < endianSize) {
            throw new ArithmeticException("Big endian bytes size must be less than or equal to the total padded size");
        }
        if (endianSize < 1) {
            throw new ArithmeticException("Cannot pad empty array");
        }
        byte[] padded = new byte[byteSize];
        System.arraycopy(toPad, 0, padded, byteSize - endianSize, endianSize);
        if (toPad[0] < 0) {
            for (int i = 0; i < byteSize - endianSize; ++i) {
                padded[i] = -1;
            }
        }
        return padded;
    }

    static {
        LogicalTypes.date().addToSchema(DATE_SCHEMA);
        TIME_MILLIS_SCHEMA = Schema.create((Schema.Type)Schema.Type.INT);
        LogicalTypes.timeMillis().addToSchema(TIME_MILLIS_SCHEMA);
        TIME_MICROS_SCHEMA = Schema.create((Schema.Type)Schema.Type.LONG);
        LogicalTypes.timeMicros().addToSchema(TIME_MICROS_SCHEMA);
        TIMESTAMP_MILLIS_SCHEMA = (Schema)SchemaBuilder.builder().longType();
        LogicalTypes.timestampMillis().addToSchema(TIMESTAMP_MILLIS_SCHEMA);
        TIMESTAMP_MICROS_SCHEMA = (Schema)SchemaBuilder.builder().longType();
        LogicalTypes.timestampMicros().addToSchema(TIMESTAMP_MICROS_SCHEMA);
        UUID_SCHEMA = Schema.create((Schema.Type)Schema.Type.STRING);
        LogicalTypes.uuid().addToSchema(UUID_SCHEMA);
        BIG_ENDIAN_LONG_VIEW = MethodHandles.byteArrayViewVarHandle(long[].class, ByteOrder.BIG_ENDIAN);
    }

    public static abstract sealed class ValidateLogicalTypeResult
    permits NoLogicalType, NonNativeAvroLogicalType, InvalidNativeAvroLogicalType, ValidNativeAvroLogicalType {
    }

    protected static final class NoLogicalType
    extends ValidateLogicalTypeResult {
        protected NoLogicalType() {
        }
    }

    protected static final class NonNativeAvroLogicalType
    extends ValidateLogicalTypeResult {
        private final String logicalTypeName;

        public NonNativeAvroLogicalType(String logicalTypeName) {
            this.logicalTypeName = Objects.requireNonNull(logicalTypeName, "logicalTypeName is null");
        }

        public String getLogicalTypeName() {
            return this.logicalTypeName;
        }
    }

    protected static final class InvalidNativeAvroLogicalType
    extends ValidateLogicalTypeResult {
        private final String logicalTypeName;
        private final RuntimeException cause;

        public InvalidNativeAvroLogicalType(String logicalTypeName, RuntimeException cause) {
            this.logicalTypeName = Objects.requireNonNull(logicalTypeName, "logicalTypeName");
            this.cause = Objects.requireNonNull(cause, "cause is null");
        }

        public String getLogicalTypeName() {
            return this.logicalTypeName;
        }

        public RuntimeException getCause() {
            return this.cause;
        }
    }

    protected static final class ValidNativeAvroLogicalType
    extends ValidateLogicalTypeResult {
        private final AvroLogicalType logicalType;

        public ValidNativeAvroLogicalType(AvroLogicalType logicalType) {
            this.logicalType = Objects.requireNonNull(logicalType, "logicalType is null");
        }

        public AvroLogicalType getLogicalType() {
            return this.logicalType;
        }
    }
}

