/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.formats.encodings.text;

import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import io.trino.hive.formats.HiveFormatUtils;
import io.trino.hive.formats.encodings.ColumnData;
import io.trino.hive.formats.encodings.EncodeOutput;
import io.trino.hive.formats.encodings.text.TextColumnEncoding;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Decimals;
import io.trino.spi.type.Int128;
import io.trino.spi.type.Type;

public class DecimalEncoding
implements TextColumnEncoding {
    private final DecimalType type;
    private final Slice nullSequence;

    public DecimalEncoding(Type type, Slice nullSequence) {
        this.type = (DecimalType)type;
        this.nullSequence = nullSequence;
    }

    @Override
    public void encodeColumn(Block block, SliceOutput output, EncodeOutput encodeOutput) {
        for (int position = 0; position < block.getPositionCount(); ++position) {
            if (block.isNull(position)) {
                output.writeBytes(this.nullSequence);
            } else {
                this.encodeValue(block, position, output);
            }
            encodeOutput.closeEntry();
        }
    }

    @Override
    public void encodeValueInto(Block block, int position, SliceOutput output) {
        this.encodeValue(block, position, output);
    }

    private void encodeValue(Block block, int position, SliceOutput output) {
        if (this.type.isShort()) {
            output.writeBytes(Slices.utf8Slice((String)Decimals.toString((long)this.type.getLong(block, position), (int)this.type.getScale())));
        } else {
            output.writeBytes(Slices.utf8Slice((String)Decimals.toString((Int128)((Int128)this.type.getObject(block, position)), (int)this.type.getScale())));
        }
    }

    @Override
    public Block decodeColumn(ColumnData columnData) {
        int size = columnData.rowCount();
        BlockBuilder builder = this.type.createFixedSizeBlockBuilder(size);
        Slice slice = columnData.getSlice();
        for (int i = 0; i < size; ++i) {
            int offset = columnData.getOffset(i);
            int length = columnData.getLength(i);
            if (length == 0 || this.nullSequence.equals(0, this.nullSequence.length(), slice, offset, length)) {
                builder.appendNull();
                continue;
            }
            this.decodeValue(builder, slice, offset, length);
        }
        return builder.build();
    }

    @Override
    public void decodeValueInto(BlockBuilder builder, Slice slice, int offset, int length) {
        this.decodeValue(builder, slice, offset, length);
    }

    private void decodeValue(BlockBuilder builder, Slice slice, int offset, int length) {
        try {
            HiveFormatUtils.writeDecimal(slice.toStringAscii(offset, length), this.type, builder);
        }
        catch (NumberFormatException e) {
            builder.appendNull();
        }
    }
}

