/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.collect.ImmutableList;
import io.trino.plugin.iceberg.BaseSystemTable;
import io.trino.plugin.iceberg.util.PageListBuilder;
import io.trino.spi.block.ArrayBlockBuilder;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.RowBlockBuilder;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import org.apache.iceberg.MetadataTableType;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;

public class AllManifestsTable
extends BaseSystemTable {
    public AllManifestsTable(SchemaTableName tableName, Table icebergTable, ExecutorService executor) {
        super(Objects.requireNonNull(icebergTable, "icebergTable is null"), new ConnectorTableMetadata(Objects.requireNonNull(tableName, "tableName is null"), (List)ImmutableList.builder().add((Object)new ColumnMetadata("path", (Type)VarcharType.VARCHAR)).add((Object)new ColumnMetadata("length", (Type)BigintType.BIGINT)).add((Object)new ColumnMetadata("partition_spec_id", (Type)IntegerType.INTEGER)).add((Object)new ColumnMetadata("added_snapshot_id", (Type)BigintType.BIGINT)).add((Object)new ColumnMetadata("added_data_files_count", (Type)IntegerType.INTEGER)).add((Object)new ColumnMetadata("existing_data_files_count", (Type)IntegerType.INTEGER)).add((Object)new ColumnMetadata("deleted_data_files_count", (Type)IntegerType.INTEGER)).add((Object)new ColumnMetadata("partition_summaries", (Type)new ArrayType((Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"contains_null", (Type)BooleanType.BOOLEAN), RowType.field((String)"contains_nan", (Type)BooleanType.BOOLEAN), RowType.field((String)"lower_bound", (Type)VarcharType.VARCHAR), RowType.field((String)"upper_bound", (Type)VarcharType.VARCHAR)})))).build()), MetadataTableType.ALL_MANIFESTS, executor);
    }

    @Override
    protected void addRow(PageListBuilder pagesBuilder, BaseSystemTable.Row row, TimeZoneKey timeZoneKey) {
        pagesBuilder.beginRow();
        pagesBuilder.appendVarchar(row.get("path", String.class));
        pagesBuilder.appendBigint(row.get("length", Long.class));
        pagesBuilder.appendInteger(row.get("partition_spec_id", Integer.class));
        pagesBuilder.appendBigint(row.get("added_snapshot_id", Long.class));
        pagesBuilder.appendInteger(row.get("added_data_files_count", Integer.class));
        pagesBuilder.appendInteger(row.get("existing_data_files_count", Integer.class));
        pagesBuilder.appendInteger(row.get("deleted_data_files_count", Integer.class));
        AllManifestsTable.appendPartitionSummaries((ArrayBlockBuilder)pagesBuilder.nextColumn(), row.get("partition_summaries", List.class));
        pagesBuilder.endRow();
    }

    private static void appendPartitionSummaries(ArrayBlockBuilder arrayBuilder, List<StructLike> partitionSummaries) {
        arrayBuilder.buildEntry(elementBuilder -> {
            for (StructLike partitionSummary : partitionSummaries) {
                ((RowBlockBuilder)elementBuilder).buildEntry(fieldBuilders -> {
                    BooleanType.BOOLEAN.writeBoolean((BlockBuilder)fieldBuilders.get(0), ((Boolean)partitionSummary.get(0, Boolean.class)).booleanValue());
                    Boolean containsNan = (Boolean)partitionSummary.get(1, Boolean.class);
                    if (containsNan == null) {
                        ((BlockBuilder)fieldBuilders.get(1)).appendNull();
                    } else {
                        BooleanType.BOOLEAN.writeBoolean((BlockBuilder)fieldBuilders.get(1), containsNan.booleanValue());
                    }
                    VarcharType.VARCHAR.writeString((BlockBuilder)fieldBuilders.get(2), (String)partitionSummary.get(2, String.class));
                    VarcharType.VARCHAR.writeString((BlockBuilder)fieldBuilders.get(3), (String)partitionSummary.get(3, String.class));
                });
            }
        });
    }
}

