/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Streams;
import io.trino.plugin.iceberg.util.PageListBuilder;
import io.trino.spi.Page;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.FixedPageSource;
import io.trino.spi.connector.SystemTable;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.TimeZoneKey;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import org.apache.iceberg.DataTask;
import org.apache.iceberg.MetadataTableType;
import org.apache.iceberg.MetadataTableUtils;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.io.CloseableIterable;

public abstract class BaseSystemTable
implements SystemTable {
    private final Table icebergTable;
    private final ConnectorTableMetadata tableMetadata;
    private final MetadataTableType metadataTableType;
    private final ExecutorService executor;

    BaseSystemTable(Table icebergTable, ConnectorTableMetadata tableMetadata, MetadataTableType metadataTableType, ExecutorService executor) {
        this.icebergTable = Objects.requireNonNull(icebergTable, "icebergTable is null");
        this.tableMetadata = Objects.requireNonNull(tableMetadata, "tableMetadata is null");
        this.metadataTableType = Objects.requireNonNull(metadataTableType, "metadataTableType is null");
        this.executor = Objects.requireNonNull(executor, "executor is null");
    }

    public SystemTable.Distribution getDistribution() {
        return SystemTable.Distribution.SINGLE_COORDINATOR;
    }

    public ConnectorTableMetadata getTableMetadata() {
        return this.tableMetadata;
    }

    public ConnectorPageSource pageSource(ConnectorTransactionHandle transactionHandle, ConnectorSession session, TupleDomain<Integer> constraint) {
        return new FixedPageSource(this.buildPages(this.tableMetadata, session, this.icebergTable, this.metadataTableType));
    }

    private List<Page> buildPages(ConnectorTableMetadata tableMetadata, ConnectorSession session, Table icebergTable, MetadataTableType metadataTableType) {
        PageListBuilder pagesBuilder = PageListBuilder.forTable(tableMetadata);
        TableScan tableScan = (TableScan)MetadataTableUtils.createMetadataTableInstance((Table)icebergTable, (MetadataTableType)metadataTableType).newScan().planWith(this.executor);
        TimeZoneKey timeZoneKey = session.getTimeZoneKey();
        Map columnNameToPosition = (Map)Streams.mapWithIndex(tableScan.schema().columns().stream(), (column, position) -> Maps.immutableEntry((Object)column.name(), (Object)Long.valueOf(position).intValue())).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
        try (CloseableIterable fileScanTasks = tableScan.planFiles();){
            fileScanTasks.forEach(fileScanTask -> this.addRows((DataTask)fileScanTask, pagesBuilder, timeZoneKey, columnNameToPosition));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return pagesBuilder.build();
    }

    private void addRows(DataTask dataTask, PageListBuilder pagesBuilder, TimeZoneKey timeZoneKey, Map<String, Integer> columnNameToPositionInSchema) {
        try (CloseableIterable dataRows = dataTask.rows();){
            dataRows.forEach(dataTaskRow -> this.addRow(pagesBuilder, new Row((StructLike)dataTaskRow, columnNameToPositionInSchema), timeZoneKey));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    protected abstract void addRow(PageListBuilder var1, Row var2, TimeZoneKey var3);

    public record Row(StructLike structLike, Map<String, Integer> columnNameToPositionInSchema) {
        public Row {
            Objects.requireNonNull(structLike, "structLike is null");
            columnNameToPositionInSchema = ImmutableMap.copyOf(columnNameToPositionInSchema);
        }

        public <T> T get(String columnName, Class<T> javaClass) {
            return (T)this.structLike.get(this.columnNameToPositionInSchema.get(columnName).intValue(), javaClass);
        }
    }
}

