/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slices;
import io.trino.plugin.iceberg.BaseSystemTable;
import io.trino.plugin.iceberg.FilesTable;
import io.trino.plugin.iceberg.IcebergPartitionColumn;
import io.trino.plugin.iceberg.IcebergTypes;
import io.trino.plugin.iceberg.IcebergUtil;
import io.trino.plugin.iceberg.PartitionsTable;
import io.trino.plugin.iceberg.util.PageListBuilder;
import io.trino.spi.block.ArrayBlockBuilder;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.MapBlockBuilder;
import io.trino.spi.block.RowBlockBuilder;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.spi.type.TypeUtils;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import jakarta.annotation.Nullable;
import java.nio.ByteBuffer;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import org.apache.iceberg.MetadataTableType;
import org.apache.iceberg.MetricsUtil;
import org.apache.iceberg.PartitionField;
import org.apache.iceberg.Table;
import org.apache.iceberg.transforms.Transforms;
import org.apache.iceberg.types.Conversions;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.StructProjection;

public class EntriesTable
extends BaseSystemTable {
    private final Map<Integer, Type> idToTypeMapping;
    private final List<Types.NestedField> primitiveFields;
    private final Optional<IcebergPartitionColumn> partitionColumn;
    private final List<Type> partitionTypes;

    public EntriesTable(TypeManager typeManager, SchemaTableName tableName, Table icebergTable, MetadataTableType metadataTableType, ExecutorService executor) {
        super(Objects.requireNonNull(icebergTable, "icebergTable is null"), new ConnectorTableMetadata(Objects.requireNonNull(tableName, "tableName is null"), EntriesTable.columns(Objects.requireNonNull(typeManager, "typeManager is null"), icebergTable)), metadataTableType, executor);
        Preconditions.checkArgument((metadataTableType == MetadataTableType.ALL_ENTRIES || metadataTableType == MetadataTableType.ENTRIES ? 1 : 0) != 0, (String)"Unexpected metadata table type: %s", (Object)metadataTableType);
        this.idToTypeMapping = FilesTable.getIcebergIdToTypeMapping(icebergTable.schema());
        this.primitiveFields = (List)IcebergUtil.primitiveFields(icebergTable.schema()).stream().sorted(Comparator.comparing(Types.NestedField::name)).collect(ImmutableList.toImmutableList());
        List<PartitionField> partitionFields = PartitionsTable.getAllPartitionFields(icebergTable);
        this.partitionColumn = IcebergUtil.getPartitionColumnType(partitionFields, icebergTable.schema(), typeManager);
        this.partitionTypes = IcebergUtil.partitionTypes(partitionFields, IcebergUtil.primitiveFieldTypes(icebergTable.schema()));
    }

    private static List<ColumnMetadata> columns(TypeManager typeManager, Table icebergTable) {
        return ImmutableList.builder().add((Object)new ColumnMetadata("status", (io.trino.spi.type.Type)IntegerType.INTEGER)).add((Object)new ColumnMetadata("snapshot_id", (io.trino.spi.type.Type)BigintType.BIGINT)).add((Object)new ColumnMetadata("sequence_number", (io.trino.spi.type.Type)BigintType.BIGINT)).add((Object)new ColumnMetadata("file_sequence_number", (io.trino.spi.type.Type)BigintType.BIGINT)).add((Object)new ColumnMetadata("data_file", (io.trino.spi.type.Type)RowType.from(EntriesTable.dataFileFieldMetadata(typeManager, icebergTable)))).add((Object)new ColumnMetadata("readable_metrics", typeManager.getType(new TypeSignature("json", new TypeSignatureParameter[0])))).build();
    }

    private static List<RowType.Field> dataFileFieldMetadata(TypeManager typeManager, Table icebergTable) {
        List<PartitionField> partitionFields = PartitionsTable.getAllPartitionFields(icebergTable);
        Optional<IcebergPartitionColumn> partitionColumnType = IcebergUtil.getPartitionColumnType(partitionFields, icebergTable.schema(), typeManager);
        ImmutableList.Builder fields = ImmutableList.builder();
        fields.add((Object)new RowType.Field(Optional.of("content"), (io.trino.spi.type.Type)IntegerType.INTEGER));
        fields.add((Object)new RowType.Field(Optional.of("file_path"), (io.trino.spi.type.Type)VarcharType.VARCHAR));
        fields.add((Object)new RowType.Field(Optional.of("file_format"), (io.trino.spi.type.Type)VarcharType.VARCHAR));
        fields.add((Object)new RowType.Field(Optional.of("spec_id"), (io.trino.spi.type.Type)IntegerType.INTEGER));
        partitionColumnType.ifPresent(type -> fields.add((Object)new RowType.Field(Optional.of("partition"), (io.trino.spi.type.Type)type.rowType())));
        fields.add((Object)new RowType.Field(Optional.of("record_count"), (io.trino.spi.type.Type)BigintType.BIGINT));
        fields.add((Object)new RowType.Field(Optional.of("file_size_in_bytes"), (io.trino.spi.type.Type)BigintType.BIGINT));
        fields.add((Object)new RowType.Field(Optional.of("column_sizes"), typeManager.getType(TypeSignature.mapType((TypeSignature)IntegerType.INTEGER.getTypeSignature(), (TypeSignature)BigintType.BIGINT.getTypeSignature()))));
        fields.add((Object)new RowType.Field(Optional.of("value_counts"), typeManager.getType(TypeSignature.mapType((TypeSignature)IntegerType.INTEGER.getTypeSignature(), (TypeSignature)BigintType.BIGINT.getTypeSignature()))));
        fields.add((Object)new RowType.Field(Optional.of("null_value_counts"), typeManager.getType(TypeSignature.mapType((TypeSignature)IntegerType.INTEGER.getTypeSignature(), (TypeSignature)BigintType.BIGINT.getTypeSignature()))));
        fields.add((Object)new RowType.Field(Optional.of("nan_value_counts"), typeManager.getType(TypeSignature.mapType((TypeSignature)IntegerType.INTEGER.getTypeSignature(), (TypeSignature)BigintType.BIGINT.getTypeSignature()))));
        fields.add((Object)new RowType.Field(Optional.of("lower_bounds"), typeManager.getType(TypeSignature.mapType((TypeSignature)IntegerType.INTEGER.getTypeSignature(), (TypeSignature)VarcharType.VARCHAR.getTypeSignature()))));
        fields.add((Object)new RowType.Field(Optional.of("upper_bounds"), typeManager.getType(TypeSignature.mapType((TypeSignature)IntegerType.INTEGER.getTypeSignature(), (TypeSignature)VarcharType.VARCHAR.getTypeSignature()))));
        fields.add((Object)new RowType.Field(Optional.of("key_metadata"), (io.trino.spi.type.Type)VarbinaryType.VARBINARY));
        fields.add((Object)new RowType.Field(Optional.of("split_offsets"), (io.trino.spi.type.Type)new ArrayType((io.trino.spi.type.Type)BigintType.BIGINT)));
        fields.add((Object)new RowType.Field(Optional.of("equality_ids"), (io.trino.spi.type.Type)new ArrayType((io.trino.spi.type.Type)IntegerType.INTEGER)));
        fields.add((Object)new RowType.Field(Optional.of("sort_order_id"), (io.trino.spi.type.Type)IntegerType.INTEGER));
        return fields.build();
    }

    @Override
    protected void addRow(PageListBuilder pagesBuilder, BaseSystemTable.Row row, TimeZoneKey timeZoneKey) {
        pagesBuilder.beginRow();
        pagesBuilder.appendInteger(row.get("status", Integer.class));
        pagesBuilder.appendBigint(row.get("snapshot_id", Long.class));
        pagesBuilder.appendBigint(row.get("sequence_number", Long.class));
        pagesBuilder.appendBigint(row.get("file_sequence_number", Long.class));
        StructProjection dataFile = row.get("data_file", StructProjection.class);
        this.appendDataFile((RowBlockBuilder)pagesBuilder.nextColumn(), dataFile);
        MetricsUtil.ReadableMetricsStruct readableMetrics = row.get("readable_metrics", MetricsUtil.ReadableMetricsStruct.class);
        String readableMetricsJson = FilesTable.toJson(readableMetrics, this.primitiveFields);
        pagesBuilder.appendVarchar(readableMetricsJson);
        pagesBuilder.endRow();
    }

    private void appendDataFile(RowBlockBuilder blockBuilder, StructProjection dataFile) {
        blockBuilder.buildEntry(fieldBuilders -> {
            Integer content = (Integer)dataFile.get(0, Integer.class);
            IntegerType.INTEGER.writeLong((BlockBuilder)fieldBuilders.get(0), (long)content.intValue());
            String filePath = (String)dataFile.get(1, String.class);
            VarcharType.VARCHAR.writeString((BlockBuilder)fieldBuilders.get(1), filePath);
            String fileFormat = (String)dataFile.get(2, String.class);
            VarcharType.VARCHAR.writeString((BlockBuilder)fieldBuilders.get(2), fileFormat);
            Integer specId = (Integer)dataFile.get(3, Integer.class);
            IntegerType.INTEGER.writeLong((BlockBuilder)fieldBuilders.get(3), Long.valueOf(specId.intValue()).longValue());
            this.partitionColumn.ifPresent(type -> {
                StructProjection partition = (StructProjection)dataFile.get(4, StructProjection.class);
                RowBlockBuilder partitionBlockBuilder = (RowBlockBuilder)fieldBuilders.get(4);
                partitionBlockBuilder.buildEntry(partitionBuilder -> {
                    for (int i = 0; i < type.rowType().getFields().size(); ++i) {
                        Type icebergType = this.partitionTypes.get(i);
                        io.trino.spi.type.Type trinoType = ((RowType.Field)type.rowType().getFields().get(i)).getType();
                        Object value = null;
                        Integer fieldId = type.fieldIds().get(i);
                        if (fieldId != null) {
                            value = IcebergTypes.convertIcebergValueToTrino(icebergType, partition.get(i, icebergType.typeId().javaClass()));
                        }
                        TypeUtils.writeNativeValue((io.trino.spi.type.Type)trinoType, (BlockBuilder)((BlockBuilder)partitionBuilder.get(i)), value);
                    }
                });
            });
            int position = this.partitionColumn.isEmpty() ? 4 : 5;
            Long recordCount = (Long)dataFile.get(position, Long.class);
            BigintType.BIGINT.writeLong((BlockBuilder)fieldBuilders.get(position), recordCount.longValue());
            Long fileSizeInBytes = (Long)dataFile.get(++position, Long.class);
            BigintType.BIGINT.writeLong((BlockBuilder)fieldBuilders.get(position), fileSizeInBytes.longValue());
            Map columnSizes = (Map)dataFile.get(++position, Map.class);
            EntriesTable.appendIntegerBigintMap((MapBlockBuilder)fieldBuilders.get(position), columnSizes);
            Map valueCounts = (Map)dataFile.get(++position, Map.class);
            EntriesTable.appendIntegerBigintMap((MapBlockBuilder)fieldBuilders.get(position), valueCounts);
            Map nullValueCounts = (Map)dataFile.get(++position, Map.class);
            EntriesTable.appendIntegerBigintMap((MapBlockBuilder)fieldBuilders.get(position), nullValueCounts);
            Map nanValueCounts = (Map)dataFile.get(++position, Map.class);
            EntriesTable.appendIntegerBigintMap((MapBlockBuilder)fieldBuilders.get(position), nanValueCounts);
            Map lowerBounds = (Map)dataFile.get(++position, Map.class);
            this.appendIntegerVarcharMap((MapBlockBuilder)fieldBuilders.get(position), lowerBounds);
            Map upperBounds = (Map)dataFile.get(++position, Map.class);
            this.appendIntegerVarcharMap((MapBlockBuilder)fieldBuilders.get(position), upperBounds);
            ByteBuffer keyMetadata = (ByteBuffer)dataFile.get(++position, ByteBuffer.class);
            if (keyMetadata == null) {
                ((BlockBuilder)fieldBuilders.get(position)).appendNull();
            } else {
                VarbinaryType.VARBINARY.writeSlice((BlockBuilder)fieldBuilders.get(position), Slices.wrappedHeapBuffer((ByteBuffer)keyMetadata));
            }
            List splitOffsets = (List)dataFile.get(++position, List.class);
            EntriesTable.appendBigintArray((ArrayBlockBuilder)fieldBuilders.get(position), splitOffsets);
            List equalityIds = (List)dataFile.get(++position, List.class);
            EntriesTable.appendBigintArray((ArrayBlockBuilder)fieldBuilders.get(position), equalityIds);
            Integer sortOrderId = (Integer)dataFile.get(++position, Integer.class);
            IntegerType.INTEGER.writeLong((BlockBuilder)fieldBuilders.get(position), Long.valueOf(sortOrderId.intValue()).longValue());
        });
    }

    public static void appendBigintArray(ArrayBlockBuilder blockBuilder, @Nullable List<Long> values) {
        if (values == null) {
            blockBuilder.appendNull();
            return;
        }
        blockBuilder.buildEntry(elementBuilder -> {
            for (Long value : values) {
                BigintType.BIGINT.writeLong(elementBuilder, value.longValue());
            }
        });
    }

    private static void appendIntegerBigintMap(MapBlockBuilder blockBuilder, @Nullable Map<Integer, Long> values) {
        if (values == null) {
            blockBuilder.appendNull();
            return;
        }
        blockBuilder.buildEntry((keyBuilder, valueBuilder) -> values.forEach((key, value) -> {
            IntegerType.INTEGER.writeLong(keyBuilder, (long)key.intValue());
            BigintType.BIGINT.writeLong(valueBuilder, value.longValue());
        }));
    }

    private void appendIntegerVarcharMap(MapBlockBuilder blockBuilder, @Nullable Map<Integer, ByteBuffer> values) {
        if (values == null) {
            blockBuilder.appendNull();
            return;
        }
        blockBuilder.buildEntry((keyBuilder, valueBuilder) -> values.forEach((key, value) -> {
            Type type = this.idToTypeMapping.get(key);
            IntegerType.INTEGER.writeLong(keyBuilder, (long)key.intValue());
            VarcharType.VARCHAR.writeString(valueBuilder, Transforms.identity().toHumanString(type, Conversions.fromByteBuffer((Type)type, (ByteBuffer)value)));
        }));
    }
}

