/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Streams;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.plugin.base.util.JsonUtils;
import io.trino.plugin.iceberg.IcebergPartitionColumn;
import io.trino.plugin.iceberg.IcebergTypes;
import io.trino.plugin.iceberg.IcebergUtil;
import io.trino.plugin.iceberg.PartitionsTable;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.MapValueBuilder;
import io.trino.spi.block.RowValueBuilder;
import io.trino.spi.block.SqlMap;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.InMemoryRecordSet;
import io.trino.spi.connector.RecordCursor;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SystemTable;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.spi.type.TypeUtils;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import jakarta.annotation.Nullable;
import java.io.Closeable;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import org.apache.iceberg.DataTask;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.MetadataTableType;
import org.apache.iceberg.MetadataTableUtils;
import org.apache.iceberg.MetricsUtil;
import org.apache.iceberg.PartitionData;
import org.apache.iceberg.PartitionField;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SingleValueParser;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.io.CloseableGroup;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.CloseableIterator;
import org.apache.iceberg.transforms.Transforms;
import org.apache.iceberg.types.Conversions;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

public class FilesTable
implements SystemTable {
    private static final JsonFactory JSON_FACTORY = JsonUtils.jsonFactoryBuilder().build();
    private static final String CONTENT_COLUMN_NAME = "content";
    private static final String FILE_PATH_COLUMN_NAME = "file_path";
    private static final String FILE_FORMAT_COLUMN_NAME = "file_format";
    private static final String SPEC_ID_COLUMN_NAME = "spec_id";
    private static final String PARTITION_COLUMN_NAME = "partition";
    private static final String RECORD_COUNT_COLUMN_NAME = "record_count";
    private static final String FILE_SIZE_IN_BYTES_COLUMN_NAME = "file_size_in_bytes";
    private static final String COLUMN_SIZES_COLUMN_NAME = "column_sizes";
    private static final String VALUE_COUNTS_COLUMN_NAME = "value_counts";
    private static final String NULL_VALUE_COUNTS_COLUMN_NAME = "null_value_counts";
    private static final String NAN_VALUE_COUNTS_COLUMN_NAME = "nan_value_counts";
    private static final String LOWER_BOUNDS_COLUMN_NAME = "lower_bounds";
    private static final String UPPER_BOUNDS_COLUMN_NAME = "upper_bounds";
    private static final String KEY_METADATA_COLUMN_NAME = "key_metadata";
    private static final String SPLIT_OFFSETS_COLUMN_NAME = "split_offsets";
    private static final String EQUALITY_IDS_COLUMN_NAME = "equality_ids";
    private static final String SORT_ORDER_ID_COLUMN_NAME = "sort_order_id";
    private static final String READABLE_METRICS_COLUMN_NAME = "readable_metrics";
    private final ConnectorTableMetadata tableMetadata;
    private final TypeManager typeManager;
    private final Table icebergTable;
    private final Optional<Long> snapshotId;
    private final Optional<IcebergPartitionColumn> partitionColumnType;
    private final Map<Integer, Type.PrimitiveType> idToPrimitiveTypeMapping;
    private final List<Types.NestedField> primitiveFields;
    private final ExecutorService executor;

    public FilesTable(SchemaTableName tableName, TypeManager typeManager, Table icebergTable, Optional<Long> snapshotId, ExecutorService executor) {
        this.icebergTable = Objects.requireNonNull(icebergTable, "icebergTable is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        List<PartitionField> partitionFields = PartitionsTable.getAllPartitionFields(icebergTable);
        this.partitionColumnType = IcebergUtil.getPartitionColumnType(partitionFields, icebergTable.schema(), typeManager);
        this.idToPrimitiveTypeMapping = IcebergUtil.primitiveFieldTypes(icebergTable.schema());
        this.primitiveFields = (List)IcebergUtil.primitiveFields(icebergTable.schema()).stream().sorted(Comparator.comparing(Types.NestedField::name)).collect(ImmutableList.toImmutableList());
        ImmutableList.Builder columns = ImmutableList.builder();
        columns.add((Object)new ColumnMetadata(CONTENT_COLUMN_NAME, (io.trino.spi.type.Type)IntegerType.INTEGER));
        columns.add((Object)new ColumnMetadata(FILE_PATH_COLUMN_NAME, (io.trino.spi.type.Type)VarcharType.VARCHAR));
        columns.add((Object)new ColumnMetadata(FILE_FORMAT_COLUMN_NAME, (io.trino.spi.type.Type)VarcharType.VARCHAR));
        columns.add((Object)new ColumnMetadata(SPEC_ID_COLUMN_NAME, (io.trino.spi.type.Type)IntegerType.INTEGER));
        this.partitionColumnType.ifPresent(type -> columns.add((Object)new ColumnMetadata(PARTITION_COLUMN_NAME, (io.trino.spi.type.Type)type.rowType())));
        columns.add((Object)new ColumnMetadata(RECORD_COUNT_COLUMN_NAME, (io.trino.spi.type.Type)BigintType.BIGINT));
        columns.add((Object)new ColumnMetadata(FILE_SIZE_IN_BYTES_COLUMN_NAME, (io.trino.spi.type.Type)BigintType.BIGINT));
        columns.add((Object)new ColumnMetadata(COLUMN_SIZES_COLUMN_NAME, typeManager.getType(TypeSignature.mapType((TypeSignature)IntegerType.INTEGER.getTypeSignature(), (TypeSignature)BigintType.BIGINT.getTypeSignature()))));
        columns.add((Object)new ColumnMetadata(VALUE_COUNTS_COLUMN_NAME, typeManager.getType(TypeSignature.mapType((TypeSignature)IntegerType.INTEGER.getTypeSignature(), (TypeSignature)BigintType.BIGINT.getTypeSignature()))));
        columns.add((Object)new ColumnMetadata(NULL_VALUE_COUNTS_COLUMN_NAME, typeManager.getType(TypeSignature.mapType((TypeSignature)IntegerType.INTEGER.getTypeSignature(), (TypeSignature)BigintType.BIGINT.getTypeSignature()))));
        columns.add((Object)new ColumnMetadata(NAN_VALUE_COUNTS_COLUMN_NAME, typeManager.getType(TypeSignature.mapType((TypeSignature)IntegerType.INTEGER.getTypeSignature(), (TypeSignature)BigintType.BIGINT.getTypeSignature()))));
        columns.add((Object)new ColumnMetadata(LOWER_BOUNDS_COLUMN_NAME, typeManager.getType(TypeSignature.mapType((TypeSignature)IntegerType.INTEGER.getTypeSignature(), (TypeSignature)VarcharType.VARCHAR.getTypeSignature()))));
        columns.add((Object)new ColumnMetadata(UPPER_BOUNDS_COLUMN_NAME, typeManager.getType(TypeSignature.mapType((TypeSignature)IntegerType.INTEGER.getTypeSignature(), (TypeSignature)VarcharType.VARCHAR.getTypeSignature()))));
        columns.add((Object)new ColumnMetadata(KEY_METADATA_COLUMN_NAME, (io.trino.spi.type.Type)VarbinaryType.VARBINARY));
        columns.add((Object)new ColumnMetadata(SPLIT_OFFSETS_COLUMN_NAME, (io.trino.spi.type.Type)new ArrayType((io.trino.spi.type.Type)BigintType.BIGINT)));
        columns.add((Object)new ColumnMetadata(EQUALITY_IDS_COLUMN_NAME, (io.trino.spi.type.Type)new ArrayType((io.trino.spi.type.Type)IntegerType.INTEGER)));
        columns.add((Object)new ColumnMetadata(SORT_ORDER_ID_COLUMN_NAME, (io.trino.spi.type.Type)IntegerType.INTEGER));
        columns.add((Object)new ColumnMetadata(READABLE_METRICS_COLUMN_NAME, typeManager.getType(new TypeSignature("json", new TypeSignatureParameter[0]))));
        this.tableMetadata = new ConnectorTableMetadata(Objects.requireNonNull(tableName, "tableName is null"), (List)columns.build());
        this.snapshotId = Objects.requireNonNull(snapshotId, "snapshotId is null");
        this.executor = Objects.requireNonNull(executor, "executor is null");
    }

    public SystemTable.Distribution getDistribution() {
        return SystemTable.Distribution.SINGLE_COORDINATOR;
    }

    public ConnectorTableMetadata getTableMetadata() {
        return this.tableMetadata;
    }

    public RecordCursor cursor(ConnectorTransactionHandle transactionHandle, ConnectorSession session, TupleDomain<Integer> constraint) {
        List types = (List)this.tableMetadata.getColumns().stream().map(ColumnMetadata::getType).collect(ImmutableList.toImmutableList());
        if (this.snapshotId.isEmpty()) {
            return InMemoryRecordSet.builder((Collection)types).build().cursor();
        }
        Map<Integer, Type> idToTypeMapping = FilesTable.getIcebergIdToTypeMapping(this.icebergTable.schema());
        TableScan tableScan = (TableScan)((TableScan)MetadataTableUtils.createMetadataTableInstance((Table)this.icebergTable, (MetadataTableType)MetadataTableType.FILES).newScan().useSnapshot(this.snapshotId.get().longValue()).includeColumnStats()).planWith(this.executor);
        Map columnNameToPosition = (Map)Streams.mapWithIndex(tableScan.schema().columns().stream(), (column, position) -> Maps.immutableEntry((Object)column.name(), (Object)Long.valueOf(position).intValue())).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
        PlanFilesIterable planFilesIterable = new PlanFilesIterable((CloseableIterable<FileScanTask>)tableScan.planFiles(), this.primitiveFields, idToTypeMapping, types, columnNameToPosition, this.typeManager, this.partitionColumnType, PartitionsTable.getAllPartitionFields(this.icebergTable), this.idToPrimitiveTypeMapping);
        return planFilesIterable.cursor();
    }

    static String toJson(MetricsUtil.ReadableMetricsStruct readableMetrics, List<Types.NestedField> primitiveFields) {
        StringWriter writer = new StringWriter();
        try {
            JsonGenerator generator = JSON_FACTORY.createGenerator((Writer)writer);
            generator.writeStartObject();
            for (int i = 0; i < readableMetrics.size(); ++i) {
                Types.NestedField field = primitiveFields.get(i);
                generator.writeFieldName(field.name());
                generator.writeStartObject();
                MetricsUtil.ReadableColMetricsStruct columnMetrics = (MetricsUtil.ReadableColMetricsStruct)readableMetrics.get(i, MetricsUtil.ReadableColMetricsStruct.class);
                generator.writeFieldName("column_size");
                Long columnSize = (Long)columnMetrics.get(0, Long.class);
                if (columnSize == null) {
                    generator.writeNull();
                } else {
                    generator.writeNumber(columnSize.longValue());
                }
                generator.writeFieldName("value_count");
                Long valueCount = (Long)columnMetrics.get(1, Long.class);
                if (valueCount == null) {
                    generator.writeNull();
                } else {
                    generator.writeNumber(valueCount.longValue());
                }
                generator.writeFieldName("null_value_count");
                Long nullValueCount = (Long)columnMetrics.get(2, Long.class);
                if (nullValueCount == null) {
                    generator.writeNull();
                } else {
                    generator.writeNumber(nullValueCount.longValue());
                }
                generator.writeFieldName("nan_value_count");
                Long nanValueCount = (Long)columnMetrics.get(3, Long.class);
                if (nanValueCount == null) {
                    generator.writeNull();
                } else {
                    generator.writeNumber(nanValueCount.longValue());
                }
                generator.writeFieldName("lower_bound");
                SingleValueParser.toJson((Type)field.type(), (Object)columnMetrics.get(4, Object.class), (JsonGenerator)generator);
                generator.writeFieldName("upper_bound");
                SingleValueParser.toJson((Type)field.type(), (Object)columnMetrics.get(5, Object.class), (JsonGenerator)generator);
                generator.writeEndObject();
            }
            generator.writeEndObject();
            generator.flush();
            return writer.toString();
        }
        catch (IOException e) {
            throw new UncheckedIOException("JSON conversion failed for: " + String.valueOf(readableMetrics), e);
        }
    }

    static Map<Integer, Type> getIcebergIdToTypeMapping(Schema schema) {
        ImmutableMap.Builder icebergIdToTypeMapping = ImmutableMap.builder();
        for (Types.NestedField field : schema.columns()) {
            FilesTable.populateIcebergIdToTypeMapping(field, (ImmutableMap.Builder<Integer, Type>)icebergIdToTypeMapping);
        }
        return icebergIdToTypeMapping.buildOrThrow();
    }

    private static void populateIcebergIdToTypeMapping(Types.NestedField field, ImmutableMap.Builder<Integer, Type> icebergIdToTypeMapping) {
        Type type = field.type();
        icebergIdToTypeMapping.put((Object)field.fieldId(), (Object)type);
        if (type instanceof Type.NestedType) {
            type.asNestedType().fields().forEach(child -> FilesTable.populateIcebergIdToTypeMapping(child, icebergIdToTypeMapping));
        }
    }

    private static class PlanFilesIterable
    extends CloseableGroup
    implements Iterable<List<Object>> {
        private final CloseableIterable<FileScanTask> planFiles;
        private final List<Types.NestedField> primitiveFields;
        private final Map<Integer, Type> idToTypeMapping;
        private final List<io.trino.spi.type.Type> types;
        private final Map<String, Integer> columnNameToPosition;
        private boolean closed;
        private final MapType integerToBigintMapType;
        private final MapType integerToVarcharMapType;
        private final Optional<IcebergPartitionColumn> partitionColumnType;
        private final List<PartitionField> partitionFields;
        private final Map<Integer, Type.PrimitiveType> idToPrimitiveTypeMapping;

        public PlanFilesIterable(CloseableIterable<FileScanTask> planFiles, List<Types.NestedField> primitiveFields, Map<Integer, Type> idToTypeMapping, List<io.trino.spi.type.Type> types, Map<String, Integer> columnNameToPosition, TypeManager typeManager, Optional<IcebergPartitionColumn> partitionColumnType, List<PartitionField> partitionFields, Map<Integer, Type.PrimitiveType> idToPrimitiveTypeMapping) {
            this.planFiles = Objects.requireNonNull(planFiles, "planFiles is null");
            this.primitiveFields = ImmutableList.copyOf((Collection)Objects.requireNonNull(primitiveFields, "primitiveFields is null"));
            this.idToTypeMapping = ImmutableMap.copyOf(Objects.requireNonNull(idToTypeMapping, "idToTypeMapping is null"));
            this.types = ImmutableList.copyOf((Collection)Objects.requireNonNull(types, "types is null"));
            this.columnNameToPosition = ImmutableMap.copyOf(Objects.requireNonNull(columnNameToPosition, "columnNameToPosition is null"));
            this.integerToBigintMapType = new MapType((io.trino.spi.type.Type)IntegerType.INTEGER, (io.trino.spi.type.Type)BigintType.BIGINT, typeManager.getTypeOperators());
            this.integerToVarcharMapType = new MapType((io.trino.spi.type.Type)IntegerType.INTEGER, (io.trino.spi.type.Type)VarcharType.VARCHAR, typeManager.getTypeOperators());
            this.partitionColumnType = Objects.requireNonNull(partitionColumnType, "partitionColumnType is null");
            this.partitionFields = ImmutableList.copyOf((Collection)Objects.requireNonNull(partitionFields, "partitionFields is null"));
            this.idToPrimitiveTypeMapping = ImmutableMap.copyOf(Objects.requireNonNull(idToPrimitiveTypeMapping, "idToPrimitiveTypeMapping is null"));
            this.addCloseable((Closeable)planFiles);
        }

        public RecordCursor cursor() {
            CloseableIterator<List<Object>> iterator = this.iterator();
            return new InMemoryRecordSet.InMemoryRecordCursor(this, this.types, (Iterator)iterator, (CloseableIterator)iterator){
                final /* synthetic */ CloseableIterator val$iterator;
                {
                    this.val$iterator = closeableIterator;
                    super(types, records);
                }

                public void close() {
                    try (CloseableIterator closeableIterator = this.val$iterator;){
                        super.close();
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException("Failed to close cursor", e);
                    }
                }
            };
        }

        @Override
        public CloseableIterator<List<Object>> iterator() {
            final CloseableIterator planFilesIterator = this.planFiles.iterator();
            this.addCloseable((Closeable)planFilesIterator);
            return new CloseableIterator<List<Object>>(this){
                private CloseableIterator<StructLike> currentIterator = CloseableIterator.empty();
                final /* synthetic */ PlanFilesIterable this$0;
                {
                    this.this$0 = this$0;
                }

                public boolean hasNext() {
                    this.updateCurrentIterator();
                    return !this.this$0.closed && this.currentIterator.hasNext();
                }

                public List<Object> next() {
                    this.updateCurrentIterator();
                    return this.this$0.getRecord((StructLike)this.currentIterator.next());
                }

                private void updateCurrentIterator() {
                    try {
                        while (!this.this$0.closed && !this.currentIterator.hasNext() && planFilesIterator.hasNext()) {
                            this.currentIterator.close();
                            DataTask dataTask = (DataTask)planFilesIterator.next();
                            this.currentIterator = dataTask.rows().iterator();
                        }
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }

                public void close() throws IOException {
                    this.currentIterator.close();
                    PlanFilesIterable.super.close();
                    this.this$0.closed = true;
                }
            };
        }

        private List<Object> getRecord(StructLike structLike) {
            ArrayList<Object> columns = new ArrayList<Object>();
            columns.add(structLike.get(this.columnNameToPosition.get(FilesTable.CONTENT_COLUMN_NAME).intValue(), Integer.class));
            columns.add(structLike.get(this.columnNameToPosition.get(FilesTable.FILE_PATH_COLUMN_NAME).intValue(), String.class));
            columns.add(structLike.get(this.columnNameToPosition.get(FilesTable.FILE_FORMAT_COLUMN_NAME).intValue(), String.class));
            columns.add(structLike.get(this.columnNameToPosition.get(FilesTable.SPEC_ID_COLUMN_NAME).intValue(), Integer.class));
            if (this.columnNameToPosition.containsKey(FilesTable.PARTITION_COLUMN_NAME)) {
                List<Type> partitionTypes = IcebergUtil.partitionTypes(this.partitionFields, this.idToPrimitiveTypeMapping);
                StructLike partitionStruct = (StructLike)structLike.get(this.columnNameToPosition.get(FilesTable.PARTITION_COLUMN_NAME).intValue(), PartitionData.class);
                List partitionColumnTypes = (List)this.partitionColumnType.orElseThrow().rowType().getFields().stream().map(RowType.Field::getType).collect(ImmutableList.toImmutableList());
                if (partitionStruct != null) {
                    columns.add(RowValueBuilder.buildRowValue((RowType)this.partitionColumnType.get().rowType(), fields -> {
                        for (int i = 0; i < partitionColumnTypes.size(); ++i) {
                            Type type = (Type)partitionTypes.get(i);
                            io.trino.spi.type.Type trinoType = ((RowType.Field)this.partitionColumnType.get().rowType().getFields().get(i)).getType();
                            Object value = null;
                            Integer fieldId = this.partitionColumnType.get().fieldIds().get(i);
                            if (fieldId != null) {
                                value = IcebergTypes.convertIcebergValueToTrino(type, partitionStruct.get(i, type.typeId().javaClass()));
                            }
                            TypeUtils.writeNativeValue((io.trino.spi.type.Type)trinoType, (BlockBuilder)((BlockBuilder)fields.get(i)), value);
                        }
                    }));
                }
            }
            columns.add(structLike.get(this.columnNameToPosition.get(FilesTable.RECORD_COUNT_COLUMN_NAME).intValue(), Long.class));
            columns.add(structLike.get(this.columnNameToPosition.get(FilesTable.FILE_SIZE_IN_BYTES_COLUMN_NAME).intValue(), Long.class));
            columns.add(this.getIntegerBigintSqlMap((Map)structLike.get(this.columnNameToPosition.get(FilesTable.COLUMN_SIZES_COLUMN_NAME).intValue(), Map.class)));
            columns.add(this.getIntegerBigintSqlMap((Map)structLike.get(this.columnNameToPosition.get(FilesTable.VALUE_COUNTS_COLUMN_NAME).intValue(), Map.class)));
            columns.add(this.getIntegerBigintSqlMap((Map)structLike.get(this.columnNameToPosition.get(FilesTable.NULL_VALUE_COUNTS_COLUMN_NAME).intValue(), Map.class)));
            columns.add(this.getIntegerBigintSqlMap((Map)structLike.get(this.columnNameToPosition.get(FilesTable.NAN_VALUE_COUNTS_COLUMN_NAME).intValue(), Map.class)));
            columns.add(this.getIntegerVarcharSqlMap((Map)structLike.get(this.columnNameToPosition.get(FilesTable.LOWER_BOUNDS_COLUMN_NAME).intValue(), Map.class)));
            columns.add(this.getIntegerVarcharSqlMap((Map)structLike.get(this.columnNameToPosition.get(FilesTable.UPPER_BOUNDS_COLUMN_NAME).intValue(), Map.class)));
            columns.add(PlanFilesIterable.toVarbinarySlice((ByteBuffer)structLike.get(this.columnNameToPosition.get(FilesTable.KEY_METADATA_COLUMN_NAME).intValue(), ByteBuffer.class)));
            columns.add(PlanFilesIterable.toBigintArrayBlock((List)structLike.get(this.columnNameToPosition.get(FilesTable.SPLIT_OFFSETS_COLUMN_NAME).intValue(), List.class)));
            columns.add(PlanFilesIterable.toIntegerArrayBlock((List)structLike.get(this.columnNameToPosition.get(FilesTable.EQUALITY_IDS_COLUMN_NAME).intValue(), List.class)));
            columns.add(structLike.get(this.columnNameToPosition.get(FilesTable.SORT_ORDER_ID_COLUMN_NAME).intValue(), Integer.class));
            MetricsUtil.ReadableMetricsStruct readableMetrics = (MetricsUtil.ReadableMetricsStruct)structLike.get(this.columnNameToPosition.get(FilesTable.READABLE_METRICS_COLUMN_NAME).intValue(), MetricsUtil.ReadableMetricsStruct.class);
            columns.add(FilesTable.toJson(readableMetrics, this.primitiveFields));
            Preconditions.checkArgument((columns.size() == this.types.size() ? 1 : 0) != 0, (String)"Expected %s types in row, but got %s values", (int)this.types.size(), (int)columns.size());
            return columns;
        }

        private SqlMap getIntegerBigintSqlMap(Map<Integer, Long> value) {
            if (value == null) {
                return null;
            }
            return this.toIntegerBigintSqlMap(value);
        }

        private SqlMap getIntegerVarcharSqlMap(Map<Integer, ByteBuffer> value) {
            if (value == null) {
                return null;
            }
            return this.toIntegerVarcharSqlMap((Map)value.entrySet().stream().filter(entry -> this.idToTypeMapping.containsKey(entry.getKey())).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> Transforms.identity().toHumanString(this.idToTypeMapping.get(entry.getKey()), Conversions.fromByteBuffer((Type)this.idToTypeMapping.get(entry.getKey()), (ByteBuffer)((ByteBuffer)entry.getValue()))))));
        }

        private SqlMap toIntegerBigintSqlMap(Map<Integer, Long> values) {
            return MapValueBuilder.buildMapValue((MapType)this.integerToBigintMapType, (int)values.size(), (keyBuilder, valueBuilder) -> values.forEach((? super K key, ? super V value) -> {
                IntegerType.INTEGER.writeLong(keyBuilder, (long)key.intValue());
                BigintType.BIGINT.writeLong(valueBuilder, value.longValue());
            }));
        }

        private SqlMap toIntegerVarcharSqlMap(Map<Integer, String> values) {
            return MapValueBuilder.buildMapValue((MapType)this.integerToVarcharMapType, (int)values.size(), (keyBuilder, valueBuilder) -> values.forEach((? super K key, ? super V value) -> {
                IntegerType.INTEGER.writeLong(keyBuilder, (long)key.intValue());
                VarcharType.VARCHAR.writeString(valueBuilder, value);
            }));
        }

        @Nullable
        private static Block toIntegerArrayBlock(List<Integer> values) {
            if (values == null) {
                return null;
            }
            BlockBuilder builder = IntegerType.INTEGER.createFixedSizeBlockBuilder(values.size());
            values.forEach(value -> IntegerType.INTEGER.writeLong(builder, (long)value.intValue()));
            return builder.build();
        }

        @Nullable
        private static Block toBigintArrayBlock(List<Long> values) {
            if (values == null) {
                return null;
            }
            BlockBuilder builder = BigintType.BIGINT.createFixedSizeBlockBuilder(values.size());
            values.forEach(value -> BigintType.BIGINT.writeLong(builder, value.longValue()));
            return builder.build();
        }

        @Nullable
        private static Slice toVarbinarySlice(ByteBuffer value) {
            if (value == null) {
                return null;
            }
            return Slices.wrappedHeapBuffer((ByteBuffer)value);
        }
    }
}

