/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.InMemoryRecordSet;
import io.trino.spi.connector.RecordCursor;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SystemTable;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.Table;
import org.apache.iceberg.util.SnapshotUtil;

public class HistoryTable
implements SystemTable {
    private final ConnectorTableMetadata tableMetadata;
    private final Table icebergTable;
    private static final List<ColumnMetadata> COLUMNS = ImmutableList.builder().add((Object)new ColumnMetadata("made_current_at", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS)).add((Object)new ColumnMetadata("snapshot_id", (Type)BigintType.BIGINT)).add((Object)new ColumnMetadata("parent_id", (Type)BigintType.BIGINT)).add((Object)new ColumnMetadata("is_current_ancestor", (Type)BooleanType.BOOLEAN)).build();

    public HistoryTable(SchemaTableName tableName, Table icebergTable) {
        this.tableMetadata = new ConnectorTableMetadata(Objects.requireNonNull(tableName, "tableName is null"), COLUMNS);
        this.icebergTable = Objects.requireNonNull(icebergTable, "icebergTable is null");
    }

    public SystemTable.Distribution getDistribution() {
        return SystemTable.Distribution.SINGLE_COORDINATOR;
    }

    public ConnectorTableMetadata getTableMetadata() {
        return this.tableMetadata;
    }

    public RecordCursor cursor(ConnectorTransactionHandle transactionHandle, ConnectorSession session, TupleDomain<Integer> constraint) {
        InMemoryRecordSet.Builder table = InMemoryRecordSet.builder(COLUMNS);
        ImmutableSet ancestorIds = ImmutableSet.copyOf((Collection)SnapshotUtil.currentAncestorIds((Table)this.icebergTable));
        TimeZoneKey timeZoneKey = session.getTimeZoneKey();
        for (Snapshot snapshot : this.icebergTable.snapshots()) {
            long snapshotId = snapshot.snapshotId();
            table.addRow(new Object[]{DateTimeEncoding.packDateTimeWithZone((long)snapshot.timestampMillis(), (TimeZoneKey)timeZoneKey), snapshotId, snapshot.parentId(), ancestorIds.contains(snapshotId)});
        }
        return table.build().cursor();
    }
}

