/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.base.Throwables;
import io.trino.plugin.iceberg.IcebergErrorCode;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import java.io.FileNotFoundException;
import org.apache.iceberg.exceptions.NotFoundException;
import org.apache.iceberg.exceptions.ValidationException;

public final class IcebergExceptions {
    private IcebergExceptions() {
    }

    private static boolean isNotFoundException(Throwable failure) {
        return Throwables.getCausalChain((Throwable)failure).stream().anyMatch(e -> e instanceof NotFoundException || e instanceof FileNotFoundException);
    }

    public static boolean isFatalException(Throwable failure) {
        return IcebergExceptions.isNotFoundException(failure) || failure instanceof ValidationException;
    }

    public static RuntimeException translateMetadataException(Throwable failure, String tableName) {
        if (failure instanceof TrinoException) {
            TrinoException trinoException = (TrinoException)failure;
            return trinoException;
        }
        if (IcebergExceptions.isNotFoundException(failure)) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_MISSING_METADATA, "Metadata not found in metadata location for table " + tableName, failure);
        }
        if (failure instanceof ValidationException) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_INVALID_METADATA, "Invalid metadata file for table " + tableName, failure);
        }
        return new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Error processing metadata for table " + tableName, failure);
    }
}

