/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import org.apache.iceberg.FileFormat;

public enum IcebergFileFormat {
    ORC,
    PARQUET,
    AVRO;


    public FileFormat toIceberg() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> FileFormat.ORC;
            case 1 -> FileFormat.PARQUET;
            case 2 -> FileFormat.AVRO;
        };
    }

    public static IcebergFileFormat fromIceberg(FileFormat format) {
        return switch (format) {
            default -> throw new MatchException(null, null);
            case FileFormat.ORC -> ORC;
            case FileFormat.PARQUET -> PARQUET;
            case FileFormat.AVRO -> AVRO;
            case FileFormat.METADATA -> throw new IllegalArgumentException("Unexpected METADATA file format");
        };
    }

    public String humanName() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 2 -> "Avro";
            case 0 -> "ORC";
            case 1 -> "Parquet";
        };
    }
}

