/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.inject.Provider;
import io.airlift.json.JsonCodec;
import io.airlift.json.JsonCodecFactory;
import io.airlift.json.ObjectMapperProvider;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.util.HiveUtil;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.connector.CatalogSchemaName;
import io.trino.spi.connector.ConnectorMaterializedViewDefinition;
import io.trino.spi.type.TypeId;
import java.time.Duration;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.stream.Collectors;

public record IcebergMaterializedViewDefinition(String originalSql, Optional<String> catalog, Optional<String> schema, List<Column> columns, Optional<Duration> gracePeriod, Optional<String> comment, List<CatalogSchemaName> path) {
    private static final String MATERIALIZED_VIEW_PREFIX = "/* Presto Materialized View: ";
    private static final String MATERIALIZED_VIEW_SUFFIX = " */";
    private static final JsonCodec<IcebergMaterializedViewDefinition> materializedViewCodec = new JsonCodecFactory((Provider)new ObjectMapperProvider()).jsonCodec(IcebergMaterializedViewDefinition.class);

    public IcebergMaterializedViewDefinition {
        Objects.requireNonNull(originalSql, "originalSql is null");
        Objects.requireNonNull(catalog, "catalog is null");
        Objects.requireNonNull(schema, "schema is null");
        columns = List.copyOf((Collection)Objects.requireNonNull(columns, "columns is null"));
        Preconditions.checkArgument((gracePeriod.isEmpty() || !gracePeriod.get().isNegative() ? 1 : 0) != 0, (String)"gracePeriod cannot be negative: %s", gracePeriod);
        Objects.requireNonNull(comment, "comment is null");
        ImmutableList immutableList = path = path == null ? ImmutableList.of() : ImmutableList.copyOf(path);
        if (catalog.isEmpty() && schema.isPresent()) {
            throw new IllegalArgumentException("catalog must be present if schema is present");
        }
        if (columns.isEmpty()) {
            throw new IllegalArgumentException("columns list is empty");
        }
    }

    public static String encodeMaterializedViewData(IcebergMaterializedViewDefinition definition) {
        byte[] bytes = materializedViewCodec.toJsonBytes((Object)definition);
        String data = Base64.getEncoder().encodeToString(bytes);
        return MATERIALIZED_VIEW_PREFIX + data + MATERIALIZED_VIEW_SUFFIX;
    }

    public static IcebergMaterializedViewDefinition decodeMaterializedViewData(String data) {
        HiveUtil.checkCondition((boolean)data.startsWith(MATERIALIZED_VIEW_PREFIX), (ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_VIEW_DATA, (String)"Materialized View data missing prefix: %s", (Object[])new Object[]{data});
        HiveUtil.checkCondition((boolean)data.endsWith(MATERIALIZED_VIEW_SUFFIX), (ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_VIEW_DATA, (String)"Materialized View data missing suffix: %s", (Object[])new Object[]{data});
        data = data.substring(MATERIALIZED_VIEW_PREFIX.length());
        data = data.substring(0, data.length() - MATERIALIZED_VIEW_SUFFIX.length());
        byte[] bytes = Base64.getDecoder().decode(data);
        return (IcebergMaterializedViewDefinition)materializedViewCodec.fromJson(bytes);
    }

    public static IcebergMaterializedViewDefinition fromConnectorMaterializedViewDefinition(ConnectorMaterializedViewDefinition definition) {
        return new IcebergMaterializedViewDefinition(definition.getOriginalSql(), definition.getCatalog(), definition.getSchema(), (List)definition.getColumns().stream().map(column -> new Column(column.getName(), column.getType(), column.getComment())).collect(ImmutableList.toImmutableList()), definition.getGracePeriod(), definition.getComment(), definition.getPath());
    }

    @Override
    public String toString() {
        StringJoiner joiner = new StringJoiner(", ", "[", "]");
        joiner.add("originalSql=[" + this.originalSql + "]");
        this.catalog.ifPresent(value -> joiner.add("catalog=" + value));
        this.schema.ifPresent(value -> joiner.add("schema=" + value));
        joiner.add("columns=" + String.valueOf(this.columns));
        this.gracePeriod.ifPresent(value -> joiner.add("gracePeriod\u2265=" + String.valueOf(value)));
        this.comment.ifPresent(value -> joiner.add("comment=" + value));
        joiner.add(this.path.stream().map(CatalogSchemaName::toString).collect(Collectors.joining(", ", "path=(", ")")));
        return this.getClass().getSimpleName() + String.valueOf(joiner);
    }

    public record Column(String name, TypeId type, Optional<String> comment) {
        public Column {
            Objects.requireNonNull(name, "name is null");
            Objects.requireNonNull(type, "type is null");
            Objects.requireNonNull(comment, "comment is null");
        }

        @Override
        public String toString() {
            return this.name + " " + String.valueOf(this.type);
        }
    }
}

