/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.collect.ImmutableMap;
import io.airlift.json.JsonCodec;
import io.airlift.slice.Slice;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.plugin.base.util.Closables;
import io.trino.plugin.iceberg.CommitTaskData;
import io.trino.plugin.iceberg.IcebergFileFormat;
import io.trino.plugin.iceberg.IcebergFileWriterFactory;
import io.trino.plugin.iceberg.PartitionData;
import io.trino.plugin.iceberg.delete.PositionDeleteWriter;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.RowBlock;
import io.trino.spi.connector.ConnectorMergeSink;
import io.trino.spi.connector.ConnectorPageSink;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.MergePage;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.VarcharType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.io.LocationProvider;
import org.apache.iceberg.types.Type;
import org.roaringbitmap.longlong.ImmutableLongBitmapDataProvider;
import org.roaringbitmap.longlong.LongBitmapDataProvider;
import org.roaringbitmap.longlong.Roaring64Bitmap;

public class IcebergMergeSink
implements ConnectorMergeSink {
    private final LocationProvider locationProvider;
    private final IcebergFileWriterFactory fileWriterFactory;
    private final TrinoFileSystem fileSystem;
    private final JsonCodec<CommitTaskData> jsonCodec;
    private final ConnectorSession session;
    private final IcebergFileFormat fileFormat;
    private final Map<String, String> storageProperties;
    private final Schema schema;
    private final Map<Integer, PartitionSpec> partitionsSpecs;
    private final ConnectorPageSink insertPageSink;
    private final int columnCount;
    private final Map<Slice, FileDeletion> fileDeletions = new HashMap<Slice, FileDeletion>();

    public IcebergMergeSink(LocationProvider locationProvider, IcebergFileWriterFactory fileWriterFactory, TrinoFileSystem fileSystem, JsonCodec<CommitTaskData> jsonCodec, ConnectorSession session, IcebergFileFormat fileFormat, Map<String, String> storageProperties, Schema schema, Map<Integer, PartitionSpec> partitionsSpecs, ConnectorPageSink insertPageSink, int columnCount) {
        this.locationProvider = Objects.requireNonNull(locationProvider, "locationProvider is null");
        this.fileWriterFactory = Objects.requireNonNull(fileWriterFactory, "fileWriterFactory is null");
        this.fileSystem = Objects.requireNonNull(fileSystem, "fileSystem is null");
        this.jsonCodec = Objects.requireNonNull(jsonCodec, "jsonCodec is null");
        this.session = Objects.requireNonNull(session, "session is null");
        this.fileFormat = Objects.requireNonNull(fileFormat, "fileFormat is null");
        this.storageProperties = ImmutableMap.copyOf(Objects.requireNonNull(storageProperties, "storageProperties is null"));
        this.schema = Objects.requireNonNull(schema, "schema is null");
        this.partitionsSpecs = ImmutableMap.copyOf(Objects.requireNonNull(partitionsSpecs, "partitionsSpecs is null"));
        this.insertPageSink = Objects.requireNonNull(insertPageSink, "insertPageSink is null");
        this.columnCount = columnCount;
    }

    public void storeMergedRows(Page page) {
        MergePage mergePage = MergePage.createDeleteAndInsertPages((Page)page, (int)this.columnCount);
        mergePage.getInsertionsPage().ifPresent(arg_0 -> ((ConnectorPageSink)this.insertPageSink).appendPage(arg_0));
        mergePage.getDeletionsPage().ifPresent(deletions -> {
            List fields = RowBlock.getRowFieldsFromBlock((Block)deletions.getBlock(deletions.getChannelCount() - 1));
            Block fieldPathBlock = (Block)fields.get(0);
            Block rowPositionBlock = (Block)fields.get(1);
            Block partitionSpecIdBlock = (Block)fields.get(2);
            Block partitionDataBlock = (Block)fields.get(3);
            int position = 0;
            while (position < fieldPathBlock.getPositionCount()) {
                Slice filePath = VarcharType.VARCHAR.getSlice(fieldPathBlock, position);
                long rowPosition = BigintType.BIGINT.getLong(rowPositionBlock, position);
                int index = position++;
                FileDeletion deletion = this.fileDeletions.computeIfAbsent(filePath, slice -> {
                    int partitionSpecId = IntegerType.INTEGER.getInt(partitionSpecIdBlock, index);
                    String partitionData = VarcharType.VARCHAR.getSlice(partitionDataBlock, index).toStringUtf8();
                    return new FileDeletion(partitionSpecId, partitionData);
                });
                deletion.rowsToDelete().addLong(rowPosition);
            }
        });
    }

    public CompletableFuture<Collection<Slice>> finish() {
        ArrayList fragments = new ArrayList((Collection)this.insertPageSink.finish().join());
        this.fileDeletions.forEach((dataFilePath, deletion) -> {
            PositionDeleteWriter writer = this.createPositionDeleteWriter(dataFilePath.toStringUtf8(), this.partitionsSpecs.get(deletion.partitionSpecId()), deletion.partitionDataJson());
            fragments.addAll(IcebergMergeSink.writePositionDeletes(writer, (ImmutableLongBitmapDataProvider)deletion.rowsToDelete()));
        });
        return CompletableFuture.completedFuture(fragments);
    }

    public void abort() {
        this.insertPageSink.abort();
    }

    private PositionDeleteWriter createPositionDeleteWriter(String dataFilePath, PartitionSpec partitionSpec, String partitionDataJson) {
        Optional<PartitionData> partitionData = Optional.empty();
        if (partitionSpec.isPartitioned()) {
            Type[] columnTypes = (Type[])partitionSpec.fields().stream().map(field -> field.transform().getResultType(this.schema.findType(field.sourceId()))).toArray(Type[]::new);
            partitionData = Optional.of(PartitionData.fromJson(partitionDataJson, columnTypes));
        }
        return new PositionDeleteWriter(dataFilePath, partitionSpec, partitionData, this.locationProvider, this.fileWriterFactory, this.fileSystem, this.jsonCodec, this.session, this.fileFormat, this.storageProperties);
    }

    private static Collection<Slice> writePositionDeletes(PositionDeleteWriter writer, ImmutableLongBitmapDataProvider rowsToDelete) {
        try {
            return writer.write(rowsToDelete);
        }
        catch (Throwable t) {
            AutoCloseable[] autoCloseableArray = new AutoCloseable[1];
            autoCloseableArray[0] = writer::abort;
            Closables.closeAllSuppress((Throwable)t, (AutoCloseable[])autoCloseableArray);
            throw t;
        }
    }

    private static class FileDeletion {
        private final int partitionSpecId;
        private final String partitionDataJson;
        private final LongBitmapDataProvider rowsToDelete = new Roaring64Bitmap();

        public FileDeletion(int partitionSpecId, String partitionDataJson) {
            this.partitionSpecId = partitionSpecId;
            this.partitionDataJson = Objects.requireNonNull(partitionDataJson, "partitionDataJson is null");
        }

        public int partitionSpecId() {
            return this.partitionSpecId;
        }

        public String partitionDataJson() {
            return this.partitionDataJson;
        }

        public LongBitmapDataProvider rowsToDelete() {
            return this.rowsToDelete;
        }
    }
}

