/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.collect.ImmutableSet;
import io.trino.plugin.iceberg.ColumnIdentity;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.iceberg.MetadataColumns;

public enum IcebergMetadataColumn {
    FILE_PATH(MetadataColumns.FILE_PATH.fieldId(), "$path", (Type)VarcharType.VARCHAR, ColumnIdentity.TypeCategory.PRIMITIVE),
    FILE_MODIFIED_TIME(2147482646, "$file_modified_time", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, ColumnIdentity.TypeCategory.PRIMITIVE);

    private static final Set<Integer> COLUMNS_ID;
    private final int id;
    private final String columnName;
    private final Type type;
    private final ColumnIdentity.TypeCategory typeCategory;

    private IcebergMetadataColumn(int id, String columnName, Type type, ColumnIdentity.TypeCategory typeCategory) {
        this.id = id;
        this.columnName = columnName;
        this.type = type;
        this.typeCategory = typeCategory;
    }

    public int getId() {
        return this.id;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public Type getType() {
        return this.type;
    }

    public ColumnIdentity.TypeCategory getTypeCategory() {
        return this.typeCategory;
    }

    public static boolean isMetadataColumnId(int id) {
        return COLUMNS_ID.contains(id);
    }

    static {
        COLUMNS_ID = (Set)Stream.of(IcebergMetadataColumn.values()).map(IcebergMetadataColumn::getId).collect(ImmutableSet.toImmutableSet());
    }
}

