/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import io.trino.plugin.base.util.Closables;
import io.trino.plugin.hive.ReaderProjectionsAdapter;
import io.trino.plugin.iceberg.IcebergColumnHandle;
import io.trino.plugin.iceberg.IcebergErrorCode;
import io.trino.plugin.iceberg.delete.RowPredicate;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Page;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.RowBlock;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.metrics.Metrics;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Supplier;

public class IcebergPageSource
implements ConnectorPageSource {
    private final int[] expectedColumnIndexes;
    private final ConnectorPageSource delegate;
    private final Optional<ReaderProjectionsAdapter> projectionsAdapter;
    private final Supplier<Optional<RowPredicate>> deletePredicate;
    private final Function<Block, RowBlock> rowIdBlockFactory;
    private int rowIdColumnIndex = -1;

    public IcebergPageSource(List<IcebergColumnHandle> expectedColumns, List<IcebergColumnHandle> requiredColumns, ConnectorPageSource delegate, Optional<ReaderProjectionsAdapter> projectionsAdapter, Supplier<Optional<RowPredicate>> deletePredicate, Function<Block, RowBlock> rowIdBlockFactory) {
        Objects.requireNonNull(expectedColumns, "expectedColumns is null");
        Objects.requireNonNull(requiredColumns, "requiredColumns is null");
        this.expectedColumnIndexes = new int[expectedColumns.size()];
        for (int i = 0; i < expectedColumns.size(); ++i) {
            IcebergColumnHandle expectedColumn = expectedColumns.get(i);
            Preconditions.checkArgument((boolean)expectedColumn.equals(requiredColumns.get(i)), (Object)"Expected columns must be a prefix of required columns");
            this.expectedColumnIndexes[i] = i;
            if (!expectedColumn.isMergeRowIdColumn()) continue;
            this.rowIdColumnIndex = i;
        }
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.projectionsAdapter = Objects.requireNonNull(projectionsAdapter, "projectionsAdapter is null");
        this.deletePredicate = Objects.requireNonNull(deletePredicate, "deletePredicate is null");
        this.rowIdBlockFactory = Objects.requireNonNull(rowIdBlockFactory, "rowIdBlockFactory is null");
    }

    public long getCompletedBytes() {
        return this.delegate.getCompletedBytes();
    }

    public OptionalLong getCompletedPositions() {
        return this.delegate.getCompletedPositions();
    }

    public long getReadTimeNanos() {
        return this.delegate.getReadTimeNanos();
    }

    public boolean isFinished() {
        return this.delegate.isFinished();
    }

    public CompletableFuture<?> isBlocked() {
        return this.delegate.isBlocked();
    }

    public Page getNextPage() {
        try {
            Page dataPage = this.delegate.getNextPage();
            if (dataPage == null) {
                return null;
            }
            Optional<RowPredicate> deleteFilterPredicate = this.deletePredicate.get();
            if (deleteFilterPredicate.isPresent()) {
                dataPage = deleteFilterPredicate.get().filterPage(dataPage);
            }
            if (this.projectionsAdapter.isPresent()) {
                dataPage = this.projectionsAdapter.get().adaptPage(dataPage);
            }
            dataPage = this.withRowIdBlock(dataPage);
            dataPage = dataPage.getColumns(this.expectedColumnIndexes);
            return dataPage;
        }
        catch (RuntimeException e) {
            this.closeWithSuppression(e);
            Throwables.throwIfInstanceOf((Throwable)e, TrinoException.class);
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_BAD_DATA, (Throwable)e);
        }
    }

    private Page withRowIdBlock(Page page) {
        if (this.rowIdColumnIndex == -1) {
            return page;
        }
        RowBlock rowIdBlock = this.rowIdBlockFactory.apply(page.getBlock(this.rowIdColumnIndex));
        Block[] fullPage = new Block[page.getChannelCount()];
        for (int channel = 0; channel < page.getChannelCount(); ++channel) {
            fullPage[channel] = channel == this.rowIdColumnIndex ? rowIdBlock : page.getBlock(channel);
        }
        return new Page(page.getPositionCount(), fullPage);
    }

    public void close() {
        try {
            this.delegate.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public String toString() {
        return this.delegate.toString();
    }

    public long getMemoryUsage() {
        return this.delegate.getMemoryUsage();
    }

    public Metrics getMetrics() {
        return this.delegate.getMetrics();
    }

    protected void closeWithSuppression(Throwable throwable) {
        Closables.closeAllSuppress((Throwable)throwable, (AutoCloseable[])new AutoCloseable[]{this});
    }
}

