/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.google.common.base.Verify;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoInputFile;
import io.trino.memory.context.AggregatedMemoryContext;
import io.trino.orc.OrcColumn;
import io.trino.orc.OrcCorruptionException;
import io.trino.orc.OrcDataSource;
import io.trino.orc.OrcDataSourceId;
import io.trino.orc.OrcPredicate;
import io.trino.orc.OrcReader;
import io.trino.orc.OrcReaderOptions;
import io.trino.orc.OrcRecordReader;
import io.trino.orc.TupleDomainOrcPredicate;
import io.trino.parquet.Column;
import io.trino.parquet.Field;
import io.trino.parquet.ParquetCorruptionException;
import io.trino.parquet.ParquetDataSource;
import io.trino.parquet.ParquetDataSourceId;
import io.trino.parquet.ParquetReaderOptions;
import io.trino.parquet.ParquetTypeUtils;
import io.trino.parquet.metadata.FileMetadata;
import io.trino.parquet.metadata.ParquetMetadata;
import io.trino.parquet.predicate.PredicateUtils;
import io.trino.parquet.predicate.TupleDomainParquetPredicate;
import io.trino.parquet.reader.MetadataReader;
import io.trino.parquet.reader.ParquetReader;
import io.trino.parquet.reader.RowGroupInfo;
import io.trino.plugin.base.metrics.FileFormatDataSourceStats;
import io.trino.plugin.hive.ReaderColumns;
import io.trino.plugin.hive.ReaderPageSource;
import io.trino.plugin.hive.ReaderProjectionsAdapter;
import io.trino.plugin.hive.orc.OrcPageSource;
import io.trino.plugin.hive.parquet.ParquetPageSource;
import io.trino.plugin.hive.parquet.ParquetPageSourceFactory;
import io.trino.plugin.iceberg.ColumnIdentity;
import io.trino.plugin.iceberg.ConstantPopulatingPageSource;
import io.trino.plugin.iceberg.IcebergAvroPageSource;
import io.trino.plugin.iceberg.IcebergColumnHandle;
import io.trino.plugin.iceberg.IcebergErrorCode;
import io.trino.plugin.iceberg.IcebergFileFormat;
import io.trino.plugin.iceberg.IcebergFileSystemFactory;
import io.trino.plugin.iceberg.IcebergMetadataColumn;
import io.trino.plugin.iceberg.IcebergPageSource;
import io.trino.plugin.iceberg.IcebergParquetColumnIOConverter;
import io.trino.plugin.iceberg.IcebergSessionProperties;
import io.trino.plugin.iceberg.IcebergSplit;
import io.trino.plugin.iceberg.IcebergSplitSource;
import io.trino.plugin.iceberg.IcebergTableHandle;
import io.trino.plugin.iceberg.IcebergUtil;
import io.trino.plugin.iceberg.PartitionData;
import io.trino.plugin.iceberg.TrinoOrcDataSource;
import io.trino.plugin.iceberg.delete.DeleteFile;
import io.trino.plugin.iceberg.delete.DeleteManager;
import io.trino.plugin.iceberg.delete.RowPredicate;
import io.trino.plugin.iceberg.fileio.ForwardingInputFile;
import io.trino.plugin.iceberg.util.OrcIcebergIds;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Page;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.IntArrayBlock;
import io.trino.spi.block.RowBlock;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.block.VariableWidthBlock;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.ConnectorPageSourceProvider;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.connector.EmptyPageSource;
import io.trino.spi.connector.FixedPageSource;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.NullableValue;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.predicate.Utils;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.UuidType;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileStream;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.io.DatumReader;
import org.apache.iceberg.FileContent;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PartitionSpecParser;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.avro.AvroSchemaUtil;
import org.apache.iceberg.mapping.MappedField;
import org.apache.iceberg.mapping.MappedFields;
import org.apache.iceberg.mapping.NameMapping;
import org.apache.iceberg.mapping.NameMappingParser;
import org.apache.iceberg.parquet.ParquetSchemaUtil;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.StructLikeWrapper;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.io.ColumnIO;
import org.apache.parquet.io.MessageColumnIO;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.joda.time.DateTimeZone;

public class IcebergPageSourceProvider
implements ConnectorPageSourceProvider {
    private static final String AVRO_FIELD_ID = "field-id";
    private static final int MAX_RLE_PAGE_SIZE = 131072;
    private final IcebergFileSystemFactory fileSystemFactory;
    private final FileFormatDataSourceStats fileFormatDataSourceStats;
    private final OrcReaderOptions orcReaderOptions;
    private final ParquetReaderOptions parquetReaderOptions;
    private final TypeManager typeManager;
    private final DeleteManager unpartitionedTableDeleteManager;
    private final Map<Integer, Function<PartitionData, PartitionKey>> partitionKeyFactories = new ConcurrentHashMap<Integer, Function<PartitionData, PartitionKey>>();
    private final Map<PartitionKey, DeleteManager> partitionedDeleteManagers = new ConcurrentHashMap<PartitionKey, DeleteManager>();

    public IcebergPageSourceProvider(IcebergFileSystemFactory fileSystemFactory, FileFormatDataSourceStats fileFormatDataSourceStats, OrcReaderOptions orcReaderOptions, ParquetReaderOptions parquetReaderOptions, TypeManager typeManager) {
        this.fileSystemFactory = Objects.requireNonNull(fileSystemFactory, "fileSystemFactory is null");
        this.fileFormatDataSourceStats = Objects.requireNonNull(fileFormatDataSourceStats, "fileFormatDataSourceStats is null");
        this.orcReaderOptions = Objects.requireNonNull(orcReaderOptions, "orcReaderOptions is null");
        this.parquetReaderOptions = Objects.requireNonNull(parquetReaderOptions, "parquetReaderOptions is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.unpartitionedTableDeleteManager = new DeleteManager(typeManager);
    }

    public ConnectorPageSource createPageSource(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorSplit connectorSplit, ConnectorTableHandle connectorTable, List<ColumnHandle> columns, DynamicFilter dynamicFilter) {
        IcebergSplit split = (IcebergSplit)connectorSplit;
        List icebergColumns = (List)columns.stream().map(IcebergColumnHandle.class::cast).collect(ImmutableList.toImmutableList());
        IcebergTableHandle tableHandle = (IcebergTableHandle)connectorTable;
        org.apache.iceberg.Schema schema = SchemaParser.fromJson((String)tableHandle.getTableSchemaJson());
        PartitionSpec partitionSpec = PartitionSpecParser.fromJson((org.apache.iceberg.Schema)schema, (String)split.getPartitionSpecJson());
        Type[] partitionColumnTypes = (Type[])partitionSpec.fields().stream().map(field -> field.transform().getResultType(schema.findType(field.sourceId()))).toArray(Type[]::new);
        return this.createPageSource(session, icebergColumns, schema, partitionSpec, PartitionData.fromJson(split.getPartitionDataJson(), partitionColumnTypes), split.getDeletes(), dynamicFilter, tableHandle.getUnenforcedPredicate(), split.getFileStatisticsDomain(), split.getPath(), split.getStart(), split.getLength(), split.getFileSize(), split.getFileRecordCount(), split.getPartitionDataJson(), split.getFileFormat(), split.getFileIoProperties(), split.getDataSequenceNumber(), tableHandle.getNameMappingJson().map(NameMappingParser::fromJson));
    }

    public ConnectorPageSource createPageSource(ConnectorSession session, List<IcebergColumnHandle> icebergColumns, org.apache.iceberg.Schema tableSchema, PartitionSpec partitionSpec, PartitionData partitionData, List<DeleteFile> deletes, DynamicFilter dynamicFilter, TupleDomain<IcebergColumnHandle> unenforcedPredicate, TupleDomain<IcebergColumnHandle> fileStatisticsDomain, String path, long start, long length, long fileSize, long fileRecordCount, String partitionDataJson, IcebergFileFormat fileFormat, Map<String, String> fileIoProperties, long dataSequenceNumber, Optional<NameMapping> nameMapping) {
        Set<IcebergColumnHandle> deleteFilterRequiredColumns = this.requiredColumnsForDeletes(tableSchema, deletes);
        Map<Integer, Optional<String>> partitionKeys = IcebergUtil.getPartitionKeys(partitionData, partitionSpec);
        ArrayList<IcebergColumnHandle> requiredColumns = new ArrayList<IcebergColumnHandle>(icebergColumns);
        deleteFilterRequiredColumns.stream().filter(Predicate.not(icebergColumns::contains)).forEach(requiredColumns::add);
        TupleDomain<IcebergColumnHandle> effectivePredicate = this.getUnenforcedPredicate(tableSchema, partitionKeys, dynamicFilter, unenforcedPredicate, fileStatisticsDomain);
        if (effectivePredicate.isNone()) {
            return new EmptyPageSource();
        }
        TrinoFileSystem fileSystem = this.fileSystemFactory.create(session.getIdentity(), fileIoProperties);
        TrinoInputFile inputfile = IcebergSessionProperties.isUseFileSizeFromMetadata(session) ? fileSystem.newInputFile(Location.of((String)path), fileSize) : fileSystem.newInputFile(Location.of((String)path));
        try {
            if (effectivePredicate.isAll() && start == 0L && length == inputfile.length() && deletes.isEmpty() && icebergColumns.stream().allMatch(column -> partitionKeys.containsKey(column.getId()))) {
                return IcebergPageSourceProvider.generatePages(fileRecordCount, icebergColumns, partitionKeys);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        ReaderPageSourceWithRowPositions readerPageSourceWithRowPositions = this.createDataPageSource(session, inputfile, start, length, fileSize, fileFormat, tableSchema, requiredColumns, effectivePredicate, nameMapping, partitionKeys);
        ReaderPageSource dataPageSource = readerPageSourceWithRowPositions.readerPageSource();
        Optional<ReaderProjectionsAdapter> projectionsAdapter = dataPageSource.getReaderColumns().map(readerColumns -> new ReaderProjectionsAdapter(requiredColumns, readerColumns, column -> ((IcebergColumnHandle)column).getType(), IcebergPageSourceProvider::applyProjection));
        List readColumns = dataPageSource.getReaderColumns().map(readerColumns -> readerColumns.get().stream().map(IcebergColumnHandle.class::cast).collect(Collectors.toList())).orElse(requiredColumns);
        com.google.common.base.Supplier deletePredicate = Suppliers.memoize(() -> this.getDeleteManager(partitionSpec, partitionData).getDeletePredicate(path, dataSequenceNumber, deletes, readColumns, tableSchema, readerPageSourceWithRowPositions, (deleteFile, deleteColumns, tupleDomain) -> this.openDeletes(session, fileSystem, deleteFile, deleteColumns, (TupleDomain<IcebergColumnHandle>)tupleDomain)));
        return new IcebergPageSource(icebergColumns, requiredColumns, dataPageSource.get(), projectionsAdapter, (Supplier<Optional<RowPredicate>>)deletePredicate, MergeRowIdBlockFactory.create(Slices.utf8Slice((String)inputfile.location().toString()), partitionSpec.specId(), Slices.utf8Slice((String)partitionDataJson)));
    }

    private DeleteManager getDeleteManager(PartitionSpec partitionSpec, PartitionData partitionData) {
        if (partitionSpec.isUnpartitioned()) {
            return this.unpartitionedTableDeleteManager;
        }
        Types.StructType structType = partitionSpec.partitionType();
        PartitionKey partitionKey = (PartitionKey)this.partitionKeyFactories.computeIfAbsent(partitionSpec.specId(), key -> {
            StructLikeWrapper templateWrapper = StructLikeWrapper.forType((Types.StructType)structType);
            return data -> new PartitionKey((int)key, templateWrapper.copyFor((StructLike)data));
        }).apply(partitionData);
        return this.partitionedDeleteManagers.computeIfAbsent(partitionKey, ignored -> new DeleteManager(this.typeManager));
    }

    private TupleDomain<IcebergColumnHandle> getUnenforcedPredicate(org.apache.iceberg.Schema tableSchema, Map<Integer, Optional<String>> partitionKeys, DynamicFilter dynamicFilter, TupleDomain<IcebergColumnHandle> unenforcedPredicate, TupleDomain<IcebergColumnHandle> fileStatisticsDomain) {
        return this.prunePredicate(tableSchema, partitionKeys, (TupleDomain<IcebergColumnHandle>)TupleDomain.intersect((List)ImmutableList.of(unenforcedPredicate, fileStatisticsDomain, (Object)dynamicFilter.getCurrentPredicate().transformKeys(IcebergColumnHandle.class::cast))), fileStatisticsDomain).simplify(1000);
    }

    private TupleDomain<IcebergColumnHandle> prunePredicate(org.apache.iceberg.Schema tableSchema, Map<Integer, Optional<String>> partitionKeys, TupleDomain<IcebergColumnHandle> unenforcedPredicate, TupleDomain<IcebergColumnHandle> fileStatisticsDomain) {
        com.google.common.base.Supplier partitionValues;
        if (unenforcedPredicate.isAll() || unenforcedPredicate.isNone()) {
            return unenforcedPredicate;
        }
        Set partitionColumns = (Set)partitionKeys.keySet().stream().map(fieldId -> IcebergUtil.getColumnHandle(tableSchema.findField(fieldId.intValue()), this.typeManager)).collect(ImmutableSet.toImmutableSet());
        if (!IcebergSplitSource.partitionMatchesPredicate(partitionColumns, (Supplier<Map<ColumnHandle, NullableValue>>)(partitionValues = Suppliers.memoize(() -> IcebergUtil.getPartitionValues(partitionColumns, partitionKeys))), unenforcedPredicate)) {
            return TupleDomain.none();
        }
        return unenforcedPredicate.filter((columnHandle, domain) -> !partitionKeys.containsKey(columnHandle.getId())).filter((handle, domain) -> !domain.contains(fileStatisticsDomain.getDomain(handle, domain.getType())));
    }

    private Set<IcebergColumnHandle> requiredColumnsForDeletes(org.apache.iceberg.Schema schema, List<DeleteFile> deletes) {
        ImmutableSet.Builder requiredColumns = ImmutableSet.builder();
        for (DeleteFile deleteFile : deletes) {
            if (deleteFile.content() == FileContent.POSITION_DELETES) {
                requiredColumns.add((Object)IcebergUtil.getColumnHandle(MetadataColumns.ROW_POSITION, this.typeManager));
                continue;
            }
            if (deleteFile.content() != FileContent.EQUALITY_DELETES) continue;
            deleteFile.equalityFieldIds().stream().map(id -> IcebergUtil.getColumnHandle(schema.findField(id.intValue()), this.typeManager)).forEach(arg_0 -> ((ImmutableSet.Builder)requiredColumns).add(arg_0));
        }
        return requiredColumns.build();
    }

    private ConnectorPageSource openDeletes(ConnectorSession session, TrinoFileSystem fileSystem, DeleteFile delete, List<IcebergColumnHandle> columns, TupleDomain<IcebergColumnHandle> tupleDomain) {
        return this.createDataPageSource(session, fileSystem.newInputFile(Location.of((String)delete.path()), delete.fileSizeInBytes()), 0L, delete.fileSizeInBytes(), delete.fileSizeInBytes(), IcebergFileFormat.fromIceberg(delete.format()), IcebergUtil.schemaFromHandles(columns), columns, tupleDomain, Optional.empty(), (Map<Integer, Optional<String>>)ImmutableMap.of()).readerPageSource().get();
    }

    private ReaderPageSourceWithRowPositions createDataPageSource(ConnectorSession session, TrinoInputFile inputFile, long start, long length, long fileSize, IcebergFileFormat fileFormat, org.apache.iceberg.Schema fileSchema, List<IcebergColumnHandle> dataColumns, TupleDomain<IcebergColumnHandle> predicate, Optional<NameMapping> nameMapping, Map<Integer, Optional<String>> partitionKeys) {
        return switch (fileFormat) {
            default -> throw new MatchException(null, null);
            case IcebergFileFormat.ORC -> IcebergPageSourceProvider.createOrcPageSource(inputFile, start, length, dataColumns, predicate, this.orcReaderOptions.withMaxMergeDistance(IcebergSessionProperties.getOrcMaxMergeDistance(session)).withMaxBufferSize(IcebergSessionProperties.getOrcMaxBufferSize(session)).withStreamBufferSize(IcebergSessionProperties.getOrcStreamBufferSize(session)).withTinyStripeThreshold(IcebergSessionProperties.getOrcTinyStripeThreshold(session)).withMaxReadBlockSize(IcebergSessionProperties.getOrcMaxReadBlockSize(session)).withLazyReadSmallRanges(IcebergSessionProperties.getOrcLazyReadSmallRanges(session)).withNestedLazy(IcebergSessionProperties.isOrcNestedLazy(session)).withBloomFiltersEnabled(IcebergSessionProperties.isOrcBloomFiltersEnabled(session)), this.fileFormatDataSourceStats, this.typeManager, nameMapping, partitionKeys);
            case IcebergFileFormat.PARQUET -> IcebergPageSourceProvider.createParquetPageSource(inputFile, start, length, fileSize, dataColumns, this.parquetReaderOptions.withMaxReadBlockSize(IcebergSessionProperties.getParquetMaxReadBlockSize(session)).withMaxReadBlockRowCount(IcebergSessionProperties.getParquetMaxReadBlockRowCount(session)).withSmallFileThreshold(IcebergSessionProperties.getParquetSmallFileThreshold(session)).withIgnoreStatistics(IcebergSessionProperties.isParquetIgnoreStatistics(session)).withBloomFilter(IcebergSessionProperties.useParquetBloomFilter(session)).withUseColumnIndex(false).withVectorizedDecodingEnabled(IcebergSessionProperties.isParquetVectorizedDecodingEnabled(session)), predicate, this.fileFormatDataSourceStats, nameMapping, partitionKeys);
            case IcebergFileFormat.AVRO -> IcebergPageSourceProvider.createAvroPageSource(inputFile, start, length, fileSchema, nameMapping, dataColumns);
        };
    }

    private static ConnectorPageSource generatePages(final long totalRowCount, List<IcebergColumnHandle> icebergColumns, Map<Integer, Optional<String>> partitionKeys) {
        final int maxPageSize = 131072;
        Block[] pageBlocks = new Block[icebergColumns.size()];
        for (int i = 0; i < icebergColumns.size(); ++i) {
            IcebergColumnHandle column = icebergColumns.get(i);
            io.trino.spi.type.Type trinoType = column.getType();
            Object partitionValue = IcebergUtil.deserializePartitionValue(trinoType, partitionKeys.get(column.getId()).orElse(null), column.getName());
            pageBlocks[i] = RunLengthEncodedBlock.create((Block)Utils.nativeValueToBlock((io.trino.spi.type.Type)trinoType, (Object)partitionValue), (int)maxPageSize);
        }
        final Page maxPage = new Page(maxPageSize, pageBlocks);
        return new FixedPageSource((Iterator)new AbstractIterator<Page>(){
            private long rowIndex;

            protected Page computeNext() {
                if (this.rowIndex == totalRowCount) {
                    return (Page)this.endOfData();
                }
                int pageSize = Math.toIntExact(Math.min((long)maxPageSize, totalRowCount - this.rowIndex));
                Page page = maxPage.getRegion(0, pageSize);
                this.rowIndex += (long)pageSize;
                return page;
            }
        }, maxPage.getRetainedSizeInBytes());
    }

    private static ReaderPageSourceWithRowPositions createOrcPageSource(TrinoInputFile inputFile, long start, long length, List<IcebergColumnHandle> columns, TupleDomain<IcebergColumnHandle> effectivePredicate, OrcReaderOptions options, FileFormatDataSourceStats stats, TypeManager typeManager, Optional<NameMapping> nameMapping, Map<Integer, Optional<String>> partitionKeys) {
        TrinoOrcDataSource orcDataSource = null;
        try {
            orcDataSource = new TrinoOrcDataSource(inputFile, options, stats);
            OrcReader reader = (OrcReader)OrcReader.createOrcReader((OrcDataSource)orcDataSource, (OrcReaderOptions)options).orElseThrow(() -> new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_BAD_DATA, "ORC file is zero length"));
            Map<Integer, OrcColumn> fileColumnsByIcebergId = OrcIcebergIds.fileColumnsByIcebergId(reader, nameMapping);
            TupleDomainOrcPredicate.TupleDomainOrcPredicateBuilder predicateBuilder = TupleDomainOrcPredicate.builder().setBloomFiltersEnabled(options.isBloomFiltersEnabled());
            Map effectivePredicateDomains = (Map)effectivePredicate.getDomains().orElseThrow(() -> new IllegalArgumentException("Effective predicate is none"));
            Optional<ReaderColumns> baseColumnProjections = IcebergPageSourceProvider.projectBaseColumns(columns);
            Map projectionsByFieldId = columns.stream().collect(Collectors.groupingBy(column -> column.getBaseColumnIdentity().getId(), Collectors.mapping(IcebergColumnHandle::getPath, Collectors.toUnmodifiableList())));
            List<IcebergColumnHandle> readBaseColumns = baseColumnProjections.map(readerColumns -> (List)readerColumns.get().stream().map(IcebergColumnHandle.class::cast).collect(ImmutableList.toImmutableList())).orElse(columns);
            ArrayList<OrcColumn> fileReadColumns = new ArrayList<OrcColumn>(readBaseColumns.size());
            ArrayList<io.trino.spi.type.Type> fileReadTypes = new ArrayList<io.trino.spi.type.Type>(readBaseColumns.size());
            ArrayList<OrcReader.ProjectedLayout> projectedLayouts = new ArrayList<OrcReader.ProjectedLayout>(readBaseColumns.size());
            ArrayList<OrcPageSource.ColumnAdaptation> columnAdaptations = new ArrayList<OrcPageSource.ColumnAdaptation>(readBaseColumns.size());
            for (IcebergColumnHandle column2 : readBaseColumns) {
                Verify.verify((boolean)column2.isBaseColumn(), (String)"Column projections must be based from a root column", (Object[])new Object[0]);
                OrcColumn orcColumn = fileColumnsByIcebergId.get(column2.getId());
                if (column2.isIsDeletedColumn()) {
                    columnAdaptations.add(OrcPageSource.ColumnAdaptation.constantColumn((Block)Utils.nativeValueToBlock((io.trino.spi.type.Type)BooleanType.BOOLEAN, (Object)false)));
                    continue;
                }
                if (partitionKeys.containsKey(column2.getId())) {
                    io.trino.spi.type.Type trinoType = column2.getType();
                    columnAdaptations.add(OrcPageSource.ColumnAdaptation.constantColumn((Block)Utils.nativeValueToBlock((io.trino.spi.type.Type)trinoType, (Object)IcebergUtil.deserializePartitionValue(trinoType, partitionKeys.get(column2.getId()).orElse(null), column2.getName()))));
                    continue;
                }
                if (column2.isPathColumn()) {
                    columnAdaptations.add(OrcPageSource.ColumnAdaptation.constantColumn((Block)Utils.nativeValueToBlock((io.trino.spi.type.Type)IcebergMetadataColumn.FILE_PATH.getType(), (Object)Slices.utf8Slice((String)inputFile.location().toString()))));
                    continue;
                }
                if (column2.isFileModifiedTimeColumn()) {
                    columnAdaptations.add(OrcPageSource.ColumnAdaptation.constantColumn((Block)Utils.nativeValueToBlock((io.trino.spi.type.Type)IcebergMetadataColumn.FILE_MODIFIED_TIME.getType(), (Object)DateTimeEncoding.packDateTimeWithZone((long)inputFile.lastModified().toEpochMilli(), (TimeZoneKey)TimeZoneKey.UTC_KEY))));
                    continue;
                }
                if (column2.isMergeRowIdColumn()) {
                    columnAdaptations.add(OrcPageSource.ColumnAdaptation.positionColumn());
                    continue;
                }
                if (column2.isRowPositionColumn()) {
                    columnAdaptations.add(OrcPageSource.ColumnAdaptation.positionColumn());
                    continue;
                }
                if (orcColumn != null) {
                    io.trino.spi.type.Type readType = IcebergPageSourceProvider.getOrcReadType(column2.getType(), typeManager);
                    if (column2.getType() == UuidType.UUID && !"UUID".equals(orcColumn.getAttributes().get("iceberg.binary-type"))) {
                        throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_BAD_DATA, String.format("Expected ORC column for UUID data to be annotated with %s=UUID: %s", "iceberg.binary-type", orcColumn));
                    }
                    List<List<Integer>> fieldIdProjections = projectionsByFieldId.get(column2.getId());
                    OrcReader.ProjectedLayout projectedLayout = IcebergOrcProjectedLayout.createProjectedLayout(orcColumn, fieldIdProjections);
                    int sourceIndex = fileReadColumns.size();
                    columnAdaptations.add(OrcPageSource.ColumnAdaptation.sourceColumn((int)sourceIndex));
                    fileReadColumns.add(orcColumn);
                    fileReadTypes.add(readType);
                    projectedLayouts.add(projectedLayout);
                    for (Map.Entry domainEntry : effectivePredicateDomains.entrySet()) {
                        IcebergColumnHandle predicateColumn = (IcebergColumnHandle)domainEntry.getKey();
                        OrcColumn predicateOrcColumn = fileColumnsByIcebergId.get(predicateColumn.getId());
                        if (predicateOrcColumn == null || !column2.getColumnIdentity().equals(predicateColumn.getBaseColumnIdentity())) continue;
                        predicateBuilder.addColumn(predicateOrcColumn.getColumnId(), (Domain)domainEntry.getValue());
                    }
                    continue;
                }
                columnAdaptations.add(OrcPageSource.ColumnAdaptation.nullColumn((io.trino.spi.type.Type)column2.getType()));
            }
            AggregatedMemoryContext memoryUsage = AggregatedMemoryContext.newSimpleAggregatedMemoryContext();
            OrcDataSourceId orcDataSourceId = orcDataSource.getId();
            OrcRecordReader recordReader = reader.createRecordReader(fileReadColumns, fileReadTypes, projectedLayouts, (OrcPredicate)predicateBuilder.build(), start, length, DateTimeZone.UTC, memoryUsage, 1, exception -> IcebergPageSourceProvider.handleException(orcDataSourceId, exception), (OrcReader.FieldMapperFactory)new IdBasedFieldMapperFactory(readBaseColumns));
            return new ReaderPageSourceWithRowPositions(new ReaderPageSource((ConnectorPageSource)new OrcPageSource(recordReader, columnAdaptations, (OrcDataSource)orcDataSource, Optional.empty(), Optional.empty(), memoryUsage, stats, reader.getCompressionKind()), baseColumnProjections), recordReader.getStartRowPosition(), recordReader.getEndRowPosition());
        }
        catch (IOException | RuntimeException e) {
            block17: {
                if (orcDataSource != null) {
                    try {
                        orcDataSource.close();
                    }
                    catch (IOException ex) {
                        if (e.equals(ex)) break block17;
                        e.addSuppressed(ex);
                    }
                }
            }
            if (e instanceof TrinoException) {
                throw (TrinoException)((Object)e);
            }
            if (e instanceof OrcCorruptionException) {
                throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_BAD_DATA, (Throwable)e);
            }
            String message = "Error opening Iceberg split %s (offset=%s, length=%s): %s".formatted(inputFile.location(), start, length, e.getMessage());
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_CANNOT_OPEN_SPLIT, message, (Throwable)e);
        }
    }

    private static List<Integer> applyProjection(ColumnHandle expectedColumnHandle, ColumnHandle readColumnHandle) {
        IcebergColumnHandle expectedColumn = (IcebergColumnHandle)expectedColumnHandle;
        IcebergColumnHandle readColumn = (IcebergColumnHandle)readColumnHandle;
        Preconditions.checkState((boolean)readColumn.isBaseColumn(), (Object)"Read column path must be a base column");
        ImmutableList.Builder dereferenceChain = ImmutableList.builder();
        ColumnIdentity columnIdentity = readColumn.getColumnIdentity();
        for (Integer fieldId : expectedColumn.getPath()) {
            ColumnIdentity nextChild = columnIdentity.getChildByFieldId(fieldId);
            dereferenceChain.add((Object)columnIdentity.getChildIndexByFieldId(fieldId));
            columnIdentity = nextChild;
        }
        return dereferenceChain.build();
    }

    private static Integer getIcebergFieldId(OrcColumn column) {
        String icebergId = (String)column.getAttributes().get("iceberg.id");
        Verify.verify((icebergId != null ? 1 : 0) != 0, (String)String.format("column %s does not have %s property", column, "iceberg.id"), (Object[])new Object[0]);
        return Integer.valueOf(icebergId);
    }

    private static io.trino.spi.type.Type getOrcReadType(io.trino.spi.type.Type columnType, TypeManager typeManager) {
        if (columnType instanceof ArrayType) {
            return new ArrayType(IcebergPageSourceProvider.getOrcReadType(((ArrayType)columnType).getElementType(), typeManager));
        }
        if (columnType instanceof MapType) {
            MapType mapType = (MapType)columnType;
            io.trino.spi.type.Type keyType = IcebergPageSourceProvider.getOrcReadType(mapType.getKeyType(), typeManager);
            io.trino.spi.type.Type valueType = IcebergPageSourceProvider.getOrcReadType(mapType.getValueType(), typeManager);
            return new MapType(keyType, valueType, typeManager.getTypeOperators());
        }
        if (columnType instanceof RowType) {
            return RowType.from((List)((List)((RowType)columnType).getFields().stream().map(field -> new RowType.Field(field.getName(), IcebergPageSourceProvider.getOrcReadType(field.getType(), typeManager))).collect(ImmutableList.toImmutableList())));
        }
        return columnType;
    }

    private static ReaderPageSourceWithRowPositions createParquetPageSource(TrinoInputFile inputFile, long start, long length, long fileSize, List<IcebergColumnHandle> regularColumns, ParquetReaderOptions options, TupleDomain<IcebergColumnHandle> effectivePredicate, FileFormatDataSourceStats fileFormatDataSourceStats, Optional<NameMapping> nameMapping, Map<Integer, Optional<String>> partitionKeys) {
        AggregatedMemoryContext memoryContext = AggregatedMemoryContext.newSimpleAggregatedMemoryContext();
        ParquetDataSource dataSource = null;
        try {
            dataSource = ParquetPageSourceFactory.createDataSource((TrinoInputFile)inputFile, (OptionalLong)OptionalLong.of(fileSize), (ParquetReaderOptions)options, (AggregatedMemoryContext)memoryContext, (FileFormatDataSourceStats)fileFormatDataSourceStats);
            ParquetMetadata parquetMetadata = MetadataReader.readFooter((ParquetDataSource)dataSource, Optional.empty());
            FileMetadata fileMetaData = parquetMetadata.getFileMetaData();
            MessageType fileSchema = fileMetaData.getSchema();
            if (nameMapping.isPresent() && !ParquetSchemaUtil.hasIds((MessageType)fileSchema)) {
                fileSchema = ParquetSchemaUtil.applyNameMapping((MessageType)fileSchema, (NameMapping)IcebergPageSourceProvider.convertToLowercase(nameMapping.get()));
            }
            Map<Integer, org.apache.parquet.schema.Type> parquetIdToField = IcebergPageSourceProvider.createParquetIdToFieldMapping(fileSchema);
            Optional<ReaderColumns> baseColumnProjections = IcebergPageSourceProvider.projectBaseColumns(regularColumns);
            List<IcebergColumnHandle> readBaseColumns = baseColumnProjections.map(readerColumns -> (List)readerColumns.get().stream().map(IcebergColumnHandle.class::cast).collect(ImmutableList.toImmutableList())).orElse(regularColumns);
            List<org.apache.parquet.schema.Type> parquetFields = readBaseColumns.stream().map(column -> (org.apache.parquet.schema.Type)parquetIdToField.get(column.getId())).toList();
            MessageType requestedSchema = IcebergPageSourceProvider.getMessageType(regularColumns, fileSchema.getName(), parquetIdToField);
            Map descriptorsByPath = ParquetTypeUtils.getDescriptors((MessageType)fileSchema, (MessageType)requestedSchema);
            TupleDomain<ColumnDescriptor> parquetTupleDomain = options.isIgnoreStatistics() ? TupleDomain.all() : IcebergPageSourceProvider.getParquetTupleDomain(descriptorsByPath, effectivePredicate);
            TupleDomainParquetPredicate parquetPredicate = PredicateUtils.buildPredicate((MessageType)requestedSchema, parquetTupleDomain, (Map)descriptorsByPath, (DateTimeZone)DateTimeZone.UTC);
            List rowGroups = PredicateUtils.getFilteredRowGroups((long)start, (long)length, (ParquetDataSource)dataSource, (ParquetMetadata)parquetMetadata, (List)ImmutableList.of(parquetTupleDomain), (List)ImmutableList.of((Object)parquetPredicate), (Map)descriptorsByPath, (DateTimeZone)DateTimeZone.UTC, (int)1000, (ParquetReaderOptions)options);
            Optional<Long> startRowPosition = Optional.empty();
            Optional<Long> endRowPosition = Optional.empty();
            if (!rowGroups.isEmpty()) {
                startRowPosition = Optional.of(((RowGroupInfo)rowGroups.getFirst()).fileRowOffset());
                RowGroupInfo lastRowGroup = (RowGroupInfo)rowGroups.getLast();
                endRowPosition = Optional.of(lastRowGroup.fileRowOffset() + lastRowGroup.prunedBlockMetadata().getRowCount());
            }
            MessageColumnIO messageColumnIO = ParquetTypeUtils.getColumnIO((MessageType)fileSchema, (MessageType)requestedSchema);
            ParquetPageSource.Builder pageSourceBuilder = ParquetPageSource.builder();
            int parquetSourceChannel = 0;
            ImmutableList.Builder parquetColumnFieldsBuilder = ImmutableList.builder();
            for (int columnIndex = 0; columnIndex < readBaseColumns.size(); ++columnIndex) {
                IcebergColumnHandle column2 = readBaseColumns.get(columnIndex);
                if (column2.isIsDeletedColumn()) {
                    pageSourceBuilder.addConstantColumn(Utils.nativeValueToBlock((io.trino.spi.type.Type)BooleanType.BOOLEAN, (Object)false));
                    continue;
                }
                if (partitionKeys.containsKey(column2.getId())) {
                    io.trino.spi.type.Type trinoType = column2.getType();
                    pageSourceBuilder.addConstantColumn(Utils.nativeValueToBlock((io.trino.spi.type.Type)trinoType, (Object)IcebergUtil.deserializePartitionValue(trinoType, partitionKeys.get(column2.getId()).orElse(null), column2.getName())));
                    continue;
                }
                if (column2.isPathColumn()) {
                    pageSourceBuilder.addConstantColumn(Utils.nativeValueToBlock((io.trino.spi.type.Type)IcebergMetadataColumn.FILE_PATH.getType(), (Object)Slices.utf8Slice((String)inputFile.location().toString())));
                    continue;
                }
                if (column2.isFileModifiedTimeColumn()) {
                    pageSourceBuilder.addConstantColumn(Utils.nativeValueToBlock((io.trino.spi.type.Type)IcebergMetadataColumn.FILE_MODIFIED_TIME.getType(), (Object)DateTimeEncoding.packDateTimeWithZone((long)inputFile.lastModified().toEpochMilli(), (TimeZoneKey)TimeZoneKey.UTC_KEY)));
                    continue;
                }
                if (column2.isMergeRowIdColumn()) {
                    pageSourceBuilder.addRowIndexColumn();
                    continue;
                }
                if (column2.isRowPositionColumn()) {
                    pageSourceBuilder.addRowIndexColumn();
                    continue;
                }
                org.apache.parquet.schema.Type parquetField = parquetFields.get(columnIndex);
                io.trino.spi.type.Type trinoType = column2.getBaseType();
                if (parquetField == null) {
                    pageSourceBuilder.addNullColumn(trinoType);
                    continue;
                }
                ColumnIO columnIO = messageColumnIO.getChild(parquetField.getName());
                Optional<Field> field = IcebergParquetColumnIOConverter.constructField(new IcebergParquetColumnIOConverter.FieldContext(trinoType, column2.getColumnIdentity()), columnIO);
                if (field.isEmpty()) {
                    pageSourceBuilder.addNullColumn(trinoType);
                    continue;
                }
                parquetColumnFieldsBuilder.add((Object)new Column(parquetField.getName(), field.get()));
                pageSourceBuilder.addSourceColumn(parquetSourceChannel);
                ++parquetSourceChannel;
            }
            ParquetDataSourceId dataSourceId = dataSource.getId();
            ParquetReader parquetReader = new ParquetReader(Optional.ofNullable(fileMetaData.getCreatedBy()), (List)parquetColumnFieldsBuilder.build(), rowGroups, dataSource, DateTimeZone.UTC, memoryContext, options, exception -> IcebergPageSourceProvider.handleException(dataSourceId, exception), Optional.empty(), Optional.empty());
            return new ReaderPageSourceWithRowPositions(new ReaderPageSource(pageSourceBuilder.build(parquetReader), baseColumnProjections), startRowPosition, endRowPosition);
        }
        catch (IOException | RuntimeException e) {
            block18: {
                try {
                    if (dataSource != null) {
                        dataSource.close();
                    }
                }
                catch (IOException ex) {
                    if (e.equals(ex)) break block18;
                    e.addSuppressed(ex);
                }
            }
            if (e instanceof TrinoException) {
                throw (TrinoException)((Object)e);
            }
            if (e instanceof ParquetCorruptionException) {
                throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_BAD_DATA, (Throwable)e);
            }
            String message = "Error opening Iceberg split %s (offset=%s, length=%s): %s".formatted(inputFile.location(), start, length, e.getMessage());
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_CANNOT_OPEN_SPLIT, message, (Throwable)e);
        }
    }

    private static Map<Integer, org.apache.parquet.schema.Type> createParquetIdToFieldMapping(MessageType fileSchema) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        IcebergPageSourceProvider.addParquetIdToFieldMapping((org.apache.parquet.schema.Type)fileSchema, (ImmutableMap.Builder<Integer, org.apache.parquet.schema.Type>)builder);
        return builder.buildOrThrow();
    }

    private static void addParquetIdToFieldMapping(org.apache.parquet.schema.Type type, ImmutableMap.Builder<Integer, org.apache.parquet.schema.Type> builder) {
        if (type.getId() != null) {
            builder.put((Object)type.getId().intValue(), (Object)type);
        }
        if (!(type instanceof PrimitiveType)) {
            if (type instanceof GroupType) {
                GroupType groupType = (GroupType)type;
                for (org.apache.parquet.schema.Type field : groupType.getFields()) {
                    IcebergPageSourceProvider.addParquetIdToFieldMapping(field, builder);
                }
            } else {
                throw new IllegalStateException("Unsupported field type: " + String.valueOf(type));
            }
        }
    }

    private static MessageType getMessageType(List<IcebergColumnHandle> regularColumns, String fileSchemaName, Map<Integer, org.apache.parquet.schema.Type> parquetIdToField) {
        return IcebergPageSourceProvider.projectSufficientColumns(regularColumns).map(readerColumns -> readerColumns.get().stream().map(IcebergColumnHandle.class::cast).toList()).orElse(regularColumns).stream().map(column -> IcebergPageSourceProvider.getColumnType(column, parquetIdToField)).filter(Optional::isPresent).map(Optional::get).map(type -> new MessageType(fileSchemaName, new org.apache.parquet.schema.Type[]{type})).reduce(MessageType::union).orElse(new MessageType(fileSchemaName, (List)ImmutableList.of()));
    }

    private static ReaderPageSourceWithRowPositions createAvroPageSource(TrinoInputFile inputFile, long start, long length, org.apache.iceberg.Schema fileSchema, Optional<NameMapping> nameMapping, List<IcebergColumnHandle> columns) {
        ReaderPageSourceWithRowPositions readerPageSourceWithRowPositions;
        ConstantPopulatingPageSource.Builder constantPopulatingPageSourceBuilder = ConstantPopulatingPageSource.builder();
        int avroSourceChannel = 0;
        Optional<ReaderColumns> baseColumnProjections = IcebergPageSourceProvider.projectBaseColumns(columns);
        List<IcebergColumnHandle> readBaseColumns = baseColumnProjections.map(readerColumns -> (List)readerColumns.get().stream().map(IcebergColumnHandle.class::cast).collect(ImmutableList.toImmutableList())).orElse(columns);
        ForwardingInputFile file = new ForwardingInputFile(inputFile);
        OptionalLong fileModifiedTime = OptionalLong.empty();
        try {
            if (readBaseColumns.stream().anyMatch(IcebergColumnHandle::isFileModifiedTimeColumn)) {
                fileModifiedTime = OptionalLong.of(inputFile.lastModified().toEpochMilli());
            }
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_CANNOT_OPEN_SPLIT, (Throwable)e);
        }
        DataFileStream avroFileReader = new DataFileStream((InputStream)file.newStream(), (DatumReader)new GenericDatumReader());
        try {
            Schema avroSchema = avroFileReader.getSchema();
            List fileFields = avroSchema.getFields();
            if (nameMapping.isPresent() && fileFields.stream().noneMatch(IcebergPageSourceProvider::hasId)) {
                fileFields = (List)fileFields.stream().map(field -> IcebergPageSourceProvider.setMissingFieldId(field, (NameMapping)nameMapping.get(), (List<String>)ImmutableList.of((Object)field.name()))).collect(ImmutableList.toImmutableList());
            }
            Map<Integer, Schema.Field> fileColumnsByIcebergId = IcebergPageSourceProvider.mapIdsToAvroFields(fileFields);
            ImmutableList.Builder columnNames = ImmutableList.builder();
            ImmutableList.Builder columnTypes = ImmutableList.builder();
            ImmutableList.Builder rowIndexChannels = ImmutableList.builder();
            for (IcebergColumnHandle column : readBaseColumns) {
                Verify.verify((boolean)column.isBaseColumn(), (String)"Column projections must be based from a root column", (Object[])new Object[0]);
                Schema.Field field2 = fileColumnsByIcebergId.get(column.getId());
                if (column.isPathColumn()) {
                    constantPopulatingPageSourceBuilder.addConstantColumn(Utils.nativeValueToBlock((io.trino.spi.type.Type)IcebergMetadataColumn.FILE_PATH.getType(), (Object)Slices.utf8Slice((String)file.location())));
                    continue;
                }
                if (column.isFileModifiedTimeColumn()) {
                    constantPopulatingPageSourceBuilder.addConstantColumn(Utils.nativeValueToBlock((io.trino.spi.type.Type)IcebergMetadataColumn.FILE_MODIFIED_TIME.getType(), (Object)DateTimeEncoding.packDateTimeWithZone((long)fileModifiedTime.orElseThrow(), (TimeZoneKey)TimeZoneKey.UTC_KEY)));
                    continue;
                }
                if (column.isMergeRowIdColumn() || column.isRowPositionColumn()) {
                    rowIndexChannels.add((Object)true);
                    columnNames.add((Object)MetadataColumns.ROW_POSITION.name());
                    columnTypes.add((Object)BigintType.BIGINT);
                    constantPopulatingPageSourceBuilder.addDelegateColumn(avroSourceChannel);
                    ++avroSourceChannel;
                    continue;
                }
                if (field2 == null) {
                    constantPopulatingPageSourceBuilder.addConstantColumn(Utils.nativeValueToBlock((io.trino.spi.type.Type)column.getType(), null));
                    continue;
                }
                rowIndexChannels.add((Object)false);
                columnNames.add((Object)column.getName());
                columnTypes.add((Object)column.getType());
                constantPopulatingPageSourceBuilder.addDelegateColumn(avroSourceChannel);
                ++avroSourceChannel;
            }
            readerPageSourceWithRowPositions = new ReaderPageSourceWithRowPositions(new ReaderPageSource(constantPopulatingPageSourceBuilder.build(new IcebergAvroPageSource(file, start, length, fileSchema, nameMapping, (List<String>)columnNames.build(), (List<io.trino.spi.type.Type>)columnTypes.build(), (List<Boolean>)rowIndexChannels.build(), AggregatedMemoryContext.newSimpleAggregatedMemoryContext())), baseColumnProjections), Optional.empty(), Optional.empty());
        }
        catch (Throwable throwable) {
            try {
                try {
                    avroFileReader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_CANNOT_OPEN_SPLIT, (Throwable)e);
            }
        }
        avroFileReader.close();
        return readerPageSourceWithRowPositions;
    }

    private static boolean hasId(Schema.Field field) {
        return AvroSchemaUtil.hasFieldId((Schema.Field)field);
    }

    private static Schema.Field setMissingFieldId(Schema.Field field, NameMapping nameMapping, List<String> qualifiedPath) {
        MappedField mappedField = nameMapping.find(qualifiedPath);
        Schema schema = field.schema();
        if (mappedField != null && mappedField.id() != null) {
            field.addProp(AVRO_FIELD_ID, (Object)mappedField.id());
        }
        return new Schema.Field(field, schema);
    }

    private static Map<Integer, Schema.Field> mapIdsToAvroFields(List<Schema.Field> fields) {
        ImmutableMap.Builder fieldsById = ImmutableMap.builder();
        for (Schema.Field field : fields) {
            if (!AvroSchemaUtil.hasFieldId((Schema.Field)field)) continue;
            fieldsById.put((Object)AvroSchemaUtil.getFieldId((Schema.Field)field), (Object)field);
        }
        return fieldsById.buildOrThrow();
    }

    private static NameMapping convertToLowercase(NameMapping nameMapping) {
        return NameMapping.of(IcebergPageSourceProvider.convertToLowercase(nameMapping.asMappedFields().fields()));
    }

    private static MappedFields convertToLowercase(MappedFields mappedFields) {
        if (mappedFields == null) {
            return null;
        }
        return MappedFields.of(IcebergPageSourceProvider.convertToLowercase(mappedFields.fields()));
    }

    private static List<MappedField> convertToLowercase(List<MappedField> fields) {
        return (List)fields.stream().map(mappedField -> {
            Set lowercaseNames = (Set)mappedField.names().stream().map(name -> name.toLowerCase(Locale.ENGLISH)).collect(ImmutableSet.toImmutableSet());
            return MappedField.of((Integer)mappedField.id(), (Iterable)lowercaseNames, (MappedFields)IcebergPageSourceProvider.convertToLowercase(mappedField.nestedMapping()));
        }).collect(ImmutableList.toImmutableList());
    }

    private static Optional<ReaderColumns> projectBaseColumns(List<IcebergColumnHandle> columns) {
        Objects.requireNonNull(columns, "columns is null");
        if (columns.stream().allMatch(IcebergColumnHandle::isBaseColumn)) {
            return Optional.empty();
        }
        ImmutableList.Builder projectedColumns = ImmutableList.builder();
        ImmutableList.Builder outputColumnMapping = ImmutableList.builder();
        HashMap<Integer, Integer> mappedFieldIds = new HashMap<Integer, Integer>();
        int projectedColumnCount = 0;
        for (IcebergColumnHandle column : columns) {
            int baseColumnId = column.getBaseColumnIdentity().getId();
            Integer mapped = (Integer)mappedFieldIds.get(baseColumnId);
            if (mapped == null) {
                projectedColumns.add((Object)column.getBaseColumn());
                mappedFieldIds.put(baseColumnId, projectedColumnCount);
                outputColumnMapping.add((Object)projectedColumnCount);
                ++projectedColumnCount;
                continue;
            }
            outputColumnMapping.add((Object)mapped);
        }
        return Optional.of(new ReaderColumns((List)projectedColumns.build(), (List)outputColumnMapping.build()));
    }

    private static Optional<ReaderColumns> projectSufficientColumns(List<IcebergColumnHandle> columns) {
        Objects.requireNonNull(columns, "columns is null");
        if (columns.stream().allMatch(IcebergColumnHandle::isBaseColumn)) {
            return Optional.empty();
        }
        ImmutableBiMap.Builder dereferenceChainsBuilder = ImmutableBiMap.builder();
        for (IcebergColumnHandle column : columns) {
            DereferenceChain dereferenceChain = new DereferenceChain(column.getBaseColumnIdentity(), column.getPath());
            dereferenceChainsBuilder.put((Object)dereferenceChain, (Object)column);
        }
        ImmutableBiMap dereferenceChains = dereferenceChainsBuilder.build();
        ArrayList<ColumnHandle> sufficientColumns = new ArrayList<ColumnHandle>();
        ImmutableList.Builder outputColumnMapping = ImmutableList.builder();
        HashMap<DereferenceChain, Integer> pickedColumns = new HashMap<DereferenceChain, Integer>();
        for (IcebergColumnHandle columnHandle : columns) {
            int inputBlockIndex;
            DereferenceChain dereferenceChain = Objects.requireNonNull((DereferenceChain)dereferenceChains.inverse().get((Object)columnHandle));
            DereferenceChain chosenColumn = null;
            for (DereferenceChain prefix : dereferenceChain.orderedPrefixes()) {
                if (!dereferenceChains.containsKey((Object)prefix)) continue;
                chosenColumn = prefix;
                break;
            }
            Preconditions.checkState((chosenColumn != null ? 1 : 0) != 0, (Object)"chosenColumn is null");
            if (pickedColumns.containsKey(chosenColumn)) {
                inputBlockIndex = (Integer)pickedColumns.get(chosenColumn);
            } else {
                sufficientColumns.add((ColumnHandle)dereferenceChains.get((Object)chosenColumn));
                pickedColumns.put(chosenColumn, sufficientColumns.size() - 1);
                inputBlockIndex = sufficientColumns.size() - 1;
            }
            outputColumnMapping.add((Object)inputBlockIndex);
        }
        return Optional.of(new ReaderColumns(sufficientColumns, (List)outputColumnMapping.build()));
    }

    private static Optional<org.apache.parquet.schema.Type> getColumnType(IcebergColumnHandle column, Map<Integer, org.apache.parquet.schema.Type> parquetIdToField) {
        Optional<org.apache.parquet.schema.Type> baseColumnType = Optional.ofNullable(parquetIdToField.get(column.getBaseColumn().getId()));
        if (baseColumnType.isEmpty() || column.getPath().isEmpty()) {
            return baseColumnType;
        }
        GroupType baseType = baseColumnType.get().asGroupType();
        List subfieldTypes = (List)column.getPath().stream().filter(parquetIdToField::containsKey).map(parquetIdToField::get).collect(ImmutableList.toImmutableList());
        if (subfieldTypes.isEmpty()) {
            return Optional.empty();
        }
        org.apache.parquet.schema.Type type = (org.apache.parquet.schema.Type)subfieldTypes.getLast();
        for (int i = subfieldTypes.size() - 2; i >= 0; --i) {
            GroupType groupType = ((org.apache.parquet.schema.Type)subfieldTypes.get(i)).asGroupType();
            type = new GroupType(groupType.getRepetition(), groupType.getName(), (List)ImmutableList.of((Object)type));
        }
        return Optional.of(new GroupType(baseType.getRepetition(), baseType.getName(), (List)ImmutableList.of((Object)type)));
    }

    @VisibleForTesting
    static TupleDomain<ColumnDescriptor> getParquetTupleDomain(Map<List<String>, ColumnDescriptor> descriptorsByPath, TupleDomain<IcebergColumnHandle> effectivePredicate) {
        if (effectivePredicate.isNone()) {
            return TupleDomain.none();
        }
        Map descriptorsById = (Map)descriptorsByPath.values().stream().filter(descriptor -> descriptor.getPrimitiveType().getId() != null).collect(ImmutableMap.toImmutableMap(descriptor -> descriptor.getPrimitiveType().getId().intValue(), Function.identity()));
        ImmutableMap.Builder predicate = ImmutableMap.builder();
        ((Map)effectivePredicate.getDomains().orElseThrow()).forEach((columnHandle, domain) -> {
            ColumnDescriptor descriptor;
            ColumnIdentity columnIdentity = columnHandle.getColumnIdentity();
            if (ColumnIdentity.TypeCategory.PRIMITIVE == columnIdentity.getTypeCategory() && (descriptor = (ColumnDescriptor)descriptorsById.get(columnHandle.getId())) != null) {
                predicate.put((Object)descriptor, domain);
            }
        });
        return TupleDomain.withColumnDomains((Map)predicate.buildOrThrow());
    }

    private static TrinoException handleException(OrcDataSourceId dataSourceId, Exception exception) {
        if (exception instanceof TrinoException) {
            return (TrinoException)((Object)exception);
        }
        if (exception instanceof OrcCorruptionException) {
            return new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_BAD_DATA, (Throwable)exception);
        }
        return new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_CURSOR_ERROR, String.format("Failed to read ORC file: %s", dataSourceId), (Throwable)exception);
    }

    private static TrinoException handleException(ParquetDataSourceId dataSourceId, Exception exception) {
        if (exception instanceof TrinoException) {
            return (TrinoException)((Object)exception);
        }
        if (exception instanceof ParquetCorruptionException) {
            return new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_BAD_DATA, (Throwable)exception);
        }
        return new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_CURSOR_ERROR, String.format("Failed to read Parquet file: %s", dataSourceId), (Throwable)exception);
    }

    public record ReaderPageSourceWithRowPositions(ReaderPageSource readerPageSource, Optional<Long> startRowPosition, Optional<Long> endRowPosition) {
        public ReaderPageSourceWithRowPositions {
            Objects.requireNonNull(readerPageSource, "readerPageSource is null");
            Objects.requireNonNull(startRowPosition, "startRowPosition is null");
            Objects.requireNonNull(endRowPosition, "endRowPosition is null");
        }
    }

    private record MergeRowIdBlockFactory(VariableWidthBlock filePath, IntArrayBlock partitionSpecId, VariableWidthBlock partitionData) implements Function<Block, RowBlock>
    {
        private static Function<Block, RowBlock> create(Slice filePath, int partitionSpecId, Slice partitionData) {
            return new MergeRowIdBlockFactory(new VariableWidthBlock(1, filePath, new int[]{0, filePath.length()}, Optional.empty()), new IntArrayBlock(1, Optional.empty(), new int[]{partitionSpecId}), new VariableWidthBlock(1, partitionData, new int[]{0, partitionData.length()}, Optional.empty()));
        }

        @Override
        public RowBlock apply(Block rowPosition) {
            return RowBlock.fromFieldBlocks((int)rowPosition.getPositionCount(), (Block[])new Block[]{RunLengthEncodedBlock.create((Block)this.filePath, (int)rowPosition.getPositionCount()), rowPosition, RunLengthEncodedBlock.create((Block)this.partitionSpecId, (int)rowPosition.getPositionCount()), RunLengthEncodedBlock.create((Block)this.partitionData, (int)rowPosition.getPositionCount())});
        }
    }

    private record PartitionKey(int specId, StructLikeWrapper partitionData) {
    }

    private static class IcebergOrcProjectedLayout
    implements OrcReader.ProjectedLayout {
        private final Map<Integer, OrcReader.ProjectedLayout> projectedLayoutForFieldId;

        private IcebergOrcProjectedLayout(Map<Integer, OrcReader.ProjectedLayout> projectedLayoutForFieldId) {
            this.projectedLayoutForFieldId = ImmutableMap.copyOf(Objects.requireNonNull(projectedLayoutForFieldId, "projectedLayoutForFieldId is null"));
        }

        public static OrcReader.ProjectedLayout createProjectedLayout(OrcColumn root, List<List<Integer>> fieldIdDereferences) {
            if (fieldIdDereferences.stream().anyMatch(List::isEmpty)) {
                return OrcReader.fullyProjectedLayout();
            }
            Map dereferencesByField = fieldIdDereferences.stream().collect(Collectors.groupingBy(List::getFirst, Collectors.mapping(sequence -> sequence.subList(1, sequence.size()), Collectors.toUnmodifiableList())));
            ImmutableMap.Builder fieldLayouts = ImmutableMap.builder();
            for (OrcColumn nestedColumn : root.getNestedColumns()) {
                Integer fieldId = IcebergPageSourceProvider.getIcebergFieldId(nestedColumn);
                if (!dereferencesByField.containsKey(fieldId)) continue;
                fieldLayouts.put((Object)fieldId, (Object)IcebergOrcProjectedLayout.createProjectedLayout(nestedColumn, dereferencesByField.get(fieldId)));
            }
            return new IcebergOrcProjectedLayout((Map<Integer, OrcReader.ProjectedLayout>)fieldLayouts.buildOrThrow());
        }

        public OrcReader.ProjectedLayout getFieldLayout(OrcColumn orcColumn) {
            int fieldId = IcebergPageSourceProvider.getIcebergFieldId(orcColumn);
            return this.projectedLayoutForFieldId.getOrDefault(fieldId, OrcReader.fullyProjectedLayout());
        }
    }

    private static class IdBasedFieldMapperFactory
    implements OrcReader.FieldMapperFactory {
        private final Map<Integer, Map<String, Integer>> fieldNameToIdMappingForTableColumns;

        public IdBasedFieldMapperFactory(List<IcebergColumnHandle> columns) {
            Objects.requireNonNull(columns, "columns is null");
            ImmutableMap.Builder mapping = ImmutableMap.builder();
            for (IcebergColumnHandle column : columns) {
                if (column.isMergeRowIdColumn()) continue;
                IdBasedFieldMapperFactory.populateMapping(column.getColumnIdentity(), (ImmutableMap.Builder<Integer, Map<String, Integer>>)mapping);
            }
            this.fieldNameToIdMappingForTableColumns = mapping.buildOrThrow();
        }

        public OrcReader.FieldMapper create(OrcColumn column) {
            ImmutableMap nestedColumns = Maps.uniqueIndex((Iterable)column.getNestedColumns(), IcebergPageSourceProvider::getIcebergFieldId);
            int icebergId = IcebergPageSourceProvider.getIcebergFieldId(column);
            return new IdBasedFieldMapper((Map<Integer, OrcColumn>)nestedColumns, this.fieldNameToIdMappingForTableColumns.get(icebergId));
        }

        private static void populateMapping(ColumnIdentity identity, ImmutableMap.Builder<Integer, Map<String, Integer>> fieldNameToIdMappingForTableColumns) {
            List<ColumnIdentity> children = identity.getChildren();
            fieldNameToIdMappingForTableColumns.put((Object)identity.getId(), (Object)((Map)children.stream().collect(ImmutableMap.toImmutableMap(child -> child.getName().toLowerCase(Locale.ENGLISH), ColumnIdentity::getId))));
            for (ColumnIdentity child2 : children) {
                IdBasedFieldMapperFactory.populateMapping(child2, fieldNameToIdMappingForTableColumns);
            }
        }
    }

    private static class DereferenceChain {
        private final ColumnIdentity baseColumnIdentity;
        private final List<Integer> path;

        public DereferenceChain(ColumnIdentity baseColumnIdentity, List<Integer> path) {
            this.baseColumnIdentity = Objects.requireNonNull(baseColumnIdentity, "baseColumnIdentity is null");
            this.path = ImmutableList.copyOf((Collection)Objects.requireNonNull(path, "path is null"));
        }

        public Iterable<DereferenceChain> orderedPrefixes() {
            return () -> new AbstractIterator<DereferenceChain>(){
                private int prefixLength;

                public DereferenceChain computeNext() {
                    if (this.prefixLength > path.size()) {
                        return (DereferenceChain)this.endOfData();
                    }
                    return new DereferenceChain(baseColumnIdentity, path.subList(0, this.prefixLength++));
                }
            };
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DereferenceChain that = (DereferenceChain)o;
            return Objects.equals(this.baseColumnIdentity, that.baseColumnIdentity) && Objects.equals(this.path, that.path);
        }

        public int hashCode() {
            return Objects.hash(this.baseColumnIdentity, this.path);
        }
    }

    private static class IdBasedFieldMapper
    implements OrcReader.FieldMapper {
        private final Map<Integer, OrcColumn> idToColumnMappingForFile;
        private final Map<String, Integer> nameToIdMappingForTableColumns;

        public IdBasedFieldMapper(Map<Integer, OrcColumn> idToColumnMappingForFile, Map<String, Integer> nameToIdMappingForTableColumns) {
            this.idToColumnMappingForFile = Objects.requireNonNull(idToColumnMappingForFile, "idToColumnMappingForFile is null");
            this.nameToIdMappingForTableColumns = Objects.requireNonNull(nameToIdMappingForTableColumns, "nameToIdMappingForTableColumns is null");
        }

        public OrcColumn get(String fieldName) {
            int fieldId = Objects.requireNonNull(this.nameToIdMappingForTableColumns.get(fieldName), () -> String.format("Id mapping for field %s not found", fieldName));
            return this.idToColumnMappingForFile.get(fieldId);
        }
    }
}

