/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import io.trino.plugin.iceberg.IcebergColumnHandle;
import io.trino.plugin.iceberg.IcebergPartitionFunction;
import io.trino.plugin.iceberg.TypeConverter;
import io.trino.spi.connector.ConnectorPartitioningHandle;
import io.trino.spi.type.TypeManager;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iceberg.PartitionField;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

public record IcebergPartitioningHandle(boolean update, List<IcebergPartitionFunction> partitionFunctions) implements ConnectorPartitioningHandle
{
    public IcebergPartitioningHandle {
        partitionFunctions = ImmutableList.copyOf((Collection)Objects.requireNonNull(partitionFunctions, "partitioning is null"));
    }

    public IcebergPartitioningHandle forUpdate() {
        return new IcebergPartitioningHandle(true, this.partitionFunctions);
    }

    public static IcebergPartitioningHandle create(PartitionSpec spec, TypeManager typeManager, List<IcebergColumnHandle> partitioningColumns) {
        Map<Integer, List<Integer>> dataPaths = IcebergPartitioningHandle.buildDataPaths(spec);
        List partitionFields = (List)spec.fields().stream().map(field -> IcebergPartitionFunction.create(field.transform().toString(), (List)dataPaths.get(field.sourceId()), TypeConverter.toTrinoType(spec.schema().findType(field.sourceId()), typeManager))).collect(ImmutableList.toImmutableList());
        return new IcebergPartitioningHandle(false, partitionFields);
    }

    private static Map<Integer, List<Integer>> buildDataPaths(PartitionSpec spec) {
        Set partitionFieldIds = (Set)spec.fields().stream().map(PartitionField::sourceId).collect(ImmutableSet.toImmutableSet());
        HashMap<Integer, List<Integer>> fieldInfo = new HashMap<Integer, List<Integer>>();
        for (Types.NestedField field : spec.schema().asStruct().fields()) {
            Type type = field.type();
            if (type instanceof Types.StructType) {
                Types.StructType nestedStruct = (Types.StructType)type;
                IcebergPartitioningHandle.buildDataPaths(partitionFieldIds, nestedStruct, new ArrayDeque<Integer>((Collection<Integer>)ImmutableList.of((Object)field.fieldId())), fieldInfo);
                continue;
            }
            if (!field.type().isPrimitiveType() || !partitionFieldIds.contains(field.fieldId())) continue;
            fieldInfo.put(field.fieldId(), (List<Integer>)ImmutableList.of((Object)field.fieldId()));
        }
        List sortedFieldIds = (List)fieldInfo.keySet().stream().sorted().collect(ImmutableList.toImmutableList());
        ImmutableMap.Builder builder = ImmutableMap.builderWithExpectedSize((int)sortedFieldIds.size());
        HashMap<Integer, Integer> fieldChannels = new HashMap<Integer, Integer>();
        AtomicInteger channel = new AtomicInteger();
        Iterator iterator = sortedFieldIds.iterator();
        while (iterator.hasNext()) {
            int sortedFieldId = (Integer)iterator.next();
            List dataPath = (List)fieldInfo.get(sortedFieldId);
            int fieldChannel = fieldChannels.computeIfAbsent((Integer)dataPath.getFirst(), n -> channel.getAndIncrement());
            ImmutableList channelDataPath = ImmutableList.builder().add((Object)fieldChannel).addAll(dataPath.stream().skip(1L).iterator()).build();
            builder.put((Object)sortedFieldId, (Object)channelDataPath);
        }
        return builder.buildOrThrow();
    }

    private static void buildDataPaths(Set<Integer> partitionFieldIds, Types.StructType struct, ArrayDeque<Integer> currentPaths, Map<Integer, List<Integer>> dataPaths) {
        List fields = struct.fields();
        for (int fieldOrdinal = 0; fieldOrdinal < fields.size(); ++fieldOrdinal) {
            Types.NestedField field = (Types.NestedField)fields.get(fieldOrdinal);
            int fieldId = field.fieldId();
            currentPaths.addLast(fieldOrdinal);
            Type type = field.type();
            if (type instanceof Types.StructType) {
                Types.StructType nestedStruct = (Types.StructType)type;
                IcebergPartitioningHandle.buildDataPaths(partitionFieldIds, nestedStruct, currentPaths, dataPaths);
            } else if (type.isPrimitiveType() && partitionFieldIds.contains(fieldId)) {
                dataPaths.put(fieldId, (List<Integer>)ImmutableList.copyOf(currentPaths));
            }
            currentPaths.removeLast();
        }
    }

    public long getCacheKeyHint() {
        Hasher hasher = Hashing.goodFastHash((int)64).newHasher();
        hasher.putBoolean(this.update);
        for (IcebergPartitionFunction function : this.partitionFunctions) {
            hasher.putInt(function.transform().ordinal());
            function.dataPath().forEach(arg_0 -> ((Hasher)hasher).putInt(arg_0));
            hasher.putString((CharSequence)function.type().getTypeSignature().toString(), StandardCharsets.UTF_8);
            function.size().ifPresent(arg_0 -> ((Hasher)hasher).putInt(arg_0));
        }
        return hasher.hash().asLong();
    }
}

