/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.SizeOf;
import io.trino.plugin.iceberg.IcebergColumnHandle;
import io.trino.plugin.iceberg.IcebergFileFormat;
import io.trino.plugin.iceberg.delete.DeleteFile;
import io.trino.spi.HostAddress;
import io.trino.spi.SplitWeight;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.predicate.TupleDomain;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class IcebergSplit
implements ConnectorSplit {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(IcebergSplit.class);
    private final String path;
    private final long start;
    private final long length;
    private final long fileSize;
    private final long fileRecordCount;
    private final IcebergFileFormat fileFormat;
    private final Optional<List<Object>> partitionValues;
    private final String partitionSpecJson;
    private final String partitionDataJson;
    private final List<DeleteFile> deletes;
    private final SplitWeight splitWeight;
    private final TupleDomain<IcebergColumnHandle> fileStatisticsDomain;
    private final Map<String, String> fileIoProperties;
    private final long dataSequenceNumber;
    private final List<HostAddress> addresses;

    @JsonCreator
    public IcebergSplit(@JsonProperty(value="path") String path, @JsonProperty(value="start") long start, @JsonProperty(value="length") long length, @JsonProperty(value="fileSize") long fileSize, @JsonProperty(value="fileRecordCount") long fileRecordCount, @JsonProperty(value="fileFormat") IcebergFileFormat fileFormat, @JsonProperty(value="partitionSpecJson") String partitionSpecJson, @JsonProperty(value="partitionDataJson") String partitionDataJson, @JsonProperty(value="deletes") List<DeleteFile> deletes, @JsonProperty(value="splitWeight") SplitWeight splitWeight, @JsonProperty(value="fileStatisticsDomain") TupleDomain<IcebergColumnHandle> fileStatisticsDomain, @JsonProperty(value="fileIoProperties") Map<String, String> fileIoProperties, @JsonProperty(value="dataSequenceNumber") long dataSequenceNumber) {
        this(path, start, length, fileSize, fileRecordCount, fileFormat, Optional.empty(), partitionSpecJson, partitionDataJson, deletes, splitWeight, fileStatisticsDomain, fileIoProperties, (List<HostAddress>)ImmutableList.of(), dataSequenceNumber);
    }

    public IcebergSplit(String path, long start, long length, long fileSize, long fileRecordCount, IcebergFileFormat fileFormat, Optional<List<Object>> partitionValues, String partitionSpecJson, String partitionDataJson, List<DeleteFile> deletes, SplitWeight splitWeight, TupleDomain<IcebergColumnHandle> fileStatisticsDomain, Map<String, String> fileIoProperties, List<HostAddress> addresses, long dataSequenceNumber) {
        this.path = Objects.requireNonNull(path, "path is null");
        this.start = start;
        this.length = length;
        this.fileSize = fileSize;
        this.fileRecordCount = fileRecordCount;
        this.fileFormat = Objects.requireNonNull(fileFormat, "fileFormat is null");
        this.partitionValues = Objects.requireNonNull(partitionValues, "partitionValues is null");
        this.partitionSpecJson = Objects.requireNonNull(partitionSpecJson, "partitionSpecJson is null");
        this.partitionDataJson = Objects.requireNonNull(partitionDataJson, "partitionDataJson is null");
        this.deletes = ImmutableList.copyOf((Collection)Objects.requireNonNull(deletes, "deletes is null"));
        this.splitWeight = Objects.requireNonNull(splitWeight, "splitWeight is null");
        this.fileStatisticsDomain = Objects.requireNonNull(fileStatisticsDomain, "fileStatisticsDomain is null");
        this.fileIoProperties = ImmutableMap.copyOf(Objects.requireNonNull(fileIoProperties, "fileIoProperties is null"));
        this.addresses = Objects.requireNonNull(addresses, "addresses is null");
        this.dataSequenceNumber = dataSequenceNumber;
    }

    @JsonIgnore
    public List<HostAddress> getAddresses() {
        return this.addresses;
    }

    @JsonProperty
    public String getPath() {
        return this.path;
    }

    @JsonProperty
    public long getStart() {
        return this.start;
    }

    @JsonProperty
    public long getLength() {
        return this.length;
    }

    @JsonProperty
    public long getFileSize() {
        return this.fileSize;
    }

    @JsonProperty
    public long getFileRecordCount() {
        return this.fileRecordCount;
    }

    @JsonProperty
    public IcebergFileFormat getFileFormat() {
        return this.fileFormat;
    }

    @JsonProperty
    public String getPartitionSpecJson() {
        return this.partitionSpecJson;
    }

    @JsonIgnore
    public Optional<List<Object>> getPartitionValues() {
        return this.partitionValues;
    }

    @JsonProperty
    public String getPartitionDataJson() {
        return this.partitionDataJson;
    }

    @JsonProperty
    public List<DeleteFile> getDeletes() {
        return this.deletes;
    }

    @JsonProperty
    public SplitWeight getSplitWeight() {
        return this.splitWeight;
    }

    @JsonProperty
    public TupleDomain<IcebergColumnHandle> getFileStatisticsDomain() {
        return this.fileStatisticsDomain;
    }

    @JsonProperty
    public Map<String, String> getFileIoProperties() {
        return this.fileIoProperties;
    }

    @JsonProperty
    public long getDataSequenceNumber() {
        return this.dataSequenceNumber;
    }

    public Map<String, String> getSplitInfo() {
        return ImmutableMap.builder().put((Object)"path", (Object)this.path).put((Object)"start", (Object)String.valueOf(this.start)).put((Object)"length", (Object)String.valueOf(this.length)).buildOrThrow();
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.estimatedSizeOf((String)this.path) + SizeOf.estimatedSizeOf((String)this.partitionSpecJson) + SizeOf.estimatedSizeOf((String)this.partitionDataJson) + SizeOf.estimatedSizeOf(this.deletes, DeleteFile::retainedSizeInBytes) + this.splitWeight.getRetainedSizeInBytes() + this.fileStatisticsDomain.getRetainedSizeInBytes(IcebergColumnHandle::getRetainedSizeInBytes) + SizeOf.estimatedSizeOf(this.fileIoProperties, SizeOf::estimatedSizeOf, SizeOf::estimatedSizeOf) + SizeOf.estimatedSizeOf(this.addresses, HostAddress::getRetainedSizeInBytes);
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((Object)this).addValue((Object)this.path).add("start", this.start).add("length", this.length).add("fileStatisticsDomain", this.fileStatisticsDomain);
        if (!this.deletes.isEmpty()) {
            helper.add("deleteFiles", this.deletes.size());
            helper.add("deleteRecords", this.deletes.stream().mapToLong(DeleteFile::recordCount).sum());
        }
        return helper.toString();
    }
}

