/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.inject.Inject;
import io.airlift.units.Duration;
import io.trino.filesystem.cache.CachingHostAddressProvider;
import io.trino.plugin.base.classloader.ClassLoaderSafeConnectorSplitSource;
import io.trino.plugin.iceberg.ForIcebergScanPlanning;
import io.trino.plugin.iceberg.ForIcebergSplitManager;
import io.trino.plugin.iceberg.IcebergFileSystemFactory;
import io.trino.plugin.iceberg.IcebergMetadata;
import io.trino.plugin.iceberg.IcebergSessionProperties;
import io.trino.plugin.iceberg.IcebergSplitSource;
import io.trino.plugin.iceberg.IcebergTableHandle;
import io.trino.plugin.iceberg.IcebergTransactionManager;
import io.trino.plugin.iceberg.functions.tablechanges.TableChangesFunctionHandle;
import io.trino.plugin.iceberg.functions.tablechanges.TableChangesSplitSource;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplitManager;
import io.trino.spi.connector.ConnectorSplitSource;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.connector.FixedSplitSource;
import io.trino.spi.function.table.ConnectorTableFunctionHandle;
import io.trino.spi.type.TypeManager;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import org.apache.iceberg.CombinedScanTask;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.IncrementalAppendScan;
import org.apache.iceberg.IncrementalChangelogScan;
import org.apache.iceberg.Scan;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.Table;
import org.apache.iceberg.util.SnapshotUtil;

public class IcebergSplitManager
implements ConnectorSplitManager {
    public static final int ICEBERG_DOMAIN_COMPACTION_THRESHOLD = 1000;
    private final IcebergTransactionManager transactionManager;
    private final TypeManager typeManager;
    private final IcebergFileSystemFactory fileSystemFactory;
    private final ListeningExecutorService splitSourceExecutor;
    private final ExecutorService icebergPlanningExecutor;
    private final CachingHostAddressProvider cachingHostAddressProvider;

    @Inject
    public IcebergSplitManager(IcebergTransactionManager transactionManager, TypeManager typeManager, IcebergFileSystemFactory fileSystemFactory, @ForIcebergSplitManager ListeningExecutorService splitSourceExecutor, @ForIcebergScanPlanning ExecutorService icebergPlanningExecutor, CachingHostAddressProvider cachingHostAddressProvider) {
        this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.fileSystemFactory = Objects.requireNonNull(fileSystemFactory, "fileSystemFactory is null");
        this.splitSourceExecutor = Objects.requireNonNull(splitSourceExecutor, "splitSourceExecutor is null");
        this.icebergPlanningExecutor = Objects.requireNonNull(icebergPlanningExecutor, "icebergPlanningExecutor is null");
        this.cachingHostAddressProvider = Objects.requireNonNull(cachingHostAddressProvider, "cachingHostAddressProvider is null");
    }

    public ConnectorSplitSource getSplits(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorTableHandle handle, DynamicFilter dynamicFilter, Constraint constraint) {
        IcebergTableHandle table = (IcebergTableHandle)handle;
        if (table.getSnapshotId().isEmpty()) {
            if (table.isRecordScannedFiles()) {
                return new FixedSplitSource((Iterable)ImmutableList.of(), (List)ImmutableList.of());
            }
            return FixedSplitSource.emptySplitSource();
        }
        IcebergMetadata icebergMetadata = this.transactionManager.get(transaction, session.getIdentity());
        Table icebergTable = icebergMetadata.getIcebergTable(session, table.getSchemaTableName());
        Duration dynamicFilteringWaitTimeout = IcebergSessionProperties.getDynamicFilteringWaitTimeout(session);
        Scan<?, FileScanTask, CombinedScanTask> scan = this.getScan(icebergMetadata, icebergTable, table, this.icebergPlanningExecutor);
        IcebergSplitSource splitSource = new IcebergSplitSource(this.fileSystemFactory, session, table, icebergTable, scan, table.getMaxScannedFileSize(), dynamicFilter, dynamicFilteringWaitTimeout, constraint, this.typeManager, table.isRecordScannedFiles(), IcebergSessionProperties.getMinimumAssignedSplitWeight(session), this.cachingHostAddressProvider, this.splitSourceExecutor);
        return new ClassLoaderSafeConnectorSplitSource((ConnectorSplitSource)splitSource, IcebergSplitManager.class.getClassLoader());
    }

    private Scan<?, FileScanTask, CombinedScanTask> getScan(IcebergMetadata icebergMetadata, Table icebergTable, IcebergTableHandle table, ExecutorService executor) {
        Long fromSnapshot = icebergMetadata.getIncrementalRefreshFromSnapshot().orElse(null);
        if (fromSnapshot != null) {
            if (SnapshotUtil.isAncestorOf((Table)icebergTable, (long)fromSnapshot)) {
                boolean containsModifiedRows = false;
                for (Snapshot snapshot : SnapshotUtil.ancestorsBetween((Table)icebergTable, (long)icebergTable.currentSnapshot().snapshotId(), (Long)fromSnapshot)) {
                    if (!snapshot.operation().equals("overwrite") && !snapshot.operation().equals("delete")) continue;
                    containsModifiedRows = true;
                    break;
                }
                if (!containsModifiedRows) {
                    return (Scan)((IncrementalAppendScan)icebergTable.newIncrementalAppendScan().fromSnapshotExclusive(fromSnapshot.longValue())).planWith(executor);
                }
            }
            icebergMetadata.disableIncrementalRefresh();
        }
        return (Scan)icebergTable.newScan().useSnapshot(table.getSnapshotId().get().longValue()).planWith(executor);
    }

    public ConnectorSplitSource getSplits(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorTableFunctionHandle function) {
        if (function instanceof TableChangesFunctionHandle) {
            TableChangesFunctionHandle functionHandle = (TableChangesFunctionHandle)function;
            Table icebergTable = this.transactionManager.get(transaction, session.getIdentity()).getIcebergTable(session, functionHandle.schemaTableName());
            TableChangesSplitSource tableChangesSplitSource = new TableChangesSplitSource(icebergTable, (IncrementalChangelogScan)((IncrementalChangelogScan)icebergTable.newIncrementalChangelogScan().fromSnapshotExclusive(functionHandle.startSnapshotId())).toSnapshot(functionHandle.endSnapshotId()));
            return new ClassLoaderSafeConnectorSplitSource((ConnectorSplitSource)tableChangesSplitSource, IcebergSplitManager.class.getClassLoader());
        }
        throw new IllegalStateException("Unknown table function: " + String.valueOf(function));
    }
}

