/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Suppliers;
import com.google.common.base.Verify;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Closer;
import com.google.common.math.LongMath;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import io.airlift.concurrent.MoreFutures;
import io.airlift.log.Logger;
import io.airlift.slice.Slices;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.cache.CacheUtils;
import io.trino.cache.NonEvictableCache;
import io.trino.cache.SafeCaches;
import io.trino.filesystem.cache.CachingHostAddressProvider;
import io.trino.plugin.iceberg.ExpressionConverter;
import io.trino.plugin.iceberg.IcebergColumnHandle;
import io.trino.plugin.iceberg.IcebergExceptions;
import io.trino.plugin.iceberg.IcebergFileFormat;
import io.trino.plugin.iceberg.IcebergFileSystemFactory;
import io.trino.plugin.iceberg.IcebergMetadataColumn;
import io.trino.plugin.iceberg.IcebergSessionProperties;
import io.trino.plugin.iceberg.IcebergSplit;
import io.trino.plugin.iceberg.IcebergTableHandle;
import io.trino.plugin.iceberg.IcebergTypes;
import io.trino.plugin.iceberg.IcebergUtil;
import io.trino.plugin.iceberg.PartitionData;
import io.trino.plugin.iceberg.StructLikeWrapperWithFieldIdToIndex;
import io.trino.plugin.iceberg.TypeConverter;
import io.trino.plugin.iceberg.delete.DeleteFile;
import io.trino.plugin.iceberg.util.DataFileWithDeleteFiles;
import io.trino.spi.SplitWeight;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplitSource;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.NullableValue;
import io.trino.spi.predicate.Range;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.predicate.ValueSet;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.TypeManager;
import jakarta.annotation.Nullable;
import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.iceberg.CombinedScanTask;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileContent;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.PartitionField;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PartitionSpecParser;
import org.apache.iceberg.Scan;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.CloseableIterator;
import org.apache.iceberg.types.Conversions;
import org.apache.iceberg.types.Type;

public class IcebergSplitSource
implements ConnectorSplitSource {
    private static final Logger log = Logger.get(IcebergSplitSource.class);
    private static final ConnectorSplitSource.ConnectorSplitBatch EMPTY_BATCH = new ConnectorSplitSource.ConnectorSplitBatch((List)ImmutableList.of(), false);
    private static final ConnectorSplitSource.ConnectorSplitBatch NO_MORE_SPLITS_BATCH = new ConnectorSplitSource.ConnectorSplitBatch((List)ImmutableList.of(), true);
    private final IcebergFileSystemFactory fileSystemFactory;
    private final ConnectorSession session;
    private final IcebergTableHandle tableHandle;
    private final Map<String, String> fileIoProperties;
    private final Scan<?, FileScanTask, CombinedScanTask> tableScan;
    private final Optional<Long> maxScannedFileSizeInBytes;
    private final Map<Integer, Type.PrimitiveType> fieldIdToType;
    private final DynamicFilter dynamicFilter;
    private final long dynamicFilteringWaitTimeoutMillis;
    private final Stopwatch dynamicFilterWaitStopwatch;
    private final PartitionConstraintMatcher partitionConstraintMatcher;
    private final TypeManager typeManager;
    @GuardedBy(value="closer")
    private final Closer closer = Closer.create();
    @GuardedBy(value="closer")
    private boolean closed;
    @GuardedBy(value="closer")
    private ListenableFuture<ConnectorSplitSource.ConnectorSplitBatch> currentBatchFuture;
    private final double minimumAssignedSplitWeight;
    private final Set<Integer> projectedBaseColumns;
    private final TupleDomain<IcebergColumnHandle> dataColumnPredicate;
    private final Domain pathDomain;
    private final Domain fileModifiedTimeDomain;
    private final OptionalLong limit;
    private final Set<Integer> predicatedColumnIds;
    private final ListeningExecutorService executor;
    @GuardedBy(value="this")
    private TupleDomain<IcebergColumnHandle> pushedDownDynamicFilterPredicate;
    @GuardedBy(value="this")
    private CloseableIterable<FileScanTask> fileScanIterable;
    @GuardedBy(value="this")
    private long targetSplitSize;
    @GuardedBy(value="this")
    private CloseableIterator<FileScanTask> fileScanIterator;
    @GuardedBy(value="this")
    private Iterator<FileScanTaskWithDomain> fileTasksIterator = Collections.emptyIterator();
    private final boolean recordScannedFiles;
    private final int currentSpecId;
    @GuardedBy(value="this")
    private final ImmutableSet.Builder<DataFileWithDeleteFiles> scannedFiles = ImmutableSet.builder();
    @Nullable
    @GuardedBy(value="this")
    private Map<StructLikeWrapperWithFieldIdToIndex, Optional<FileScanTaskWithDomain>> scannedFilesByPartition = new HashMap<StructLikeWrapperWithFieldIdToIndex, Optional<FileScanTaskWithDomain>>();
    @GuardedBy(value="this")
    private long outputRowsLowerBound;
    private final CachingHostAddressProvider cachingHostAddressProvider;
    private volatile boolean finished;

    public IcebergSplitSource(IcebergFileSystemFactory fileSystemFactory, ConnectorSession session, IcebergTableHandle tableHandle, Table icebergTable, Scan<?, FileScanTask, CombinedScanTask> tableScan, Optional<DataSize> maxScannedFileSize, DynamicFilter dynamicFilter, Duration dynamicFilteringWaitTimeout, Constraint constraint, TypeManager typeManager, boolean recordScannedFiles, double minimumAssignedSplitWeight, CachingHostAddressProvider cachingHostAddressProvider, ListeningExecutorService executor) {
        this.fileSystemFactory = Objects.requireNonNull(fileSystemFactory, "fileSystemFactory is null");
        this.session = Objects.requireNonNull(session, "session is null");
        this.tableHandle = Objects.requireNonNull(tableHandle, "tableHandle is null");
        this.fileIoProperties = Objects.requireNonNull(icebergTable.io().properties(), "fileIoProperties is null");
        this.tableScan = Objects.requireNonNull(tableScan, "tableScan is null");
        this.maxScannedFileSizeInBytes = maxScannedFileSize.map(DataSize::toBytes);
        this.fieldIdToType = IcebergUtil.primitiveFieldTypes(tableScan.schema());
        this.dynamicFilter = Objects.requireNonNull(dynamicFilter, "dynamicFilter is null");
        this.dynamicFilteringWaitTimeoutMillis = dynamicFilteringWaitTimeout.toMillis();
        this.dynamicFilterWaitStopwatch = Stopwatch.createStarted();
        this.partitionConstraintMatcher = new PartitionConstraintMatcher(constraint);
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.recordScannedFiles = recordScannedFiles;
        this.currentSpecId = icebergTable.spec().specId();
        this.minimumAssignedSplitWeight = minimumAssignedSplitWeight;
        this.projectedBaseColumns = (Set)tableHandle.getProjectedColumns().stream().map(column -> column.getBaseColumnIdentity().getId()).collect(ImmutableSet.toImmutableSet());
        this.dataColumnPredicate = tableHandle.getEnforcedPredicate().filter((column, domain) -> !IcebergMetadataColumn.isMetadataColumnId(column.getId()));
        this.pathDomain = IcebergUtil.getPathDomain(tableHandle.getEnforcedPredicate());
        Preconditions.checkArgument((tableHandle.getUnenforcedPredicate().isAll() || tableHandle.getLimit().isEmpty() ? 1 : 0) != 0, (String)"Cannot enforce LIMIT %s with unenforced predicate %s present", (Object)tableHandle.getLimit(), tableHandle.getUnenforcedPredicate());
        this.limit = tableHandle.getLimit();
        this.predicatedColumnIds = (Set)Stream.concat(((Map)tableHandle.getUnenforcedPredicate().getDomains().orElse(ImmutableMap.of())).keySet().stream(), dynamicFilter.getColumnsCovered().stream().map(IcebergColumnHandle.class::cast)).map(IcebergColumnHandle::getId).collect(ImmutableSet.toImmutableSet());
        this.fileModifiedTimeDomain = IcebergUtil.getFileModifiedTimePathDomain(tableHandle.getEnforcedPredicate());
        this.cachingHostAddressProvider = Objects.requireNonNull(cachingHostAddressProvider, "cachingHostAddressProvider is null");
        this.executor = Objects.requireNonNull(executor, "executor is null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<ConnectorSplitSource.ConnectorSplitBatch> getNextBatch(int maxSize) {
        ListenableFuture nextBatchFuture;
        long timeLeft = this.dynamicFilteringWaitTimeoutMillis - this.dynamicFilterWaitStopwatch.elapsed(TimeUnit.MILLISECONDS);
        if (this.dynamicFilter.isAwaitable() && timeLeft > 0L) {
            return ((CompletableFuture)this.dynamicFilter.isBlocked().thenApply(object -> EMPTY_BATCH)).completeOnTimeout(EMPTY_BATCH, timeLeft, TimeUnit.MILLISECONDS);
        }
        Closer closer = this.closer;
        synchronized (closer) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"already closed");
            Preconditions.checkState((this.currentBatchFuture == null || this.currentBatchFuture.isDone() ? 1 : 0) != 0, (Object)"previous batch future is not done");
            this.currentBatchFuture = nextBatchFuture = this.executor.submit(() -> this.getNextBatchInternal(maxSize));
        }
        return MoreFutures.toCompletableFuture((ListenableFuture)nextBatchFuture).exceptionally(t -> {
            throw IcebergExceptions.translateMetadataException(t, this.tableHandle.getSchemaTableName().toString());
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized ConnectorSplitSource.ConnectorSplitBatch getNextBatchInternal(int maxSize) {
        if (this.fileScanIterable == null) {
            this.pushedDownDynamicFilterPredicate = this.dynamicFilter.getCurrentPredicate().transformKeys(IcebergColumnHandle.class::cast).filter((columnHandle, domain) -> ExpressionConverter.isConvertibleToIcebergExpression(domain));
            TupleDomain effectivePredicate = TupleDomain.intersect((List)ImmutableList.of(this.dataColumnPredicate, this.tableHandle.getUnenforcedPredicate(), this.pushedDownDynamicFilterPredicate));
            if (effectivePredicate.isNone()) {
                this.finish();
                return NO_MORE_SPLITS_BATCH;
            }
            Expression filterExpression = ExpressionConverter.toIcebergExpression((TupleDomain<IcebergColumnHandle>)effectivePredicate);
            Scan scan = (Scan)this.tableScan.filter(filterExpression);
            if (!this.predicatedColumnIds.isEmpty()) {
                Schema schema = this.tableScan.schema();
                scan = (Scan)scan.includeColumnStats((Collection)this.predicatedColumnIds.stream().map(arg_0 -> ((Schema)schema).findColumnName(arg_0)).filter(Objects::nonNull).collect(ImmutableList.toImmutableList()));
            }
            Closer closer = this.closer;
            synchronized (closer) {
                Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"split source is closed");
                this.fileScanIterable = (CloseableIterable)this.closer.register((Closeable)scan.planFiles());
                this.targetSplitSize = IcebergSessionProperties.getSplitSize(this.session).map(DataSize::toBytes).orElseGet(() -> this.tableScan.targetSplitSize());
                this.fileScanIterator = (CloseableIterator)this.closer.register((Closeable)this.fileScanIterable.iterator());
                this.fileTasksIterator = Collections.emptyIterator();
            }
        }
        TupleDomain dynamicFilterPredicate = this.dynamicFilter.getCurrentPredicate().transformKeys(IcebergColumnHandle.class::cast);
        if (dynamicFilterPredicate.isNone()) {
            this.finish();
            return NO_MORE_SPLITS_BATCH;
        }
        ArrayList<IcebergSplit> splits = new ArrayList<IcebergSplit>(maxSize);
        while (splits.size() < maxSize && (this.fileTasksIterator.hasNext() || this.fileScanIterator.hasNext())) {
            if (!this.fileTasksIterator.hasNext()) {
                if (this.limit.isPresent() && this.limit.getAsLong() <= this.outputRowsLowerBound) {
                    this.finish();
                    break;
                }
                List<FileScanTaskWithDomain> fileScanTasks = this.processFileScanTask((TupleDomain<IcebergColumnHandle>)dynamicFilterPredicate);
                if (fileScanTasks.isEmpty()) continue;
                this.fileTasksIterator = this.prepareFileTasksIterator(fileScanTasks);
                continue;
            }
            splits.add(this.toIcebergSplit(this.fileTasksIterator.next()));
        }
        if (!this.fileScanIterator.hasNext() && !this.fileTasksIterator.hasNext()) {
            this.finish();
        }
        return new ConnectorSplitSource.ConnectorSplitBatch(splits, this.isFinished());
    }

    private synchronized Iterator<FileScanTaskWithDomain> prepareFileTasksIterator(List<FileScanTaskWithDomain> fileScanTasks) {
        ImmutableList.Builder scanTaskBuilder = ImmutableList.builder();
        for (FileScanTaskWithDomain fileScanTaskWithDomain : fileScanTasks) {
            boolean fileHasNoDeletions;
            FileScanTask wholeFileTask = fileScanTaskWithDomain.fileScanTask();
            if (this.recordScannedFiles) {
                List fullyAppliedDeletes = (List)wholeFileTask.deletes().stream().filter(deleteFile -> switch (deleteFile.content()) {
                    default -> throw new MatchException(null, null);
                    case FileContent.POSITION_DELETES -> {
                        if (this.pathDomain.isAll() && this.fileModifiedTimeDomain.isAll()) {
                            yield true;
                        }
                        yield false;
                    }
                    case FileContent.EQUALITY_DELETES -> this.tableHandle.getEnforcedPredicate().isAll();
                    case FileContent.DATA -> throw new IllegalStateException("Unexpected delete file: " + String.valueOf(deleteFile));
                }).collect(ImmutableList.toImmutableList());
                this.scannedFiles.add((Object)new DataFileWithDeleteFiles((DataFile)wholeFileTask.file(), fullyAppliedDeletes));
            }
            if (fileHasNoDeletions = wholeFileTask.deletes().isEmpty()) {
                this.outputRowsLowerBound = LongMath.saturatedAdd((long)this.outputRowsLowerBound, (long)((DataFile)wholeFileTask.file()).recordCount());
            }
            if (fileHasNoDeletions && this.noDataColumnsProjected(wholeFileTask)) {
                scanTaskBuilder.add((Object)fileScanTaskWithDomain);
                continue;
            }
            scanTaskBuilder.addAll(fileScanTaskWithDomain.split(this.targetSplitSize));
        }
        return scanTaskBuilder.build().iterator();
    }

    private synchronized List<FileScanTaskWithDomain> processFileScanTask(TupleDomain<IcebergColumnHandle> dynamicFilterPredicate) {
        FileScanTask wholeFileTask = (FileScanTask)this.fileScanIterator.next();
        boolean fileHasNoDeletions = wholeFileTask.deletes().isEmpty();
        FileScanTaskWithDomain fileScanTaskWithDomain = this.createFileScanTaskWithDomain(wholeFileTask);
        if (this.pruneFileScanTask(fileScanTaskWithDomain, fileHasNoDeletions, dynamicFilterPredicate)) {
            return ImmutableList.of();
        }
        if (!this.recordScannedFiles || this.scannedFilesByPartition == null) {
            return ImmutableList.of((Object)fileScanTaskWithDomain);
        }
        if (this.currentSpecId != wholeFileTask.spec().specId()) {
            Stream<FileScanTaskWithDomain> allQueuedTasks = this.scannedFilesByPartition.values().stream().filter(Optional::isPresent).map(Optional::get);
            this.scannedFilesByPartition = null;
            return (List)Stream.concat(allQueuedTasks, Stream.of(fileScanTaskWithDomain)).collect(ImmutableList.toImmutableList());
        }
        StructLikeWrapperWithFieldIdToIndex structLikeWrapperWithFieldIdToIndex = StructLikeWrapperWithFieldIdToIndex.createStructLikeWrapper(wholeFileTask);
        Optional<FileScanTaskWithDomain> alreadyQueuedFileTask = this.scannedFilesByPartition.get(structLikeWrapperWithFieldIdToIndex);
        if (alreadyQueuedFileTask != null) {
            if (alreadyQueuedFileTask.isEmpty()) {
                return ImmutableList.of((Object)fileScanTaskWithDomain);
            }
            this.scannedFilesByPartition.put(structLikeWrapperWithFieldIdToIndex, Optional.empty());
            return ImmutableList.of((Object)alreadyQueuedFileTask.get(), (Object)fileScanTaskWithDomain);
        }
        if (fileHasNoDeletions) {
            this.scannedFilesByPartition.put(structLikeWrapperWithFieldIdToIndex, Optional.of(fileScanTaskWithDomain));
            return ImmutableList.of();
        }
        this.scannedFilesByPartition.put(structLikeWrapperWithFieldIdToIndex, Optional.empty());
        return ImmutableList.of((Object)fileScanTaskWithDomain);
    }

    private synchronized boolean pruneFileScanTask(FileScanTaskWithDomain fileScanTaskWithDomain, boolean fileHasNoDeletions, TupleDomain<IcebergColumnHandle> dynamicFilterPredicate) {
        long fileModifiedTime;
        FileScanTask fileScanTask = fileScanTaskWithDomain.fileScanTask();
        if (fileHasNoDeletions && this.maxScannedFileSizeInBytes.isPresent() && ((DataFile)fileScanTask.file()).fileSizeInBytes() > this.maxScannedFileSizeInBytes.get()) {
            return true;
        }
        if (!this.pathDomain.isAll() && !this.pathDomain.includesNullableValue((Object)Slices.utf8Slice((String)((DataFile)fileScanTask.file()).location()))) {
            return true;
        }
        if (!this.fileModifiedTimeDomain.isAll() && !this.fileModifiedTimeDomain.includesNullableValue((Object)DateTimeEncoding.packDateTimeWithZone((long)(fileModifiedTime = IcebergUtil.getModificationTime(((DataFile)fileScanTask.file()).location(), this.fileSystemFactory.create(this.session.getIdentity(), this.fileIoProperties))), (TimeZoneKey)TimeZoneKey.UTC_KEY))) {
            return true;
        }
        Schema fileSchema = fileScanTask.schema();
        Map<Integer, Optional<String>> partitionKeys = IcebergUtil.getPartitionKeys(fileScanTask);
        Set identityPartitionColumns = (Set)partitionKeys.keySet().stream().map(fieldId -> IcebergUtil.getColumnHandle(fileSchema.findField(fieldId.intValue()), this.typeManager)).collect(ImmutableSet.toImmutableSet());
        com.google.common.base.Supplier partitionValues = Suppliers.memoize(() -> IcebergUtil.getPartitionValues(identityPartitionColumns, partitionKeys));
        if (!dynamicFilterPredicate.isAll() && !dynamicFilterPredicate.equals(this.pushedDownDynamicFilterPredicate)) {
            if (!IcebergSplitSource.partitionMatchesPredicate(identityPartitionColumns, (Supplier<Map<ColumnHandle, NullableValue>>)partitionValues, dynamicFilterPredicate)) {
                return true;
            }
            if (!fileScanTaskWithDomain.fileStatisticsDomain().overlaps(dynamicFilterPredicate)) {
                return true;
            }
        }
        return !this.partitionConstraintMatcher.matches(identityPartitionColumns, (Supplier<Map<ColumnHandle, NullableValue>>)partitionValues);
    }

    private boolean noDataColumnsProjected(FileScanTask fileScanTask) {
        return ((ImmutableSet)fileScanTask.spec().fields().stream().filter(partitionField -> partitionField.transform().isIdentity()).map(PartitionField::sourceId).collect(ImmutableSet.toImmutableSet())).containsAll(this.projectedBaseColumns);
    }

    private synchronized void finish() {
        this.closeInternal(false);
        this.finished = true;
        this.fileScanIterable = CloseableIterable.empty();
        this.fileScanIterator = CloseableIterator.empty();
        this.fileTasksIterator = Collections.emptyIterator();
    }

    public boolean isFinished() {
        return this.finished;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<List<Object>> getTableExecuteSplitsInfo() {
        ImmutableList splitsInfo;
        Preconditions.checkState((boolean)this.isFinished(), (Object)"Split source must be finished before TableExecuteSplitsInfo is read");
        if (!this.recordScannedFiles) {
            return Optional.empty();
        }
        long filesSkipped = 0L;
        IcebergSplitSource icebergSplitSource = this;
        synchronized (icebergSplitSource) {
            if (this.scannedFilesByPartition != null) {
                filesSkipped = this.scannedFilesByPartition.values().stream().filter(Optional::isPresent).count();
                this.scannedFilesByPartition = null;
            }
            splitsInfo = ImmutableList.copyOf((Collection)this.scannedFiles.build());
        }
        log.info("Generated %d splits, skipped %d files for OPTIMIZE", new Object[]{splitsInfo.size(), filesSkipped});
        return Optional.of(splitsInfo);
    }

    public void close() {
        this.closeInternal(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeInternal(boolean interruptIfRunning) {
        Closer closer = this.closer;
        synchronized (closer) {
            if (!this.closed) {
                this.closed = true;
                if (interruptIfRunning && this.currentBatchFuture != null) {
                    this.currentBatchFuture.cancel(true);
                }
                this.currentBatchFuture = null;
                try {
                    this.closer.close();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        }
    }

    private FileScanTaskWithDomain createFileScanTaskWithDomain(FileScanTask wholeFileTask) {
        List predicatedColumns = (List)wholeFileTask.schema().columns().stream().filter(column -> this.predicatedColumnIds.contains(column.fieldId())).map(column -> IcebergUtil.getColumnHandle(column, this.typeManager)).collect(ImmutableList.toImmutableList());
        return new FileScanTaskWithDomain(wholeFileTask, IcebergSplitSource.createFileStatisticsDomain(this.fieldIdToType, ((DataFile)wholeFileTask.file()).lowerBounds(), ((DataFile)wholeFileTask.file()).upperBounds(), ((DataFile)wholeFileTask.file()).nullValueCounts(), predicatedColumns));
    }

    @VisibleForTesting
    static TupleDomain<IcebergColumnHandle> createFileStatisticsDomain(Map<Integer, Type.PrimitiveType> fieldIdToType, @Nullable Map<Integer, ByteBuffer> lowerBounds, @Nullable Map<Integer, ByteBuffer> upperBounds, @Nullable Map<Integer, Long> nullValueCounts, List<IcebergColumnHandle> predicatedColumns) {
        ImmutableMap.Builder domainBuilder = ImmutableMap.builder();
        for (IcebergColumnHandle column : predicatedColumns) {
            Long nullValueCount;
            int fieldId = column.getId();
            boolean mayContainNulls = nullValueCounts == null ? true : (nullValueCount = nullValueCounts.get(fieldId)) == null || nullValueCount > 0L;
            Type type = (Type)fieldIdToType.get(fieldId);
            domainBuilder.put((Object)column, (Object)IcebergSplitSource.domainForStatistics(column, lowerBounds == null ? null : Conversions.fromByteBuffer((Type)type, (ByteBuffer)lowerBounds.get(fieldId)), upperBounds == null ? null : Conversions.fromByteBuffer((Type)type, (ByteBuffer)upperBounds.get(fieldId)), mayContainNulls));
        }
        return TupleDomain.withColumnDomains((Map)domainBuilder.buildOrThrow());
    }

    private static Domain domainForStatistics(IcebergColumnHandle columnHandle, @Nullable Object lowerBound, @Nullable Object upperBound, boolean mayContainNulls) {
        io.trino.spi.type.Type type = columnHandle.getType();
        Type icebergType = TypeConverter.toIcebergType(type, columnHandle.getColumnIdentity());
        if (lowerBound == null && upperBound == null) {
            return Domain.create((ValueSet)ValueSet.all((io.trino.spi.type.Type)type), (boolean)mayContainNulls);
        }
        Range statisticsRange = lowerBound != null && upperBound != null ? Range.range((io.trino.spi.type.Type)type, (Object)IcebergTypes.convertIcebergValueToTrino(icebergType, lowerBound), (boolean)true, (Object)IcebergTypes.convertIcebergValueToTrino(icebergType, upperBound), (boolean)true) : (upperBound != null ? Range.lessThanOrEqual((io.trino.spi.type.Type)type, (Object)IcebergTypes.convertIcebergValueToTrino(icebergType, upperBound)) : Range.greaterThanOrEqual((io.trino.spi.type.Type)type, (Object)IcebergTypes.convertIcebergValueToTrino(icebergType, lowerBound)));
        return Domain.create((ValueSet)ValueSet.ofRanges((Range)statisticsRange, (Range[])new Range[0]), (boolean)mayContainNulls);
    }

    @VisibleForTesting
    static boolean partitionMatchesPredicate(Set<IcebergColumnHandle> identityPartitionColumns, Supplier<Map<ColumnHandle, NullableValue>> partitionValues, TupleDomain<IcebergColumnHandle> dynamicFilterPredicate) {
        if (dynamicFilterPredicate.isNone()) {
            return false;
        }
        Map domains = (Map)dynamicFilterPredicate.getDomains().orElseThrow();
        for (IcebergColumnHandle partitionColumn : identityPartitionColumns) {
            Domain allowedDomain = (Domain)domains.get(partitionColumn);
            if (allowedDomain == null || allowedDomain.includesNullableValue(partitionValues.get().get(partitionColumn).getValue())) continue;
            return false;
        }
        return true;
    }

    private IcebergSplit toIcebergSplit(FileScanTaskWithDomain taskWithDomain) {
        FileScanTask task = taskWithDomain.fileScanTask();
        Optional<List<Object>> partitionValues = Optional.empty();
        if (this.tableHandle.getTablePartitioning().isPresent()) {
            PartitionSpec partitionSpec = task.spec();
            StructLike partition = ((DataFile)task.file()).partition();
            List fields = partitionSpec.fields();
            partitionValues = Optional.of(this.tableHandle.getTablePartitioning().get().partitionStructFields().stream().map(fieldIndex -> IcebergTypes.convertIcebergValueToTrino(partitionSpec.partitionType().field(((PartitionField)fields.get((int)fieldIndex)).fieldId()).type(), partition.get(fieldIndex.intValue(), Object.class))).toList());
        }
        return new IcebergSplit(((DataFile)task.file()).location(), task.start(), task.length(), ((DataFile)task.file()).fileSizeInBytes(), ((DataFile)task.file()).recordCount(), IcebergFileFormat.fromIceberg(((DataFile)task.file()).format()), partitionValues, PartitionSpecParser.toJson((PartitionSpec)task.spec()), PartitionData.toJson(((DataFile)task.file()).partition()), (List)task.deletes().stream().map(DeleteFile::fromIceberg).collect(ImmutableList.toImmutableList()), SplitWeight.fromProportion((double)Math.clamp(this.getSplitWeight(task), this.minimumAssignedSplitWeight, 1.0)), taskWithDomain.fileStatisticsDomain(), this.fileIoProperties, this.cachingHostAddressProvider.getHosts(((DataFile)task.file()).location(), (List)ImmutableList.of()), ((DataFile)task.file()).dataSequenceNumber());
    }

    private double getSplitWeight(FileScanTask task) {
        double dataWeight;
        double weight = dataWeight = (double)task.length() / (double)this.tableScan.targetSplitSize();
        if (task.deletes().stream().anyMatch(deleteFile -> deleteFile.content() == FileContent.POSITION_DELETES)) {
            weight += dataWeight;
        }
        long equalityDeletes = task.deletes().stream().filter(deleteFile -> deleteFile.content() == FileContent.EQUALITY_DELETES).mapToLong(ContentFile::recordCount).sum();
        return weight += (double)equalityDeletes * dataWeight;
    }

    private static class PartitionConstraintMatcher {
        private final NonEvictableCache<Map<ColumnHandle, NullableValue>, Boolean> partitionConstraintResults;
        private final Optional<Predicate<Map<ColumnHandle, NullableValue>>> predicate;
        private final Optional<Set<ColumnHandle>> predicateColumns;

        private PartitionConstraintMatcher(Constraint constraint) {
            Verify.verify((boolean)constraint.getSummary().isAll());
            this.predicate = constraint.predicate();
            this.predicateColumns = constraint.getPredicateColumns();
            this.partitionConstraintResults = SafeCaches.buildNonEvictableCache((CacheBuilder)CacheBuilder.newBuilder().maximumSize(1000L));
        }

        boolean matches(Set<IcebergColumnHandle> identityPartitionColumns, Supplier<Map<ColumnHandle, NullableValue>> partitionValuesSupplier) {
            if (this.predicate.isEmpty()) {
                return true;
            }
            Sets.SetView predicatePartitionColumns = Sets.intersection(this.predicateColumns.orElseThrow(), identityPartitionColumns);
            if (predicatePartitionColumns.isEmpty()) {
                return true;
            }
            Map<ColumnHandle, NullableValue> partitionValues = partitionValuesSupplier.get();
            return (Boolean)CacheUtils.uncheckedCacheGet(this.partitionConstraintResults, (Object)ImmutableMap.copyOf((Map)Maps.filterKeys(partitionValues, ((Set)predicatePartitionColumns)::contains)), () -> this.predicate.orElseThrow().test(partitionValues));
        }
    }

    private record FileScanTaskWithDomain(FileScanTask fileScanTask, TupleDomain<IcebergColumnHandle> fileStatisticsDomain) {
        Iterator<FileScanTaskWithDomain> split(long targetSplitSize) {
            return Iterators.transform(this.fileScanTask().split(targetSplitSize).iterator(), task -> new FileScanTaskWithDomain((FileScanTask)task, this.fileStatisticsDomain));
        }
    }
}

