/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import io.trino.plugin.iceberg.TableType;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class IcebergTableName {
    private static final Pattern TABLE_PATTERN;

    private IcebergTableName() {
    }

    public static boolean isIcebergTableName(String tableName) {
        return TABLE_PATTERN.matcher(tableName).matches();
    }

    public static String tableNameWithType(String tableName, TableType tableType) {
        Objects.requireNonNull(tableName, "tableName is null");
        return tableName + "$" + tableType.name().toLowerCase(Locale.ENGLISH);
    }

    public static String tableNameFrom(String validIcebergTableName) {
        Matcher match = TABLE_PATTERN.matcher(validIcebergTableName);
        Preconditions.checkArgument((boolean)match.matches(), (String)"Invalid Iceberg table name: %s", (Object)validIcebergTableName);
        return match.group("table");
    }

    public static TableType tableTypeFrom(String validIcebergTableName) {
        Matcher match = TABLE_PATTERN.matcher(validIcebergTableName);
        Preconditions.checkArgument((boolean)match.matches(), (String)"Invalid Iceberg table name: %s", (Object)validIcebergTableName);
        String typeString = match.group("type");
        if (typeString == null) {
            return TableType.DATA;
        }
        TableType parsedType = TableType.valueOf(typeString.toUpperCase(Locale.ENGLISH));
        Verify.verify((parsedType != TableType.DATA ? 1 : 0) != 0, (String)"parsedType is unexpectedly DATA", (Object[])new Object[0]);
        return parsedType;
    }

    public static boolean isDataTable(String validIcebergTableName) {
        Matcher match = TABLE_PATTERN.matcher(validIcebergTableName);
        Preconditions.checkArgument((boolean)match.matches(), (String)"Invalid Iceberg table name: %s", (Object)validIcebergTableName);
        String typeString = match.group("type");
        return typeString == null;
    }

    public static boolean isMaterializedViewStorage(String validIcebergTableName) {
        return IcebergTableName.tableTypeFrom(validIcebergTableName) == TableType.MATERIALIZED_VIEW_STORAGE;
    }

    static {
        String referencableTableTypes = Stream.of(TableType.values()).filter(tableType -> tableType != TableType.DATA).map(tableType -> tableType.name().toLowerCase(Locale.ENGLISH)).collect(Collectors.joining("|"));
        TABLE_PATTERN = Pattern.compile("(?<table>[^$@]+)(?:\\$(?<type>(?i:" + referencableTableTypes + ")))?");
    }
}

