/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.plugin.iceberg.IcebergColumnHandle;
import io.trino.plugin.iceberg.IcebergPartitioningHandle;
import io.trino.spi.connector.ConnectorPartitioningHandle;
import io.trino.spi.connector.ConnectorTablePartitioning;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public record IcebergTablePartitioning(boolean active, IcebergPartitioningHandle partitioningHandle, List<IcebergColumnHandle> partitioningColumns, List<Integer> partitionStructFields) {
    public IcebergTablePartitioning {
        Objects.requireNonNull(partitioningHandle, "partitioningHandle is null");
        partitioningColumns = ImmutableList.copyOf((Collection)Objects.requireNonNull(partitioningColumns, "partitioningColumns is null"));
        partitionStructFields = ImmutableList.copyOf((Collection)Objects.requireNonNull(partitionStructFields, "partitionStructFields is null"));
        Preconditions.checkArgument((partitioningHandle.partitionFunctions().size() == partitionStructFields.size() ? 1 : 0) != 0, (Object)"partitioningColumns and partitionStructFields must have the same size");
    }

    public IcebergTablePartitioning activate() {
        return new IcebergTablePartitioning(true, this.partitioningHandle, this.partitioningColumns, this.partitionStructFields);
    }

    public Optional<ConnectorTablePartitioning> toConnectorTablePartitioning() {
        return this.active ? Optional.of(new ConnectorTablePartitioning((ConnectorPartitioningHandle)this.partitioningHandle, (List)ImmutableList.copyOf(this.partitioningColumns))) : Optional.empty();
    }
}

