/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.plugin.iceberg.IcebergColumnHandle;
import io.trino.plugin.iceberg.IcebergFileFormat;
import io.trino.plugin.iceberg.TrinoSortField;
import io.trino.spi.connector.ConnectorInsertTableHandle;
import io.trino.spi.connector.ConnectorOutputTableHandle;
import io.trino.spi.connector.RetryMode;
import io.trino.spi.connector.SchemaTableName;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public record IcebergWritableTableHandle(SchemaTableName name, String schemaAsJson, Map<Integer, String> partitionsSpecsAsJson, int partitionSpecId, List<TrinoSortField> sortOrder, List<IcebergColumnHandle> inputColumns, String outputPath, IcebergFileFormat fileFormat, Map<String, String> storageProperties, RetryMode retryMode, Map<String, String> fileIoProperties) implements ConnectorInsertTableHandle,
ConnectorOutputTableHandle
{
    public IcebergWritableTableHandle {
        Objects.requireNonNull(name, "name is null");
        Objects.requireNonNull(schemaAsJson, "schemaAsJson is null");
        partitionsSpecsAsJson = ImmutableMap.copyOf(Objects.requireNonNull(partitionsSpecsAsJson, "partitionsSpecsAsJson is null"));
        sortOrder = ImmutableList.copyOf((Collection)Objects.requireNonNull(sortOrder, "sortOrder is null"));
        inputColumns = ImmutableList.copyOf((Collection)Objects.requireNonNull(inputColumns, "inputColumns is null"));
        Objects.requireNonNull(outputPath, "outputPath is null");
        Objects.requireNonNull(fileFormat, "fileFormat is null");
        storageProperties = ImmutableMap.copyOf(Objects.requireNonNull(storageProperties, "storageProperties is null"));
        Objects.requireNonNull(retryMode, "retryMode is null");
        Preconditions.checkArgument((boolean)partitionsSpecsAsJson.containsKey(partitionSpecId), (Object)"partitionSpecId missing from partitionSpecs");
        fileIoProperties = ImmutableMap.copyOf(Objects.requireNonNull(fileIoProperties, "fileIoProperties is null"));
    }

    @Override
    public String toString() {
        return this.name.toString();
    }
}

