/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.collect.ImmutableList;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.iceberg.PartitionField;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;

public final class PartitionFields {
    private static final String UNQUOTED_IDENTIFIER = "[a-zA-Z_][a-zA-Z0-9_]*";
    private static final String QUOTED_IDENTIFIER = "\"(?:\"\"|[^\"])*\"";
    public static final String IDENTIFIER = "([a-zA-Z_][a-zA-Z0-9_]*|\"(?:\"\"|[^\"])*\")";
    private static final Pattern UNQUOTED_IDENTIFIER_PATTERN = Pattern.compile("[a-zA-Z_][a-zA-Z0-9_]*");
    private static final Pattern QUOTED_IDENTIFIER_PATTERN = Pattern.compile("\"(?:\"\"|[^\"])*\"");
    private static final String FUNCTION_ARGUMENT_NAME = "\\(([a-zA-Z_][a-zA-Z0-9_]*|\"(?:\"\"|[^\"])*\")\\)\\s*";
    private static final String FUNCTION_ARGUMENT_NAME_AND_INT = "\\(([a-zA-Z_][a-zA-Z0-9_]*|\"(?:\"\"|[^\"])*\"),\\s*(\\d+)\\)";
    private static final Pattern IDENTITY_PATTERN = Pattern.compile("([a-zA-Z_][a-zA-Z0-9_]*|\"(?:\"\"|[^\"])*\")", 2);
    private static final Pattern YEAR_PATTERN = Pattern.compile("year\\(([a-zA-Z_][a-zA-Z0-9_]*|\"(?:\"\"|[^\"])*\")\\)\\s*", 2);
    private static final Pattern MONTH_PATTERN = Pattern.compile("month\\(([a-zA-Z_][a-zA-Z0-9_]*|\"(?:\"\"|[^\"])*\")\\)\\s*", 2);
    private static final Pattern DAY_PATTERN = Pattern.compile("day\\(([a-zA-Z_][a-zA-Z0-9_]*|\"(?:\"\"|[^\"])*\")\\)\\s*", 2);
    private static final Pattern HOUR_PATTERN = Pattern.compile("hour\\(([a-zA-Z_][a-zA-Z0-9_]*|\"(?:\"\"|[^\"])*\")\\)\\s*", 2);
    private static final Pattern BUCKET_PATTERN = Pattern.compile("bucket\\(([a-zA-Z_][a-zA-Z0-9_]*|\"(?:\"\"|[^\"])*\"),\\s*(\\d+)\\)", 2);
    private static final Pattern TRUNCATE_PATTERN = Pattern.compile("truncate\\(([a-zA-Z_][a-zA-Z0-9_]*|\"(?:\"\"|[^\"])*\"),\\s*(\\d+)\\)", 2);
    private static final Pattern VOID_PATTERN = Pattern.compile("void\\(([a-zA-Z_][a-zA-Z0-9_]*|\"(?:\"\"|[^\"])*\")\\)\\s*", 2);
    static final Pattern ICEBERG_BUCKET_PATTERN = Pattern.compile("bucket\\[(\\d+)]");
    static final Pattern ICEBERG_TRUNCATE_PATTERN = Pattern.compile("truncate\\[(\\d+)]");

    private PartitionFields() {
    }

    public static PartitionSpec parsePartitionFields(Schema schema, List<String> fields) {
        try {
            PartitionSpec.Builder builder = PartitionSpec.builderFor((Schema)schema);
            for (String field : fields) {
                PartitionFields.parsePartitionFields(schema, fields, builder, field);
            }
            return builder.build();
        }
        catch (RuntimeException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, "Unable to parse partitioning value: " + e.getMessage(), (Throwable)e);
        }
    }

    private static void parsePartitionFields(Schema schema, List<String> fields, PartitionSpec.Builder builder, String field) {
        for (int i = 1; i < schema.columns().size() + fields.size(); ++i) {
            try {
                PartitionFields.parsePartitionField(builder, field, (String)(i == 1 ? "" : "_" + i));
                return;
            }
            catch (IllegalArgumentException e) {
                if (e.getMessage().contains("Cannot create partition from name that exists in schema") || e.getMessage().contains("Cannot create identity partition sourced from different field in schema")) continue;
                throw e;
            }
        }
        throw new IllegalArgumentException("Cannot resolve partition field: " + field);
    }

    public static void parsePartitionField(PartitionSpec.Builder builder, String field, String suffix) {
        boolean matched;
        boolean bl = matched = PartitionFields.tryMatch(field, IDENTITY_PATTERN, match -> builder.identity(PartitionFields.fromIdentifierToColumn(match.group()))) || PartitionFields.tryMatch(field, YEAR_PATTERN, match -> {
            String column = PartitionFields.fromIdentifierToColumn(match.group(1));
            builder.year(column, column + "_year" + suffix);
        }) || PartitionFields.tryMatch(field, MONTH_PATTERN, match -> {
            String column = PartitionFields.fromIdentifierToColumn(match.group(1));
            builder.month(column, column + "_month" + suffix);
        }) || PartitionFields.tryMatch(field, DAY_PATTERN, match -> {
            String column = PartitionFields.fromIdentifierToColumn(match.group(1));
            builder.day(column, column + "_day" + suffix);
        }) || PartitionFields.tryMatch(field, HOUR_PATTERN, match -> {
            String column = PartitionFields.fromIdentifierToColumn(match.group(1));
            builder.hour(column, column + "_hour" + suffix);
        }) || PartitionFields.tryMatch(field, BUCKET_PATTERN, match -> {
            String column = PartitionFields.fromIdentifierToColumn(match.group(1));
            builder.bucket(column, Integer.parseInt(match.group(2)), column + "_bucket" + suffix);
        }) || PartitionFields.tryMatch(field, TRUNCATE_PATTERN, match -> {
            String column = PartitionFields.fromIdentifierToColumn(match.group(1));
            builder.truncate(column, Integer.parseInt(match.group(2)), column + "_trunc" + suffix);
        }) || PartitionFields.tryMatch(field, VOID_PATTERN, match -> {
            String column = PartitionFields.fromIdentifierToColumn(match.group(1));
            builder.alwaysNull(column, column + "_null" + suffix);
        });
        if (!matched) {
            throw new IllegalArgumentException("Invalid partition field declaration: " + field);
        }
    }

    public static String fromIdentifierToColumn(String identifier) {
        if (QUOTED_IDENTIFIER_PATTERN.matcher(identifier).matches()) {
            return identifier.substring(1, identifier.length() - 1).replace("\"\"", "\"");
        }
        return identifier.toLowerCase(Locale.ENGLISH);
    }

    private static boolean tryMatch(CharSequence value, Pattern pattern, Consumer<MatchResult> match) {
        Matcher matcher = pattern.matcher(value);
        if (matcher.matches()) {
            match.accept(matcher.toMatchResult());
            return true;
        }
        return false;
    }

    public static List<String> toPartitionFields(PartitionSpec spec) {
        return (List)spec.fields().stream().map(field -> PartitionFields.toPartitionField(spec, field)).collect(ImmutableList.toImmutableList());
    }

    private static String toPartitionField(PartitionSpec spec, PartitionField field) {
        String transform;
        String name = PartitionFields.fromColumnToIdentifier(spec.schema().findColumnName(field.sourceId()));
        switch (transform = field.transform().toString()) {
            case "identity": {
                return name;
            }
            case "year": 
            case "month": 
            case "day": 
            case "hour": 
            case "void": {
                return String.format("%s(%s)", transform, name);
            }
        }
        Matcher matcher = ICEBERG_BUCKET_PATTERN.matcher(transform);
        if (matcher.matches()) {
            return String.format("bucket(%s, %s)", name, matcher.group(1));
        }
        matcher = ICEBERG_TRUNCATE_PATTERN.matcher(transform);
        if (matcher.matches()) {
            return String.format("truncate(%s, %s)", name, matcher.group(1));
        }
        throw new UnsupportedOperationException("Unsupported partition transform: " + String.valueOf(field));
    }

    private static String fromColumnToIdentifier(String column) {
        return PartitionFields.quotedName(column);
    }

    public static String quotedName(String name) {
        if (UNQUOTED_IDENTIFIER_PATTERN.matcher(name).matches() && name.toLowerCase(Locale.ENGLISH).equals(name)) {
            return name;
        }
        return "\"" + name.replace("\"", "\"\"") + "\"";
    }
}

