/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.plugin.iceberg.IcebergStatistics;
import io.trino.plugin.iceberg.IcebergTypes;
import io.trino.plugin.iceberg.IcebergUtil;
import io.trino.plugin.iceberg.StructLikeWrapperWithFieldIdToIndex;
import io.trino.plugin.iceberg.TypeConverter;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.RowValueBuilder;
import io.trino.spi.block.SqlRow;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.InMemoryRecordSet;
import io.trino.spi.connector.RecordCursor;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SystemTable;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeUtils;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.PartitionField;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;

public class PartitionsTable
implements SystemTable {
    private final TypeManager typeManager;
    private final Table icebergTable;
    private final Optional<Long> snapshotId;
    private final Map<Integer, Type.PrimitiveType> idToTypeMapping;
    private final List<Types.NestedField> nonPartitionPrimitiveColumns;
    private final Optional<IcebergPartitionColumn> partitionColumnType;
    private final List<PartitionField> partitionFields;
    private final Optional<RowType> dataColumnType;
    private final List<RowType> columnMetricTypes;
    private final List<io.trino.spi.type.Type> resultTypes;
    private final ConnectorTableMetadata connectorTableMetadata;
    private final ExecutorService executor;

    public PartitionsTable(SchemaTableName tableName, TypeManager typeManager, Table icebergTable, Optional<Long> snapshotId, ExecutorService executor) {
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.icebergTable = Objects.requireNonNull(icebergTable, "icebergTable is null");
        this.snapshotId = Objects.requireNonNull(snapshotId, "snapshotId is null");
        this.idToTypeMapping = IcebergUtil.primitiveFieldTypes(icebergTable.schema());
        List columns = icebergTable.schema().columns();
        this.partitionFields = PartitionsTable.getAllPartitionFields(icebergTable);
        ImmutableList.Builder columnMetadataBuilder = ImmutableList.builder();
        this.partitionColumnType = this.getPartitionColumnType(this.partitionFields, icebergTable.schema());
        this.partitionColumnType.ifPresent(icebergPartitionColumn -> columnMetadataBuilder.add((Object)new ColumnMetadata("partition", (io.trino.spi.type.Type)icebergPartitionColumn.rowType)));
        Stream.of("record_count", "file_count", "total_size").forEach(metric -> columnMetadataBuilder.add((Object)new ColumnMetadata(metric, (io.trino.spi.type.Type)BigintType.BIGINT)));
        Set identityPartitionIds = IcebergUtil.getIdentityPartitions(icebergTable.spec()).keySet().stream().map(PartitionField::sourceId).collect(Collectors.toSet());
        this.nonPartitionPrimitiveColumns = (List)columns.stream().filter(column -> !identityPartitionIds.contains(column.fieldId()) && column.type().isPrimitiveType()).collect(ImmutableList.toImmutableList());
        this.dataColumnType = this.getMetricsColumnType(this.nonPartitionPrimitiveColumns);
        if (this.dataColumnType.isPresent()) {
            columnMetadataBuilder.add((Object)new ColumnMetadata("data", (io.trino.spi.type.Type)this.dataColumnType.get()));
            this.columnMetricTypes = (List)this.dataColumnType.get().getFields().stream().map(RowType.Field::getType).map(RowType.class::cast).collect(ImmutableList.toImmutableList());
        } else {
            this.columnMetricTypes = ImmutableList.of();
        }
        ImmutableList columnMetadata = columnMetadataBuilder.build();
        this.resultTypes = (List)columnMetadata.stream().map(ColumnMetadata::getType).collect(ImmutableList.toImmutableList());
        this.connectorTableMetadata = new ConnectorTableMetadata(tableName, (List)columnMetadata);
        this.executor = Objects.requireNonNull(executor, "executor is null");
    }

    public SystemTable.Distribution getDistribution() {
        return SystemTable.Distribution.SINGLE_COORDINATOR;
    }

    public ConnectorTableMetadata getTableMetadata() {
        return this.connectorTableMetadata;
    }

    static List<PartitionField> getAllPartitionFields(Table icebergTable) {
        Set existingColumnsIds = TypeUtil.indexById((Types.StructType)icebergTable.schema().asStruct()).keySet();
        List visiblePartitionFields = (List)icebergTable.specs().values().stream().flatMap(partitionSpec -> partitionSpec.fields().stream()).filter(partitionField -> existingColumnsIds.contains(partitionField.sourceId())).collect(ImmutableList.toImmutableList());
        return PartitionsTable.filterOutDuplicates(visiblePartitionFields);
    }

    private static List<PartitionField> filterOutDuplicates(List<PartitionField> visiblePartitionFields) {
        HashSet<Integer> alreadyExistingFieldIds = new HashSet<Integer>();
        ArrayList<PartitionField> result = new ArrayList<PartitionField>();
        for (PartitionField partitionField : visiblePartitionFields) {
            if (alreadyExistingFieldIds.contains(partitionField.fieldId())) continue;
            alreadyExistingFieldIds.add(partitionField.fieldId());
            result.add(partitionField);
        }
        return result;
    }

    private Optional<IcebergPartitionColumn> getPartitionColumnType(List<PartitionField> fields, Schema schema) {
        if (fields.isEmpty()) {
            return Optional.empty();
        }
        List partitionFields = (List)fields.stream().map(field -> RowType.field((String)field.name(), (io.trino.spi.type.Type)TypeConverter.toTrinoType(field.transform().getResultType(schema.findType(field.sourceId())), this.typeManager))).collect(ImmutableList.toImmutableList());
        List fieldIds = (List)fields.stream().map(PartitionField::fieldId).collect(ImmutableList.toImmutableList());
        return Optional.of(new IcebergPartitionColumn(RowType.from((List)partitionFields), fieldIds));
    }

    private Optional<RowType> getMetricsColumnType(List<Types.NestedField> columns) {
        List metricColumns = (List)columns.stream().map(column -> RowType.field((String)column.name(), (io.trino.spi.type.Type)RowType.from((List)ImmutableList.of((Object)new RowType.Field(Optional.of("min"), TypeConverter.toTrinoType(column.type(), this.typeManager)), (Object)new RowType.Field(Optional.of("max"), TypeConverter.toTrinoType(column.type(), this.typeManager)), (Object)new RowType.Field(Optional.of("null_count"), (io.trino.spi.type.Type)BigintType.BIGINT), (Object)new RowType.Field(Optional.of("nan_count"), (io.trino.spi.type.Type)BigintType.BIGINT))))).collect(ImmutableList.toImmutableList());
        if (metricColumns.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(RowType.from((List)metricColumns));
    }

    public RecordCursor cursor(ConnectorTransactionHandle transactionHandle, ConnectorSession session, TupleDomain<Integer> constraint) {
        if (this.snapshotId.isEmpty()) {
            return new InMemoryRecordSet(this.resultTypes, (Iterable)ImmutableList.of()).cursor();
        }
        TableScan tableScan = (TableScan)((TableScan)this.icebergTable.newScan().useSnapshot(this.snapshotId.get().longValue()).includeColumnStats()).planWith(this.executor);
        return this.buildRecordCursor(this.getStatisticsByPartition(tableScan));
    }

    private Map<StructLikeWrapperWithFieldIdToIndex, IcebergStatistics> getStatisticsByPartition(TableScan tableScan) {
        Object object;
        block9: {
            CloseableIterable fileScanTasks = tableScan.planFiles();
            try {
                HashMap<StructLikeWrapperWithFieldIdToIndex, IcebergStatistics.Builder> partitions = new HashMap<StructLikeWrapperWithFieldIdToIndex, IcebergStatistics.Builder>();
                for (FileScanTask fileScanTask : fileScanTasks) {
                    DataFile dataFile = (DataFile)fileScanTask.file();
                    StructLikeWrapperWithFieldIdToIndex structLikeWrapperWithFieldIdToIndex2 = StructLikeWrapperWithFieldIdToIndex.createStructLikeWrapper(fileScanTask);
                    partitions.computeIfAbsent(structLikeWrapperWithFieldIdToIndex2, structLikeWrapperWithFieldIdToIndex -> new IcebergStatistics.Builder(this.icebergTable.schema().columns(), this.typeManager)).acceptDataFile(dataFile, fileScanTask.spec());
                }
                object = (Map)partitions.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((IcebergStatistics.Builder)entry.getValue()).build()));
                if (fileScanTasks == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (fileScanTasks != null) {
                        try {
                            fileScanTasks.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            fileScanTasks.close();
        }
        return object;
    }

    private RecordCursor buildRecordCursor(Map<StructLikeWrapperWithFieldIdToIndex, IcebergStatistics> partitionStatistics) {
        List<Type> partitionTypes = this.partitionTypes();
        List partitionColumnClass = (List)partitionTypes.stream().map(type -> type.typeId().javaClass()).collect(ImmutableList.toImmutableList());
        ImmutableList.Builder records = ImmutableList.builder();
        for (Map.Entry<StructLikeWrapperWithFieldIdToIndex, IcebergStatistics> partitionEntry : partitionStatistics.entrySet()) {
            StructLikeWrapperWithFieldIdToIndex partitionStruct = partitionEntry.getKey();
            IcebergStatistics icebergStatistics = partitionEntry.getValue();
            ArrayList<Long> row = new ArrayList<Long>();
            this.partitionColumnType.ifPresent(partitionColumnType -> row.add((Long)RowValueBuilder.buildRowValue((RowType)partitionColumnType.rowType, fields -> {
                List partitionColumnTypes = (List)partitionColumnType.rowType.getFields().stream().map(RowType.Field::getType).collect(ImmutableList.toImmutableList());
                for (int i = 0; i < partitionColumnTypes.size(); ++i) {
                    io.trino.spi.type.Type trinoType = ((RowType.Field)partitionColumnType.rowType.getFields().get(i)).getType();
                    Object value = null;
                    Integer fieldId = partitionColumnType.fieldIds.get(i);
                    if (partitionStruct.getFieldIdToIndex().containsKey(fieldId)) {
                        value = IcebergTypes.convertIcebergValueToTrino((Type)partitionTypes.get(i), partitionStruct.getStructLikeWrapper().get().get(partitionStruct.getFieldIdToIndex().get(fieldId).intValue(), (Class)partitionColumnClass.get(i)));
                    }
                    TypeUtils.writeNativeValue((io.trino.spi.type.Type)trinoType, (BlockBuilder)((BlockBuilder)fields.get(i)), value);
                }
            })));
            row.add(icebergStatistics.recordCount());
            row.add(icebergStatistics.fileCount());
            row.add(icebergStatistics.size());
            this.dataColumnType.ifPresent(dataColumnType -> {
                try {
                    row.add((Long)RowValueBuilder.buildRowValue((RowType)dataColumnType, fields -> {
                        for (int i = 0; i < this.columnMetricTypes.size(); ++i) {
                            Integer fieldId = this.nonPartitionPrimitiveColumns.get(i).fieldId();
                            Object min = icebergStatistics.minValues().get(fieldId);
                            Object max = icebergStatistics.maxValues().get(fieldId);
                            Long nullCount = icebergStatistics.nullCounts().get(fieldId);
                            Long nanCount = icebergStatistics.nanCounts().get(fieldId);
                            if (min == null && max == null && nullCount == null) {
                                throw new MissingColumnMetricsException();
                            }
                            RowType columnMetricType = this.columnMetricTypes.get(i);
                            columnMetricType.writeObject((BlockBuilder)fields.get(i), (Object)PartitionsTable.getColumnMetricBlock(columnMetricType, min, max, nullCount, nanCount));
                        }
                    }));
                }
                catch (MissingColumnMetricsException missingColumnMetricsException) {
                    row.add(null);
                }
            });
            records.add(row);
        }
        return new InMemoryRecordSet(this.resultTypes, (Iterable)records.build()).cursor();
    }

    private List<Type> partitionTypes() {
        ImmutableList.Builder partitionTypeBuilder = ImmutableList.builder();
        for (PartitionField partitionField : this.partitionFields) {
            Type.PrimitiveType sourceType = this.idToTypeMapping.get(partitionField.sourceId());
            Type type = partitionField.transform().getResultType((Type)sourceType);
            partitionTypeBuilder.add((Object)type);
        }
        return partitionTypeBuilder.build();
    }

    private static SqlRow getColumnMetricBlock(RowType columnMetricType, Object min, Object max, Long nullCount, Long nanCount) {
        return RowValueBuilder.buildRowValue((RowType)columnMetricType, fieldBuilders -> {
            List fields = columnMetricType.getFields();
            TypeUtils.writeNativeValue((io.trino.spi.type.Type)((RowType.Field)fields.get(0)).getType(), (BlockBuilder)((BlockBuilder)fieldBuilders.get(0)), (Object)min);
            TypeUtils.writeNativeValue((io.trino.spi.type.Type)((RowType.Field)fields.get(1)).getType(), (BlockBuilder)((BlockBuilder)fieldBuilders.get(1)), (Object)max);
            TypeUtils.writeNativeValue((io.trino.spi.type.Type)((RowType.Field)fields.get(2)).getType(), (BlockBuilder)((BlockBuilder)fieldBuilders.get(2)), (Object)nullCount);
            TypeUtils.writeNativeValue((io.trino.spi.type.Type)((RowType.Field)fields.get(3)).getType(), (BlockBuilder)((BlockBuilder)fieldBuilders.get(3)), (Object)nanCount);
        });
    }

    private record IcebergPartitionColumn(RowType rowType, List<Integer> fieldIds) {
    }

    private static class MissingColumnMetricsException
    extends Exception {
        private MissingColumnMetricsException() {
        }
    }
}

