/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.collect.ImmutableList;
import io.trino.plugin.iceberg.util.PageListBuilder;
import io.trino.spi.Page;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.FixedPageSource;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SystemTable;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.List;
import java.util.Objects;
import org.apache.iceberg.Table;

public class PropertiesTable
implements SystemTable {
    private final ConnectorTableMetadata tableMetadata;
    private final Table icebergTable;

    public PropertiesTable(SchemaTableName tableName, Table icebergTable) {
        this.icebergTable = Objects.requireNonNull(icebergTable, "icebergTable is null");
        this.tableMetadata = new ConnectorTableMetadata(Objects.requireNonNull(tableName, "tableName is null"), (List)ImmutableList.builder().add((Object)new ColumnMetadata("key", (Type)VarcharType.VARCHAR)).add((Object)new ColumnMetadata("value", (Type)VarcharType.VARCHAR)).build());
    }

    public SystemTable.Distribution getDistribution() {
        return SystemTable.Distribution.SINGLE_COORDINATOR;
    }

    public ConnectorTableMetadata getTableMetadata() {
        return this.tableMetadata;
    }

    public ConnectorPageSource pageSource(ConnectorTransactionHandle transactionHandle, ConnectorSession session, TupleDomain<Integer> constraint) {
        return new FixedPageSource(PropertiesTable.buildPages(this.tableMetadata, this.icebergTable));
    }

    private static List<Page> buildPages(ConnectorTableMetadata tableMetadata, Table icebergTable) {
        PageListBuilder pagesBuilder = PageListBuilder.forTable(tableMetadata);
        icebergTable.properties().entrySet().forEach(prop -> {
            pagesBuilder.beginRow();
            pagesBuilder.appendVarchar((String)prop.getKey());
            pagesBuilder.appendVarchar((String)prop.getValue());
            pagesBuilder.endRow();
        });
        return pagesBuilder.build();
    }
}

