/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.collect.ImmutableList;
import io.trino.plugin.iceberg.BaseSystemTable;
import io.trino.plugin.iceberg.util.PageListBuilder;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import org.apache.iceberg.MetadataTableType;
import org.apache.iceberg.Table;

public class RefsTable
extends BaseSystemTable {
    private static final List<ColumnMetadata> COLUMNS = ImmutableList.builder().add((Object)new ColumnMetadata("name", (Type)VarcharType.VARCHAR)).add((Object)new ColumnMetadata("type", (Type)VarcharType.VARCHAR)).add((Object)new ColumnMetadata("snapshot_id", (Type)BigintType.BIGINT)).add((Object)new ColumnMetadata("max_reference_age_in_ms", (Type)BigintType.BIGINT)).add((Object)new ColumnMetadata("min_snapshots_to_keep", (Type)IntegerType.INTEGER)).add((Object)new ColumnMetadata("max_snapshot_age_in_ms", (Type)BigintType.BIGINT)).build();

    public RefsTable(SchemaTableName tableName, Table icebergTable, ExecutorService executor) {
        super(Objects.requireNonNull(icebergTable, "icebergTable is null"), new ConnectorTableMetadata(Objects.requireNonNull(tableName, "tableName is null"), COLUMNS), MetadataTableType.REFS, executor);
    }

    @Override
    protected void addRow(PageListBuilder pagesBuilder, BaseSystemTable.Row row, TimeZoneKey timeZoneKey) {
        pagesBuilder.beginRow();
        pagesBuilder.appendVarchar(row.get("name", String.class));
        pagesBuilder.appendVarchar(row.get("type", String.class));
        pagesBuilder.appendBigint(row.get("snapshot_id", Long.class));
        pagesBuilder.appendBigint(row.get("max_reference_age_in_ms", Long.class));
        pagesBuilder.appendInteger(row.get("min_snapshots_to_keep", Integer.class));
        pagesBuilder.appendBigint(row.get("max_snapshot_age_in_ms", Long.class));
        pagesBuilder.endRow();
    }
}

