/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.collect.ImmutableList;
import io.trino.plugin.iceberg.BaseSystemTable;
import io.trino.plugin.iceberg.util.PageListBuilder;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.VarcharType;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import org.apache.iceberg.MetadataTableType;
import org.apache.iceberg.Table;

public class SnapshotsTable
extends BaseSystemTable {
    private static final String COMMITTED_AT_COLUMN_NAME = "committed_at";
    private static final String SNAPSHOT_ID_COLUMN_NAME = "snapshot_id";
    private static final String PARENT_ID_COLUMN_NAME = "parent_id";
    private static final String OPERATION_COLUMN_NAME = "operation";
    private static final String MANIFEST_LIST_COLUMN_NAME = "manifest_list";
    private static final String SUMMARY_COLUMN_NAME = "summary";

    public SnapshotsTable(SchemaTableName tableName, TypeManager typeManager, Table icebergTable, ExecutorService executor) {
        super(Objects.requireNonNull(icebergTable, "icebergTable is null"), SnapshotsTable.createConnectorTableMetadata(Objects.requireNonNull(tableName, "tableName is null"), Objects.requireNonNull(typeManager, "typeManager is null")), MetadataTableType.SNAPSHOTS, executor);
    }

    private static ConnectorTableMetadata createConnectorTableMetadata(SchemaTableName tableName, TypeManager typeManager) {
        return new ConnectorTableMetadata(tableName, (List)ImmutableList.builder().add((Object)new ColumnMetadata(COMMITTED_AT_COLUMN_NAME, (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS)).add((Object)new ColumnMetadata(SNAPSHOT_ID_COLUMN_NAME, (Type)BigintType.BIGINT)).add((Object)new ColumnMetadata(PARENT_ID_COLUMN_NAME, (Type)BigintType.BIGINT)).add((Object)new ColumnMetadata(OPERATION_COLUMN_NAME, (Type)VarcharType.VARCHAR)).add((Object)new ColumnMetadata(MANIFEST_LIST_COLUMN_NAME, (Type)VarcharType.VARCHAR)).add((Object)new ColumnMetadata(SUMMARY_COLUMN_NAME, typeManager.getType(TypeSignature.mapType((TypeSignature)VarcharType.VARCHAR.getTypeSignature(), (TypeSignature)VarcharType.VARCHAR.getTypeSignature())))).build());
    }

    @Override
    protected void addRow(PageListBuilder pagesBuilder, BaseSystemTable.Row row, TimeZoneKey timeZoneKey) {
        pagesBuilder.beginRow();
        pagesBuilder.appendTimestampTzMillis(row.get(COMMITTED_AT_COLUMN_NAME, Long.class) / 1000L, timeZoneKey);
        pagesBuilder.appendBigint(row.get(SNAPSHOT_ID_COLUMN_NAME, Long.class));
        pagesBuilder.appendBigint(row.get(PARENT_ID_COLUMN_NAME, Long.class));
        pagesBuilder.appendVarchar(row.get(OPERATION_COLUMN_NAME, String.class));
        pagesBuilder.appendVarchar(row.get(MANIFEST_LIST_COLUMN_NAME, String.class));
        pagesBuilder.appendVarcharVarcharMap(row.get(SUMMARY_COLUMN_NAME, Map.class));
        pagesBuilder.endRow();
    }
}

