/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.IntStream;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.StructLikeWrapper;

public class StructLikeWrapperWithFieldIdToIndex {
    private final StructLikeWrapper structLikeWrapper;
    private final Map<Integer, Integer> fieldIdToIndex;

    public static StructLikeWrapperWithFieldIdToIndex createStructLikeWrapper(FileScanTask fileScanTask) {
        Types.StructType structType = fileScanTask.spec().partitionType();
        StructLikeWrapper partitionWrapper = StructLikeWrapper.forType((Types.StructType)structType).set(((DataFile)fileScanTask.file()).partition());
        return new StructLikeWrapperWithFieldIdToIndex(partitionWrapper, structType);
    }

    @VisibleForTesting
    StructLikeWrapperWithFieldIdToIndex(StructLikeWrapper structLikeWrapper, Types.StructType structType) {
        this.structLikeWrapper = structLikeWrapper;
        ImmutableMap.Builder fieldIdToIndex = ImmutableMap.builder();
        List fields = structType.fields();
        IntStream.range(0, fields.size()).forEach(i -> fieldIdToIndex.put((Object)((Types.NestedField)fields.get(i)).fieldId(), (Object)i));
        this.fieldIdToIndex = fieldIdToIndex.buildOrThrow();
    }

    public StructLikeWrapper getStructLikeWrapper() {
        return this.structLikeWrapper;
    }

    public Map<Integer, Integer> getFieldIdToIndex() {
        return this.fieldIdToIndex;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StructLikeWrapperWithFieldIdToIndex that = (StructLikeWrapperWithFieldIdToIndex)o;
        return Objects.equals(this.fieldIdToIndex, that.fieldIdToIndex) && Objects.equals(this.structLikeWrapper, that.structLikeWrapper);
    }

    public int hashCode() {
        return Objects.hash(this.fieldIdToIndex, this.structLikeWrapper);
    }
}

