/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.SchemaTableName;
import java.util.Objects;

public class UnknownTableTypeException
extends TrinoException {
    private final SchemaTableName tableName;

    public UnknownTableTypeException(SchemaTableName tableName) {
        super((ErrorCodeSupplier)StandardErrorCode.UNSUPPORTED_TABLE_TYPE, "Not an Iceberg table: " + String.valueOf(tableName));
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
    }

    public SchemaTableName getTableName() {
        return this.tableName;
    }
}

