/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.metastore.TableInfo;
import io.trino.plugin.hive.metastore.glue.v1.GlueToTrinoConverter;
import io.trino.plugin.hive.util.HiveUtil;
import io.trino.plugin.iceberg.ColumnIdentity;
import io.trino.plugin.iceberg.IcebergErrorCode;
import io.trino.plugin.iceberg.IcebergMaterializedViewDefinition;
import io.trino.plugin.iceberg.IcebergMaterializedViewProperties;
import io.trino.plugin.iceberg.IcebergTableName;
import io.trino.plugin.iceberg.IcebergTableProperties;
import io.trino.plugin.iceberg.IcebergUtil;
import io.trino.plugin.iceberg.PartitionFields;
import io.trino.plugin.iceberg.PartitionTransforms;
import io.trino.plugin.iceberg.SortFieldUtils;
import io.trino.plugin.iceberg.TableType;
import io.trino.plugin.iceberg.TypeConverter;
import io.trino.plugin.iceberg.catalog.IcebergTableOperations;
import io.trino.plugin.iceberg.catalog.IcebergTableOperationsProvider;
import io.trino.plugin.iceberg.catalog.TrinoCatalog;
import io.trino.plugin.iceberg.fileio.ForwardingFileIo;
import io.trino.plugin.iceberg.fileio.ForwardingOutputFile;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.catalog.CatalogName;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorMaterializedViewDefinition;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorViewDefinition;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.TableNotFoundException;
import io.trino.spi.connector.ViewNotFoundException;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimeWithTimeZoneType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.VarcharType;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;
import org.apache.iceberg.AppendFiles;
import org.apache.iceberg.BaseTable;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableMetadataParser;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.Transaction;
import org.apache.iceberg.Transactions;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.types.Types;

public abstract class AbstractTrinoCatalog
implements TrinoCatalog {
    public static final String TRINO_CREATED_BY_VALUE = "Trino Iceberg connector";
    public static final String ICEBERG_VIEW_RUN_AS_OWNER = "trino.run-as-owner";
    protected static final String TRINO_CREATED_BY = "trino_created_by";
    protected static final String TRINO_QUERY_ID_NAME = "trino_query_id";
    private final CatalogName catalogName;
    protected final TypeManager typeManager;
    protected final IcebergTableOperationsProvider tableOperationsProvider;
    private final TrinoFileSystemFactory fileSystemFactory;
    private final boolean useUniqueTableLocation;

    protected AbstractTrinoCatalog(CatalogName catalogName, TypeManager typeManager, IcebergTableOperationsProvider tableOperationsProvider, TrinoFileSystemFactory fileSystemFactory, boolean useUniqueTableLocation) {
        this.catalogName = Objects.requireNonNull(catalogName, "catalogName is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.tableOperationsProvider = Objects.requireNonNull(tableOperationsProvider, "tableOperationsProvider is null");
        this.fileSystemFactory = Objects.requireNonNull(fileSystemFactory, "fileSystemFactory is null");
        this.useUniqueTableLocation = useUniqueTableLocation;
    }

    @Override
    public void updateTableComment(ConnectorSession session, SchemaTableName schemaTableName, Optional<String> comment) {
        Table icebergTable = this.loadTable(session, schemaTableName);
        if (comment.isEmpty()) {
            icebergTable.updateProperties().remove("comment").commit();
        } else {
            icebergTable.updateProperties().set("comment", comment.get()).commit();
        }
        this.invalidateTableCache(schemaTableName);
    }

    @Override
    public void updateColumnComment(ConnectorSession session, SchemaTableName schemaTableName, ColumnIdentity columnIdentity, Optional<String> comment) {
        Table icebergTable = this.loadTable(session, schemaTableName);
        icebergTable.updateSchema().updateColumnDoc(columnIdentity.getName(), (String)comment.orElse(null)).commit();
        this.invalidateTableCache(schemaTableName);
    }

    @Override
    public Map<SchemaTableName, ConnectorViewDefinition> getViews(ConnectorSession session, Optional<String> namespace) {
        ImmutableMap.Builder views = ImmutableMap.builder();
        for (TableInfo tableInfo : this.listTables(session, namespace)) {
            if (tableInfo.extendedRelationType() != TableInfo.ExtendedRelationType.TRINO_VIEW) continue;
            SchemaTableName name = tableInfo.tableName();
            try {
                this.getView(session, name).ifPresent(view -> views.put((Object)name, view));
            }
            catch (TrinoException e) {
                if (e.getErrorCode().equals((Object)StandardErrorCode.TABLE_NOT_FOUND.toErrorCode()) || e instanceof TableNotFoundException || e instanceof ViewNotFoundException) continue;
                throw e;
            }
        }
        return views.buildOrThrow();
    }

    @Override
    public Optional<ConnectorMaterializedViewDefinition> getMaterializedView(ConnectorSession session, SchemaTableName schemaViewName) {
        return this.doGetMaterializedView(session, schemaViewName);
    }

    protected abstract Optional<ConnectorMaterializedViewDefinition> doGetMaterializedView(ConnectorSession var1, SchemaTableName var2);

    @Override
    public Map<String, Object> getMaterializedViewProperties(ConnectorSession session, SchemaTableName viewName, ConnectorMaterializedViewDefinition definition) {
        SchemaTableName storageTableName = ((CatalogSchemaTableName)definition.getStorageTable().orElseThrow(() -> new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_INVALID_METADATA, "Materialized view definition is missing a storage table"))).getSchemaTableName();
        try {
            Table storageTable = this.loadTable(session, ((CatalogSchemaTableName)definition.getStorageTable().orElseThrow()).getSchemaTableName());
            return ImmutableMap.builder().putAll(IcebergUtil.getIcebergTableProperties(storageTable)).put((Object)"storage_schema", (Object)storageTableName.getSchemaName()).buildOrThrow();
        }
        catch (RuntimeException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_FILESYSTEM_ERROR, "Unable to load storage table metadata for materialized view: " + String.valueOf(viewName));
        }
    }

    protected Transaction newCreateTableTransaction(ConnectorSession session, SchemaTableName schemaTableName, Schema schema, PartitionSpec partitionSpec, SortOrder sortOrder, String location, Map<String, String> properties, Optional<String> owner) {
        TableMetadata metadata = TableMetadata.newTableMetadata((Schema)schema, (PartitionSpec)partitionSpec, (SortOrder)sortOrder, (String)location, properties);
        IcebergTableOperations ops = this.tableOperationsProvider.createTableOperations(this, session, schemaTableName.getSchemaName(), schemaTableName.getTableName(), owner, Optional.of(location));
        return Transactions.createTableTransaction((String)schemaTableName.toString(), (TableOperations)ops, (TableMetadata)metadata);
    }

    protected Transaction newCreateOrReplaceTableTransaction(ConnectorSession session, SchemaTableName schemaTableName, Schema schema, PartitionSpec partitionSpec, SortOrder sortOrder, String location, Map<String, String> properties, Optional<String> owner) {
        TableMetadata newMetaData;
        Optional<Object> metadata = Optional.empty();
        try {
            BaseTable table = (BaseTable)this.loadTable(session, new SchemaTableName(schemaTableName.getSchemaName(), schemaTableName.getTableName()));
            metadata = Optional.of(table.operations().current());
        }
        catch (TableNotFoundException tableNotFoundException) {
            // empty catch block
        }
        IcebergTableOperations operations = this.tableOperationsProvider.createTableOperations(this, session, schemaTableName.getSchemaName(), schemaTableName.getTableName(), owner, Optional.of(location));
        if (metadata.isPresent()) {
            operations.initializeFromMetadata((TableMetadata)metadata.get());
            newMetaData = operations.current().replaceProperties(properties).buildReplacement(schema, partitionSpec, sortOrder, location, properties);
        } else {
            newMetaData = TableMetadata.newTableMetadata((Schema)schema, (PartitionSpec)partitionSpec, (SortOrder)sortOrder, (String)location, properties);
        }
        return Transactions.createOrReplaceTableTransaction((String)schemaTableName.toString(), (TableOperations)operations, (TableMetadata)newMetaData);
    }

    protected String createNewTableName(String baseTableName) {
        Object tableNameLocationComponent = HiveUtil.escapeTableName((String)baseTableName);
        if (this.useUniqueTableLocation) {
            tableNameLocationComponent = (String)tableNameLocationComponent + "-" + UUID.randomUUID().toString().replace("-", "");
        }
        return tableNameLocationComponent;
    }

    protected void deleteTableDirectory(TrinoFileSystem fileSystem, SchemaTableName schemaTableName, String tableLocation) {
        try {
            fileSystem.deleteDirectory(Location.of((String)tableLocation));
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_FILESYSTEM_ERROR, String.format("Failed to delete directory %s of the table %s", tableLocation, schemaTableName), (Throwable)e);
        }
    }

    protected Location createMaterializedViewStorage(ConnectorSession session, SchemaTableName viewName, ConnectorMaterializedViewDefinition definition, Map<String, Object> materializedViewProperties) {
        if (IcebergMaterializedViewProperties.getStorageSchema(materializedViewProperties).isPresent()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Materialized view property '%s' is not supported when hiding materialized view storage tables is enabled".formatted("storage_schema"));
        }
        SchemaTableName storageTableName = new SchemaTableName(viewName.getSchemaName(), IcebergTableName.tableNameWithType(viewName.getTableName(), TableType.MATERIALIZED_VIEW_STORAGE));
        String tableLocation = IcebergTableProperties.getTableLocation(materializedViewProperties).orElseGet(() -> this.defaultTableLocation(session, viewName));
        List<ColumnMetadata> columns = this.columnsForMaterializedView(definition, materializedViewProperties);
        Schema schema = IcebergUtil.schemaFromMetadata(columns);
        PartitionSpec partitionSpec = PartitionFields.parsePartitionFields(schema, IcebergTableProperties.getPartitioning(materializedViewProperties));
        SortOrder sortOrder = SortFieldUtils.parseSortFields(schema, IcebergTableProperties.getSortOrder(materializedViewProperties));
        Map<String, String> properties = IcebergUtil.createTableProperties(new ConnectorTableMetadata(storageTableName, columns, materializedViewProperties, Optional.empty()), string -> false);
        TableMetadata metadata = TableMetadata.newTableMetadata((Schema)schema, (PartitionSpec)partitionSpec, (SortOrder)sortOrder, (String)tableLocation, properties);
        String fileName = String.format("%05d-%s%s", 0, UUID.randomUUID(), TableMetadataParser.getFileExtension((String)"none"));
        Location metadataFileLocation = Location.of((String)tableLocation).appendPath("metadata").appendPath(fileName);
        TrinoFileSystem fileSystem = this.fileSystemFactory.create(session);
        TableMetadataParser.write((TableMetadata)metadata, (OutputFile)new ForwardingOutputFile(fileSystem, metadataFileLocation));
        return metadataFileLocation;
    }

    protected void dropMaterializedViewStorage(TrinoFileSystem fileSystem, String storageMetadataLocation) throws IOException {
        TableMetadata metadata = TableMetadataParser.read((FileIO)new ForwardingFileIo(fileSystem), (String)storageMetadataLocation);
        String storageLocation = metadata.location();
        fileSystem.deleteDirectory(Location.of((String)storageLocation));
    }

    protected SchemaTableName createMaterializedViewStorageTable(ConnectorSession session, SchemaTableName viewName, ConnectorMaterializedViewDefinition definition, Map<String, Object> materializedViewProperties) {
        String storageTableName = "st_" + UUID.randomUUID().toString().replace("-", "");
        String storageSchema = IcebergMaterializedViewProperties.getStorageSchema(materializedViewProperties).orElse(viewName.getSchemaName());
        SchemaTableName storageTable = new SchemaTableName(storageSchema, storageTableName);
        List<ColumnMetadata> columns = this.columnsForMaterializedView(definition, materializedViewProperties);
        ConnectorTableMetadata tableMetadata = new ConnectorTableMetadata(storageTable, columns, materializedViewProperties, Optional.empty());
        String tableLocation = IcebergTableProperties.getTableLocation(tableMetadata.getProperties()).orElseGet(() -> this.defaultTableLocation(session, tableMetadata.getTable()));
        Transaction transaction = IcebergUtil.newCreateTableTransaction(this, tableMetadata, session, false, tableLocation, string -> false);
        AppendFiles appendFiles = transaction.newAppend();
        IcebergUtil.commit(appendFiles, session);
        transaction.commitTransaction();
        return storageTable;
    }

    private List<ColumnMetadata> columnsForMaterializedView(ConnectorMaterializedViewDefinition definition, Map<String, Object> materializedViewProperties) {
        Schema schemaWithTimestampTzPreserved = IcebergUtil.schemaFromMetadata(GlueToTrinoConverter.mappedCopy((List)definition.getColumns(), column -> {
            TimestampWithTimeZoneType timestampTzType;
            Object type = this.typeManager.getType(column.getType());
            type = type instanceof TimestampWithTimeZoneType && (timestampTzType = (TimestampWithTimeZoneType)type).getPrecision() <= 6 ? TimestampWithTimeZoneType.TIMESTAMP_TZ_MICROS : this.typeForMaterializedViewStorageTable((Type)type);
            return new ColumnMetadata(column.getName(), type);
        }));
        PartitionSpec partitionSpec = PartitionFields.parsePartitionFields(schemaWithTimestampTzPreserved, IcebergTableProperties.getPartitioning(materializedViewProperties));
        Set temporalPartitioningSources = (Set)partitionSpec.fields().stream().flatMap(partitionField -> {
            Types.NestedField sourceField = schemaWithTimestampTzPreserved.findField(partitionField.sourceId());
            Type sourceType = TypeConverter.toTrinoType(sourceField.type(), this.typeManager);
            PartitionTransforms.ColumnTransform columnTransform = PartitionTransforms.getColumnTransform(partitionField, sourceType);
            if (!columnTransform.temporal()) {
                return Stream.of(new String[0]);
            }
            return Stream.of(sourceField.name());
        }).collect(ImmutableSet.toImmutableSet());
        return GlueToTrinoConverter.mappedCopy((List)definition.getColumns(), column -> {
            TimestampWithTimeZoneType timestampTzType;
            Object type = this.typeManager.getType(column.getType());
            type = type instanceof TimestampWithTimeZoneType && (timestampTzType = (TimestampWithTimeZoneType)type).getPrecision() <= 6 && temporalPartitioningSources.contains(column.getName()) ? TimestampWithTimeZoneType.TIMESTAMP_TZ_MICROS : this.typeForMaterializedViewStorageTable((Type)type);
            return new ColumnMetadata(column.getName(), type);
        });
    }

    private Type typeForMaterializedViewStorageTable(Type type) {
        if (type == TinyintType.TINYINT || type == SmallintType.SMALLINT) {
            return IntegerType.INTEGER;
        }
        if (type instanceof CharType) {
            return VarcharType.VARCHAR;
        }
        if (type instanceof TimeType) {
            TimeType timeType = (TimeType)type;
            return timeType.getPrecision() <= 6 ? TimeType.TIME_MICROS : VarcharType.VARCHAR;
        }
        if (type instanceof TimeWithTimeZoneType) {
            return VarcharType.VARCHAR;
        }
        if (type instanceof TimestampType) {
            TimestampType timestampType = (TimestampType)type;
            return timestampType.getPrecision() <= 6 ? TimestampType.TIMESTAMP_MICROS : VarcharType.VARCHAR;
        }
        if (type instanceof TimestampWithTimeZoneType) {
            return VarcharType.VARCHAR;
        }
        if (type instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)type;
            return new ArrayType(this.typeForMaterializedViewStorageTable(arrayType.getElementType()));
        }
        if (type instanceof MapType) {
            MapType mapType = (MapType)type;
            return new MapType(this.typeForMaterializedViewStorageTable(mapType.getKeyType()), this.typeForMaterializedViewStorageTable(mapType.getValueType()), this.typeManager.getTypeOperators());
        }
        if (type instanceof RowType) {
            RowType rowType = (RowType)type;
            return RowType.rowType((RowType.Field[])((RowType.Field[])rowType.getFields().stream().map(field -> new RowType.Field(field.getName(), this.typeForMaterializedViewStorageTable(field.getType()))).toArray(RowType.Field[]::new)));
        }
        return type;
    }

    protected ConnectorMaterializedViewDefinition getMaterializedViewDefinition(Optional<String> owner, String viewOriginalText, SchemaTableName storageTableName) {
        IcebergMaterializedViewDefinition definition = IcebergMaterializedViewDefinition.decodeMaterializedViewData(viewOriginalText);
        return new ConnectorMaterializedViewDefinition(definition.originalSql(), Optional.of(new CatalogSchemaTableName(this.catalogName.toString(), storageTableName)), definition.catalog(), definition.schema(), this.toSpiMaterializedViewColumns(definition.columns()), definition.gracePeriod(), definition.comment(), owner, definition.path());
    }

    protected List<ConnectorMaterializedViewDefinition.Column> toSpiMaterializedViewColumns(List<IcebergMaterializedViewDefinition.Column> columns) {
        return (List)columns.stream().map(column -> new ConnectorMaterializedViewDefinition.Column(column.name(), column.type(), column.comment())).collect(ImmutableList.toImmutableList());
    }

    protected Map<String, String> createMaterializedViewProperties(ConnectorSession session, SchemaTableName storageTableName) {
        return ImmutableMap.builder().put((Object)TRINO_QUERY_ID_NAME, (Object)session.getQueryId()).put((Object)"storage_schema", (Object)storageTableName.getSchemaName()).put((Object)"storage_table", (Object)storageTableName.getTableName()).put((Object)"presto_view", (Object)"true").put((Object)TRINO_CREATED_BY, (Object)TRINO_CREATED_BY_VALUE).put((Object)"comment", (Object)"Presto Materialized View").buildOrThrow();
    }

    protected Map<String, String> createMaterializedViewProperties(ConnectorSession session, Location storageMetadataLocation) {
        return ImmutableMap.builder().put((Object)TRINO_QUERY_ID_NAME, (Object)session.getQueryId()).put((Object)"metadata_location", (Object)storageMetadataLocation.toString()).put((Object)"presto_view", (Object)"true").put((Object)TRINO_CREATED_BY, (Object)TRINO_CREATED_BY_VALUE).put((Object)"comment", (Object)"Presto Materialized View").buildOrThrow();
    }

    protected abstract void invalidateTableCache(SchemaTableName var1);
}

