/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog.file;

import com.google.common.base.Preconditions;
import io.trino.annotation.NotThreadSafe;
import io.trino.metastore.PrincipalPrivileges;
import io.trino.metastore.Table;
import io.trino.metastore.cache.CachingHiveMetastore;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.metastore.MetastoreUtil;
import io.trino.plugin.iceberg.IcebergTableName;
import io.trino.plugin.iceberg.catalog.hms.AbstractMetastoreTableOperations;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorSession;
import java.util.Optional;
import java.util.function.BiFunction;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.exceptions.CommitStateUnknownException;
import org.apache.iceberg.io.FileIO;

@NotThreadSafe
public class FileMetastoreTableOperations
extends AbstractMetastoreTableOperations {
    public FileMetastoreTableOperations(FileIO fileIo, CachingHiveMetastore metastore, ConnectorSession session, String database, String table, Optional<String> owner, Optional<String> location) {
        super(fileIo, metastore, session, database, table, owner, location);
    }

    @Override
    protected void commitToExistingTable(TableMetadata base, TableMetadata metadata) {
        Table currentTable = this.getTable();
        this.commitTableUpdate(currentTable, metadata, (table, newMetadataLocation) -> Table.builder((Table)table).apply(builder -> this.updateMetastoreTable((Table.Builder)builder, metadata, (String)newMetadataLocation, Optional.of(this.currentMetadataLocation))).build());
    }

    @Override
    protected void commitMaterializedViewRefresh(TableMetadata base, TableMetadata metadata) {
        Table materializedView = this.getTable(this.database, IcebergTableName.tableNameFrom(this.tableName));
        this.commitTableUpdate(materializedView, metadata, (table, newMetadataLocation) -> Table.builder((Table)table).apply(builder -> builder.setParameter("metadata_location", newMetadataLocation).setParameter("previous_metadata_location", this.currentMetadataLocation)).build());
    }

    private void commitTableUpdate(Table table, TableMetadata metadata, BiFunction<Table, String, Table> tableUpdateFunction) {
        Preconditions.checkState((this.currentMetadataLocation != null ? 1 : 0) != 0, (Object)"No current metadata location for existing table");
        String metadataLocation = (String)table.getParameters().get("metadata_location");
        if (!this.currentMetadataLocation.equals(metadataLocation)) {
            throw new CommitFailedException("Metadata location [%s] is not same as table metadata location [%s] for %s", new Object[]{this.currentMetadataLocation, metadataLocation, this.getSchemaTableName()});
        }
        String newMetadataLocation = this.writeNewMetadata(metadata, this.version.orElseThrow() + 1);
        Table updatedTable = tableUpdateFunction.apply(table, newMetadataLocation);
        PrincipalPrivileges privileges = table.getOwner().map(MetastoreUtil::buildInitialPrivilegeSet).orElse(PrincipalPrivileges.NO_PRIVILEGES);
        try {
            this.metastore.replaceTable(this.database, table.getTableName(), updatedTable, privileges);
        }
        catch (RuntimeException e) {
            TrinoException trinoException;
            if (e instanceof TrinoException && (trinoException = (TrinoException)((Object)e)).getErrorCode() == HiveErrorCode.HIVE_CONCURRENT_MODIFICATION_DETECTED.toErrorCode()) {
                throw new CommitFailedException((Throwable)e, "Failed to replace table due to concurrent updates: %s.%s", new Object[]{this.database, this.tableName});
            }
            throw new CommitStateUnknownException((Throwable)e);
        }
    }
}

