/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog.glue;

import com.amazonaws.services.glue.AWSGlueAsync;
import com.amazonaws.services.glue.model.AWSGlueException;
import com.amazonaws.services.glue.model.AlreadyExistsException;
import com.amazonaws.services.glue.model.ConcurrentModificationException;
import com.amazonaws.services.glue.model.CreateTableRequest;
import com.amazonaws.services.glue.model.EntityNotFoundException;
import com.amazonaws.services.glue.model.InvalidInputException;
import com.amazonaws.services.glue.model.ResourceNumberLimitExceededException;
import com.amazonaws.services.glue.model.StorageDescriptor;
import com.amazonaws.services.glue.model.Table;
import com.amazonaws.services.glue.model.TableInput;
import com.amazonaws.services.glue.model.UpdateTableRequest;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableMap;
import io.trino.plugin.hive.ViewReaderUtil;
import io.trino.plugin.hive.metastore.glue.GlueMetastoreStats;
import io.trino.plugin.hive.metastore.glue.v1.GlueToTrinoConverter;
import io.trino.plugin.hive.util.HiveUtil;
import io.trino.plugin.iceberg.IcebergErrorCode;
import io.trino.plugin.iceberg.IcebergTableName;
import io.trino.plugin.iceberg.UnknownTableTypeException;
import io.trino.plugin.iceberg.catalog.AbstractIcebergTableOperations;
import io.trino.plugin.iceberg.catalog.glue.GlueIcebergUtil;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.TableNotFoundException;
import io.trino.spi.type.TypeManager;
import jakarta.annotation.Nullable;
import java.lang.runtime.SwitchBootstraps;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.exceptions.CommitStateUnknownException;
import org.apache.iceberg.io.FileIO;

public class GlueIcebergTableOperations
extends AbstractIcebergTableOperations {
    private final TypeManager typeManager;
    private final boolean cacheTableMetadata;
    private final AWSGlueAsync glueClient;
    private final GlueMetastoreStats stats;
    private final GetGlueTable getGlueTable;
    @Nullable
    private String glueVersionId;

    protected GlueIcebergTableOperations(TypeManager typeManager, boolean cacheTableMetadata, AWSGlueAsync glueClient, GlueMetastoreStats stats, GetGlueTable getGlueTable, FileIO fileIo, ConnectorSession session, String database, String table, Optional<String> owner, Optional<String> location) {
        super(fileIo, session, database, table, owner, location);
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.cacheTableMetadata = cacheTableMetadata;
        this.glueClient = Objects.requireNonNull(glueClient, "glueClient is null");
        this.stats = Objects.requireNonNull(stats, "stats is null");
        this.getGlueTable = Objects.requireNonNull(getGlueTable, "getGlueTable is null");
    }

    @Override
    protected String getRefreshedLocation(boolean invalidateCaches) {
        boolean isMaterializedViewStorageTable = IcebergTableName.isMaterializedViewStorage(this.tableName);
        Table table = isMaterializedViewStorageTable ? this.getTable(this.database, IcebergTableName.tableNameFrom(this.tableName), invalidateCaches) : this.getTable(this.database, this.tableName, invalidateCaches);
        this.glueVersionId = table.getVersionId();
        String tableType = GlueToTrinoConverter.getTableType((Table)table);
        Map parameters = GlueToTrinoConverter.getTableParameters((Table)table);
        if (!isMaterializedViewStorageTable && (ViewReaderUtil.isTrinoView((String)tableType, (Map)parameters) || ViewReaderUtil.isTrinoMaterializedView((String)tableType, (Map)parameters))) {
            throw new TableNotFoundException(this.getSchemaTableName());
        }
        if (!isMaterializedViewStorageTable && !HiveUtil.isIcebergTable((Map)parameters)) {
            throw new UnknownTableTypeException(this.getSchemaTableName());
        }
        String metadataLocation = (String)parameters.get("metadata_location");
        if (metadataLocation == null) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_INVALID_METADATA, String.format("Table is missing [%s] property: %s", "metadata_location", this.getSchemaTableName()));
        }
        return metadataLocation;
    }

    @Override
    protected void commitNewTable(TableMetadata metadata) {
        Verify.verify((boolean)this.version.isEmpty(), (String)"commitNewTable called on a table which already exists", (Object[])new Object[0]);
        String newMetadataLocation = this.writeNewMetadata(metadata, 0);
        TableInput tableInput = GlueIcebergUtil.getTableInput(this.typeManager, this.tableName, this.owner, metadata, metadata.location(), newMetadataLocation, (Map<String, String>)ImmutableMap.of(), this.cacheTableMetadata);
        CreateTableRequest createTableRequest = new CreateTableRequest().withDatabaseName(this.database).withTableInput(tableInput);
        try {
            this.stats.getCreateTable().call(() -> this.glueClient.createTable(createTableRequest));
        }
        catch (AWSGlueException e) {
            AWSGlueException aWSGlueException = e;
            Objects.requireNonNull(aWSGlueException);
            AWSGlueException aWSGlueException2 = aWSGlueException;
            int n = 0;
            block5: while (true) {
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AlreadyExistsException.class, EntityNotFoundException.class, InvalidInputException.class, ResourceNumberLimitExceededException.class}, (AWSGlueException)aWSGlueException2, n)) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        if (!(aWSGlueException2 instanceof AlreadyExistsException || aWSGlueException2 instanceof EntityNotFoundException || aWSGlueException2 instanceof InvalidInputException || aWSGlueException2 instanceof ResourceNumberLimitExceededException)) {
                            n = 4;
                            continue block5;
                        }
                        this.fileIo.deleteFile(newMetadataLocation);
                        break block5;
                    }
                }
                break;
            }
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_COMMIT_ERROR, "Cannot commit table creation", (Throwable)e);
        }
        this.shouldRefresh = true;
    }

    @Override
    protected void commitToExistingTable(TableMetadata base, TableMetadata metadata) {
        this.commitTableUpdate(this.getTable(this.database, this.tableName, false), metadata, (table, newMetadataLocation) -> GlueIcebergUtil.getTableInput(this.typeManager, this.tableName, this.owner, metadata, GlueToTrinoConverter.getStorageDescriptor((Table)table).map(StorageDescriptor::getLocation).orElse(null), newMetadataLocation, (Map<String, String>)ImmutableMap.of((Object)"previous_metadata_location", (Object)this.currentMetadataLocation), this.cacheTableMetadata));
    }

    @Override
    protected void commitMaterializedViewRefresh(TableMetadata base, TableMetadata metadata) {
        this.commitTableUpdate(this.getTable(this.database, IcebergTableName.tableNameFrom(this.tableName), false), metadata, (table, newMetadataLocation) -> {
            HashMap<String, String> parameters = new HashMap<String, String>(GlueToTrinoConverter.getTableParameters((Table)table));
            parameters.put("metadata_location", (String)newMetadataLocation);
            parameters.put("previous_metadata_location", this.currentMetadataLocation);
            return GlueIcebergUtil.getMaterializedViewTableInput(table.getName(), table.getViewOriginalText(), table.getOwner(), parameters);
        });
    }

    private void commitTableUpdate(Table table, TableMetadata metadata, BiFunction<Table, String, TableInput> tableUpdateFunction) {
        String newMetadataLocation = this.writeNewMetadata(metadata, this.version.orElseThrow() + 1);
        TableInput tableInput = tableUpdateFunction.apply(table, newMetadataLocation);
        UpdateTableRequest updateTableRequest = new UpdateTableRequest().withDatabaseName(this.database).withTableInput(tableInput).withVersionId(this.glueVersionId);
        try {
            this.stats.getUpdateTable().call(() -> this.glueClient.updateTable(updateTableRequest));
        }
        catch (ConcurrentModificationException e) {
            throw new CommitFailedException((Throwable)e, "Failed to commit to Glue table: %s.%s", new Object[]{this.database, this.tableName});
        }
        catch (EntityNotFoundException | InvalidInputException | ResourceNumberLimitExceededException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_COMMIT_ERROR, "Cannot commit table update", e);
        }
        catch (RuntimeException e) {
            throw new CommitStateUnknownException((Throwable)e);
        }
        this.shouldRefresh = true;
    }

    private Table getTable(String database, String tableName, boolean invalidateCaches) {
        return this.getGlueTable.get(new SchemaTableName(database, tableName), invalidateCaches);
    }

    public static interface GetGlueTable {
        public Table get(SchemaTableName var1, boolean var2);
    }
}

