/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog.glue;

import com.amazonaws.services.glue.model.Column;
import com.amazonaws.services.glue.model.StorageDescriptor;
import com.amazonaws.services.glue.model.TableInput;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.plugin.hive.TableType;
import io.trino.plugin.iceberg.TypeConverter;
import io.trino.spi.type.TypeManager;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

public final class GlueIcebergUtil {
    private static final int GLUE_TABLE_PARAMETER_LENGTH_LIMIT = 512000;
    private static final int GLUE_COLUMN_NAME_LENGTH_LIMIT = 255;
    private static final int GLUE_COLUMN_TYPE_LENGTH_LIMIT = 131072;
    private static final int GLUE_COLUMN_COMMENT_LENGTH_LIMIT = 255;
    private static final int GLUE_COLUMN_PARAMETER_LENGTH_LIMIT = 512000;

    private GlueIcebergUtil() {
    }

    public static TableInput getTableInput(TypeManager typeManager, String tableName, Optional<String> owner, TableMetadata metadata, @Nullable String tableLocation, String newMetadataLocation, Map<String, String> parameters, boolean cacheTableMetadata) {
        parameters = new HashMap<String, String>(parameters);
        parameters.putIfAbsent("table_type", "iceberg".toUpperCase(Locale.ENGLISH));
        parameters.put("metadata_location", newMetadataLocation);
        parameters.remove("trino_table_metadata_info_valid_for");
        StorageDescriptor storageDescriptor = new StorageDescriptor().withLocation(tableLocation);
        TableInput tableInput = new TableInput().withName(tableName).withOwner((String)owner.orElse(null)).withTableType(TableType.EXTERNAL_TABLE.name()).withStorageDescriptor(storageDescriptor);
        if (cacheTableMetadata) {
            Optional<List<Column>> glueColumns = GlueIcebergUtil.glueColumns(typeManager, metadata);
            glueColumns.ifPresent(columns -> tableInput.withStorageDescriptor(storageDescriptor.withColumns((Collection)columns)));
            String comment = (String)metadata.properties().get("comment");
            if (comment != null) {
                if (comment.length() <= 512000) {
                    parameters.put("comment", comment);
                    parameters.remove("trino_table_comment_cache_prevented");
                } else {
                    parameters.remove("comment");
                    parameters.put("trino_table_comment_cache_prevented", "true");
                }
            } else {
                parameters.remove("comment");
                parameters.remove("trino_table_comment_cache_prevented");
            }
            parameters.put("trino_table_metadata_info_valid_for", newMetadataLocation);
        }
        tableInput.withParameters(parameters);
        return tableInput;
    }

    private static Optional<List<Column>> glueColumns(TypeManager typeManager, TableMetadata metadata) {
        List icebergColumns = metadata.schema().columns();
        ImmutableList.Builder glueColumns = ImmutableList.builderWithExpectedSize((int)icebergColumns.size());
        boolean firstColumn = true;
        for (Types.NestedField icebergColumn : icebergColumns) {
            String glueTypeString = GlueIcebergUtil.toGlueTypeStringLossy(icebergColumn.type());
            if (icebergColumn.name().length() > 255 || ((String)MoreObjects.firstNonNull((Object)icebergColumn.doc(), (Object)"")).length() > 255 || glueTypeString.length() > 131072) {
                return Optional.empty();
            }
            String trinoTypeId = TypeConverter.toTrinoType(icebergColumn.type(), typeManager).getTypeId().getId();
            Column column = new Column().withName(icebergColumn.name()).withType(glueTypeString).withComment(icebergColumn.doc());
            ImmutableMap.Builder parameters = ImmutableMap.builder();
            if (icebergColumn.isRequired()) {
                parameters.put((Object)"trino_not_null", (Object)"true");
            }
            if (firstColumn || !glueTypeString.equals(trinoTypeId)) {
                if (trinoTypeId.length() > 512000) {
                    return Optional.empty();
                }
                parameters.put((Object)"trino_type_id", (Object)trinoTypeId);
            }
            column.setParameters((Map)parameters.buildOrThrow());
            glueColumns.add((Object)column);
            firstColumn = false;
        }
        return Optional.of(glueColumns.build());
    }

    private static String toGlueTypeStringLossy(Type type) {
        switch (type.typeId()) {
            case BOOLEAN: {
                return "boolean";
            }
            case INTEGER: {
                return "int";
            }
            case LONG: {
                return "bigint";
            }
            case FLOAT: {
                return "float";
            }
            case DOUBLE: {
                return "double";
            }
            case DATE: {
                return "date";
            }
            case TIME: 
            case STRING: 
            case UUID: {
                return "string";
            }
            case TIMESTAMP: {
                return "timestamp";
            }
            case FIXED: 
            case BINARY: {
                return "binary";
            }
            case DECIMAL: {
                Types.DecimalType decimalType = (Types.DecimalType)type;
                return String.format("decimal(%s,%s)", decimalType.precision(), decimalType.scale());
            }
            case STRUCT: {
                Types.StructType structType = type.asStructType();
                String nameToType = structType.fields().stream().map(f -> String.format("%s:%s", f.name(), GlueIcebergUtil.toGlueTypeStringLossy(f.type()))).collect(Collectors.joining(","));
                return String.format("struct<%s>", nameToType);
            }
            case LIST: {
                Types.ListType listType = type.asListType();
                return String.format("array<%s>", GlueIcebergUtil.toGlueTypeStringLossy(listType.elementType()));
            }
            case MAP: {
                Types.MapType mapType = type.asMapType();
                return String.format("map<%s,%s>", GlueIcebergUtil.toGlueTypeStringLossy(mapType.keyType()), GlueIcebergUtil.toGlueTypeStringLossy(mapType.valueType()));
            }
        }
        return type.typeId().name().toLowerCase(Locale.ENGLISH);
    }

    public static TableInput getViewTableInput(String viewName, String viewOriginalText, @Nullable String owner, Map<String, String> parameters) {
        return new TableInput().withName(viewName).withTableType(TableType.VIRTUAL_VIEW.name()).withViewOriginalText(viewOriginalText).withViewExpandedText("/* Presto View */").withOwner(owner).withParameters(parameters);
    }

    public static TableInput getMaterializedViewTableInput(String viewName, String viewOriginalText, String owner, Map<String, String> parameters) {
        return new TableInput().withName(viewName).withTableType(TableType.VIRTUAL_VIEW.name()).withViewOriginalText(viewOriginalText).withViewExpandedText("Presto Materialized View").withOwner(owner).withParameters(parameters);
    }
}

