/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog.glue;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.glue.model.Table;
import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.multibindings.OptionalBinder;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConfigBinder;
import io.trino.plugin.hive.HideDeltaLakeTables;
import io.trino.plugin.hive.metastore.glue.GlueMetastoreStats;
import io.trino.plugin.hive.metastore.glue.v1.ForGlueHiveMetastore;
import io.trino.plugin.hive.metastore.glue.v1.GlueCredentialsProvider;
import io.trino.plugin.hive.metastore.glue.v1.GlueHiveMetastoreConfig;
import io.trino.plugin.hive.metastore.glue.v1.GlueMetastoreModule;
import io.trino.plugin.iceberg.catalog.IcebergTableOperationsProvider;
import io.trino.plugin.iceberg.catalog.TrinoCatalogFactory;
import io.trino.plugin.iceberg.catalog.glue.GlueIcebergTableOperationsProvider;
import io.trino.plugin.iceberg.catalog.glue.IcebergGlueCatalogConfig;
import io.trino.plugin.iceberg.catalog.glue.TrinoGlueCatalogFactory;
import io.trino.plugin.iceberg.procedure.MigrateProcedure;
import io.trino.spi.procedure.Procedure;
import java.util.function.Predicate;
import org.weakref.jmx.guice.ExportBinder;

public class IcebergGlueCatalogModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        ConfigBinder.configBinder((Binder)binder).bindConfig(GlueHiveMetastoreConfig.class);
        ConfigBinder.configBinder((Binder)binder).bindConfigDefaults(GlueHiveMetastoreConfig.class, config -> config.setSkipArchive(true));
        ConfigBinder.configBinder((Binder)binder).bindConfig(IcebergGlueCatalogConfig.class);
        binder.bind(GlueMetastoreStats.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(GlueMetastoreStats.class).withGeneratedName();
        binder.bind(AWSCredentialsProvider.class).toProvider(GlueCredentialsProvider.class).in(Scopes.SINGLETON);
        binder.bind(IcebergTableOperationsProvider.class).to(GlueIcebergTableOperationsProvider.class).in(Scopes.SINGLETON);
        binder.bind(TrinoCatalogFactory.class).to(TrinoGlueCatalogFactory.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(TrinoCatalogFactory.class).withGeneratedName();
        binder.bind(Key.get(Boolean.TYPE, HideDeltaLakeTables.class)).toInstance((Object)false);
        OptionalBinder.newOptionalBinder((Binder)binder, (Key)Key.get((TypeLiteral)new TypeLiteral<Predicate<Table>>(this){}, ForGlueHiveMetastore.class)).setBinding().toInstance(table -> true);
        this.install((Module)new GlueMetastoreModule());
        Multibinder procedures = Multibinder.newSetBinder((Binder)binder, Procedure.class);
        procedures.addBinding().toProvider(MigrateProcedure.class).in(Scopes.SINGLETON);
    }
}

