/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog.hms;

import com.google.common.base.Preconditions;
import io.airlift.log.Logger;
import io.trino.annotation.NotThreadSafe;
import io.trino.hive.thrift.metastore.Table;
import io.trino.metastore.AcidTransactionOwner;
import io.trino.metastore.PrincipalPrivileges;
import io.trino.metastore.Table;
import io.trino.metastore.cache.CachingHiveMetastore;
import io.trino.plugin.hive.metastore.MetastoreUtil;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastore;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreUtil;
import io.trino.plugin.iceberg.IcebergTableName;
import io.trino.plugin.iceberg.IcebergUtil;
import io.trino.plugin.iceberg.catalog.hms.AbstractMetastoreTableOperations;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.TableNotFoundException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.exceptions.CommitStateUnknownException;
import org.apache.iceberg.io.FileIO;

@NotThreadSafe
public class HiveMetastoreTableOperations
extends AbstractMetastoreTableOperations {
    private static final Logger log = Logger.get(HiveMetastoreTableOperations.class);
    private final ThriftMetastore thriftMetastore;

    public HiveMetastoreTableOperations(FileIO fileIo, CachingHiveMetastore metastore, ThriftMetastore thriftMetastore, ConnectorSession session, String database, String table, Optional<String> owner, Optional<String> location) {
        super(fileIo, metastore, session, database, table, owner, location);
        this.thriftMetastore = Objects.requireNonNull(thriftMetastore, "thriftMetastore is null");
    }

    @Override
    protected void commitToExistingTable(TableMetadata base, TableMetadata metadata) {
        io.trino.metastore.Table currentTable = this.getTable();
        this.commitTableUpdate(currentTable, metadata, (table, newMetadataLocation) -> io.trino.metastore.Table.builder((io.trino.metastore.Table)table).apply(builder -> this.updateMetastoreTable((Table.Builder)builder, metadata, (String)newMetadataLocation, Optional.of(this.currentMetadataLocation))).build());
    }

    @Override
    protected final void commitMaterializedViewRefresh(TableMetadata base, TableMetadata metadata) {
        io.trino.metastore.Table materializedView = this.getTable(this.database, IcebergTableName.tableNameFrom(this.tableName));
        this.commitTableUpdate(materializedView, metadata, (table, newMetadataLocation) -> io.trino.metastore.Table.builder((io.trino.metastore.Table)table).apply(builder -> builder.setParameter("metadata_location", newMetadataLocation).setParameter("previous_metadata_location", this.currentMetadataLocation)).build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitTableUpdate(io.trino.metastore.Table table, TableMetadata metadata, BiFunction<io.trino.metastore.Table, String, io.trino.metastore.Table> tableUpdateFunction) {
        String newMetadataLocation = this.writeNewMetadata(metadata, this.version.orElseThrow() + 1);
        long lockId = this.thriftMetastore.acquireTableExclusiveLock(new AcidTransactionOwner(this.session.getUser()), this.session.getQueryId(), table.getDatabaseName(), table.getTableName());
        try {
            io.trino.metastore.Table currentTable = ThriftMetastoreUtil.fromMetastoreApiTable((Table)((Table)this.thriftMetastore.getTable(this.database, table.getTableName()).orElseThrow(() -> new TableNotFoundException(this.getSchemaTableName()))));
            Preconditions.checkState((this.currentMetadataLocation != null ? 1 : 0) != 0, (Object)"No current metadata location for existing table");
            String metadataLocation = IcebergUtil.fixBrokenMetadataLocation((String)currentTable.getParameters().get("metadata_location"));
            if (!this.currentMetadataLocation.equals(metadataLocation)) {
                throw new CommitFailedException("Metadata location [%s] is not same as table metadata location [%s] for %s", new Object[]{this.currentMetadataLocation, metadataLocation, this.getSchemaTableName()});
            }
            io.trino.metastore.Table updatedTable = tableUpdateFunction.apply(table, newMetadataLocation);
            PrincipalPrivileges privileges = table.getOwner().map(MetastoreUtil::buildInitialPrivilegeSet).orElse(PrincipalPrivileges.NO_PRIVILEGES);
            try {
                this.metastore.replaceTable(table.getDatabaseName(), table.getTableName(), updatedTable, privileges);
            }
            catch (RuntimeException e) {
                throw new CommitStateUnknownException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            try {
                this.thriftMetastore.releaseTableLock(lockId);
            }
            catch (RuntimeException e) {
                log.error((Throwable)e, "Failed to release lock %s when committing to table %s", new Object[]{lockId, table.getTableName()});
            }
            throw throwable;
        }
        try {
            this.thriftMetastore.releaseTableLock(lockId);
        }
        catch (RuntimeException e) {
            log.error((Throwable)e, "Failed to release lock %s when committing to table %s", new Object[]{lockId, table.getTableName()});
        }
        this.shouldRefresh = true;
    }
}

