/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog.hms;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.base.Verify;
import com.google.common.cache.Cache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.UncheckedExecutionException;
import io.airlift.log.Logger;
import io.trino.cache.CacheUtils;
import io.trino.cache.EvictableCacheBuilder;
import io.trino.filesystem.Location;
import io.trino.filesystem.Locations;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.metastore.Column;
import io.trino.metastore.Database;
import io.trino.metastore.HivePrincipal;
import io.trino.metastore.HiveType;
import io.trino.metastore.PrincipalPrivileges;
import io.trino.metastore.StorageFormat;
import io.trino.metastore.Table;
import io.trino.metastore.TableInfo;
import io.trino.metastore.cache.CachingHiveMetastore;
import io.trino.plugin.base.util.ExecutorUtil;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.HiveSchemaProperties;
import io.trino.plugin.hive.TrinoViewHiveMetastore;
import io.trino.plugin.hive.ViewReaderUtil;
import io.trino.plugin.hive.metastore.MetastoreUtil;
import io.trino.plugin.hive.util.HiveUtil;
import io.trino.plugin.iceberg.IcebergErrorCode;
import io.trino.plugin.iceberg.IcebergMaterializedViewDefinition;
import io.trino.plugin.iceberg.IcebergTableName;
import io.trino.plugin.iceberg.IcebergUtil;
import io.trino.plugin.iceberg.TableType;
import io.trino.plugin.iceberg.TrinoMetricsReporter;
import io.trino.plugin.iceberg.UnknownTableTypeException;
import io.trino.plugin.iceberg.catalog.AbstractIcebergTableOperations;
import io.trino.plugin.iceberg.catalog.AbstractTrinoCatalog;
import io.trino.plugin.iceberg.catalog.IcebergTableOperations;
import io.trino.plugin.iceberg.catalog.IcebergTableOperationsProvider;
import io.trino.plugin.iceberg.fileio.ForwardingFileIo;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.catalog.CatalogName;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorMaterializedViewDefinition;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorViewDefinition;
import io.trino.spi.connector.MaterializedViewNotFoundException;
import io.trino.spi.connector.RelationColumnsMetadata;
import io.trino.spi.connector.RelationCommentMetadata;
import io.trino.spi.connector.SchemaNotFoundException;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.TableNotFoundException;
import io.trino.spi.connector.ViewNotFoundException;
import io.trino.spi.security.PrincipalType;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.spi.type.TypeManager;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.apache.iceberg.BaseTable;
import org.apache.iceberg.CatalogUtil;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableMetadataParser;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.Transaction;
import org.apache.iceberg.exceptions.NotFoundException;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.metrics.MetricsReporter;

public class TrinoHiveCatalog
extends AbstractTrinoCatalog {
    private static final Logger log = Logger.get(TrinoHiveCatalog.class);
    private static final int PER_QUERY_CACHE_SIZE = 1000;
    public static final String DEPENDS_ON_TABLES = "dependsOnTables";
    public static final String DEPENDS_ON_TABLE_FUNCTIONS = "dependsOnTableFunctions";
    public static final String TRINO_QUERY_START_TIME = "trino-query-start-time";
    private final CachingHiveMetastore metastore;
    private final TrinoViewHiveMetastore trinoViewHiveMetastore;
    private final TrinoFileSystemFactory fileSystemFactory;
    private final boolean isUsingSystemSecurity;
    private final boolean deleteSchemaLocationsFallback;
    private final boolean hideMaterializedViewStorageTable;
    private final Executor metadataFetchingExecutor;
    private final Cache<SchemaTableName, TableMetadata> tableMetadataCache = EvictableCacheBuilder.newBuilder().maximumSize(1000L).build();

    public TrinoHiveCatalog(CatalogName catalogName, CachingHiveMetastore metastore, TrinoViewHiveMetastore trinoViewHiveMetastore, TrinoFileSystemFactory fileSystemFactory, TypeManager typeManager, IcebergTableOperationsProvider tableOperationsProvider, boolean useUniqueTableLocation, boolean isUsingSystemSecurity, boolean deleteSchemaLocationsFallback, boolean hideMaterializedViewStorageTable, Executor metadataFetchingExecutor) {
        super(catalogName, typeManager, tableOperationsProvider, fileSystemFactory, useUniqueTableLocation);
        this.metastore = Objects.requireNonNull(metastore, "metastore is null");
        this.trinoViewHiveMetastore = Objects.requireNonNull(trinoViewHiveMetastore, "trinoViewHiveMetastore is null");
        this.fileSystemFactory = Objects.requireNonNull(fileSystemFactory, "fileSystemFactory is null");
        this.isUsingSystemSecurity = isUsingSystemSecurity;
        this.deleteSchemaLocationsFallback = deleteSchemaLocationsFallback;
        this.hideMaterializedViewStorageTable = hideMaterializedViewStorageTable;
        this.metadataFetchingExecutor = Objects.requireNonNull(metadataFetchingExecutor, "metadataFetchingExecutor is null");
    }

    public CachingHiveMetastore getMetastore() {
        return this.metastore;
    }

    @Override
    public boolean namespaceExists(ConnectorSession session, String namespace) {
        if (!namespace.equals(namespace.toLowerCase(Locale.ENGLISH))) {
            return false;
        }
        if (HiveUtil.isHiveSystemSchema((String)namespace)) {
            return false;
        }
        return this.metastore.getDatabase(namespace).isPresent();
    }

    @Override
    public List<String> listNamespaces(ConnectorSession session) {
        return this.metastore.getAllDatabases().stream().filter(schemaName -> !HiveUtil.isHiveSystemSchema((String)schemaName)).collect(Collectors.toList());
    }

    @Override
    public Map<String, Object> loadNamespaceMetadata(ConnectorSession session, String namespace) {
        Optional db = this.metastore.getDatabase(namespace);
        if (db.isPresent()) {
            return HiveSchemaProperties.fromDatabase((Database)((Database)db.get()));
        }
        throw new SchemaNotFoundException(namespace);
    }

    @Override
    public Optional<TrinoPrincipal> getNamespacePrincipal(ConnectorSession session, String namespace) {
        Optional database = this.metastore.getDatabase(namespace);
        if (database.isPresent()) {
            return database.flatMap(db -> db.getOwnerName().map(ownerName -> new TrinoPrincipal((PrincipalType)db.getOwnerType().orElseThrow(), ownerName)));
        }
        throw new SchemaNotFoundException(namespace);
    }

    @Override
    public void createNamespace(ConnectorSession session, String namespace, Map<String, Object> properties, TrinoPrincipal owner) {
        Database.Builder database = Database.builder().setDatabaseName(namespace).setOwnerType(this.isUsingSystemSecurity ? Optional.empty() : Optional.of(owner.getType())).setOwnerName(this.isUsingSystemSecurity ? Optional.empty() : Optional.of(owner.getName()));
        properties.forEach((property, value) -> {
            switch (property) {
                case "location": {
                    String location = (String)value;
                    try {
                        this.fileSystemFactory.create(session).directoryExists(Location.of((String)location));
                    }
                    catch (IOException | IllegalArgumentException e) {
                        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SCHEMA_PROPERTY, "Invalid location URI: " + location, (Throwable)e);
                    }
                    database.setLocation(Optional.of(location));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized property: " + property);
                }
            }
        });
        this.metastore.createDatabase(database.build());
    }

    @Override
    public void dropNamespace(ConnectorSession session, String namespace) {
        if (!this.listTables(session, Optional.of(namespace)).isEmpty()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.SCHEMA_NOT_EMPTY, "Schema not empty: " + namespace);
        }
        Optional location = ((Database)this.metastore.getDatabase(namespace).orElseThrow(() -> new SchemaNotFoundException(namespace))).getLocation();
        boolean deleteData = location.map(path -> {
            try {
                return !this.fileSystemFactory.create(session).listFiles(Location.of((String)path)).hasNext();
            }
            catch (IOException | RuntimeException e) {
                log.warn((Throwable)e, "Could not check schema directory '%s'", new Object[]{path});
                return this.deleteSchemaLocationsFallback;
            }
        }).orElse(this.deleteSchemaLocationsFallback);
        this.metastore.dropDatabase(namespace, deleteData);
    }

    @Override
    public void renameNamespace(ConnectorSession session, String source, String target) {
        this.metastore.renameDatabase(source, target);
    }

    @Override
    public void setNamespacePrincipal(ConnectorSession session, String namespace, TrinoPrincipal principal) {
        this.metastore.setDatabaseOwner(namespace, HivePrincipal.from((TrinoPrincipal)principal));
    }

    @Override
    public Transaction newCreateTableTransaction(ConnectorSession session, SchemaTableName schemaTableName, Schema schema, PartitionSpec partitionSpec, SortOrder sortOrder, String location, Map<String, String> properties) {
        return this.newCreateTableTransaction(session, schemaTableName, schema, partitionSpec, sortOrder, location, properties, this.isUsingSystemSecurity ? Optional.empty() : Optional.of(session.getUser()));
    }

    @Override
    public Transaction newCreateOrReplaceTableTransaction(ConnectorSession session, SchemaTableName schemaTableName, Schema schema, PartitionSpec partitionSpec, SortOrder sortOrder, String location, Map<String, String> properties) {
        return this.newCreateOrReplaceTableTransaction(session, schemaTableName, schema, partitionSpec, sortOrder, location, properties, this.isUsingSystemSecurity ? Optional.empty() : Optional.of(session.getUser()));
    }

    @Override
    public void registerTable(ConnectorSession session, SchemaTableName schemaTableName, TableMetadata tableMetadata) throws TrinoException {
        Optional<String> owner = this.isUsingSystemSecurity ? Optional.empty() : Optional.of(session.getUser());
        Table.Builder builder = io.trino.metastore.Table.builder().setDatabaseName(schemaTableName.getSchemaName()).setTableName(schemaTableName.getTableName()).setOwner(owner).setDataColumns(AbstractIcebergTableOperations.toHiveColumns(tableMetadata.schema().columns())).setTableType(io.trino.plugin.hive.TableType.EXTERNAL_TABLE.name()).withStorage(storage -> storage.setLocation(tableMetadata.location())).withStorage(storage -> storage.setStorageFormat(AbstractIcebergTableOperations.ICEBERG_METASTORE_STORAGE_FORMAT)).setParameter("EXTERNAL", "TRUE").setParameter("trino_query_id", session.getQueryId()).setParameter("table_type", "iceberg".toUpperCase(Locale.ENGLISH)).setParameter("metadata_location", tableMetadata.metadataFileLocation());
        PrincipalPrivileges privileges = owner.map(MetastoreUtil::buildInitialPrivilegeSet).orElse(PrincipalPrivileges.NO_PRIVILEGES);
        this.metastore.createTable(builder.build(), privileges);
    }

    @Override
    public void unregisterTable(ConnectorSession session, SchemaTableName schemaTableName) {
        this.dropTableFromMetastore(schemaTableName);
        this.invalidateTableCache(schemaTableName);
    }

    @Override
    public List<TableInfo> listTables(ConnectorSession session, Optional<String> namespace) {
        List tasks = (List)this.listNamespaces(session, namespace).stream().map(schema -> () -> this.metastore.getTables(schema)).collect(ImmutableList.toImmutableList());
        try {
            return (List)ExecutorUtil.processWithAdditionalThreads((Collection)tasks, (Executor)this.metadataFetchingExecutor).stream().flatMap(Collection::stream).collect(ImmutableList.toImmutableList());
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e.getCause());
        }
    }

    @Override
    public List<SchemaTableName> listIcebergTables(ConnectorSession session, Optional<String> namespace) {
        List tasks = (List)this.listNamespaces(session, namespace).stream().map(schema -> () -> (List)this.metastore.getTableNamesWithParameters(schema, "table_type", ImmutableSet.of((Object)"iceberg".toLowerCase(Locale.ENGLISH), (Object)"iceberg".toUpperCase(Locale.ENGLISH))).stream().map(tableName -> new SchemaTableName(schema, tableName)).collect(ImmutableList.toImmutableList())).collect(ImmutableList.toImmutableList());
        try {
            return (List)ExecutorUtil.processWithAdditionalThreads((Collection)tasks, (Executor)this.metadataFetchingExecutor).stream().flatMap(Collection::stream).collect(ImmutableList.toImmutableList());
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e.getCause());
        }
    }

    @Override
    public Optional<Iterator<RelationColumnsMetadata>> streamRelationColumns(ConnectorSession session, Optional<String> namespace, UnaryOperator<Set<SchemaTableName>> relationFilter, Predicate<SchemaTableName> isRedirected) {
        return Optional.empty();
    }

    @Override
    public Optional<Iterator<RelationCommentMetadata>> streamRelationComments(ConnectorSession session, Optional<String> namespace, UnaryOperator<Set<SchemaTableName>> relationFilter, Predicate<SchemaTableName> isRedirected) {
        return Optional.empty();
    }

    @Override
    public void dropTable(ConnectorSession session, SchemaTableName schemaTableName) {
        BaseTable table = (BaseTable)this.loadTable(session, schemaTableName);
        TableMetadata metadata = table.operations().current();
        io.trino.metastore.Table metastoreTable = (io.trino.metastore.Table)this.metastore.getTable(schemaTableName.getSchemaName(), schemaTableName.getTableName()).orElseThrow(() -> new TableNotFoundException(schemaTableName));
        this.metastore.dropTable(schemaTableName.getSchemaName(), schemaTableName.getTableName(), false);
        try {
            CatalogUtil.dropTableData((FileIO)table.io(), (TableMetadata)metadata);
        }
        catch (RuntimeException e) {
            log.warn((Throwable)e, "Failed to delete table data referenced by metadata");
        }
        this.deleteTableDirectory(this.fileSystemFactory.create(session), schemaTableName, metastoreTable.getStorage().getLocation());
        this.invalidateTableCache(schemaTableName);
    }

    @Override
    public void dropCorruptedTable(ConnectorSession session, SchemaTableName schemaTableName) {
        io.trino.metastore.Table table = this.dropTableFromMetastore(schemaTableName);
        this.deleteTableDirectory(this.fileSystemFactory.create(session), schemaTableName, table.getStorage().getLocation());
        this.invalidateTableCache(schemaTableName);
    }

    private io.trino.metastore.Table dropTableFromMetastore(SchemaTableName schemaTableName) {
        io.trino.metastore.Table table = (io.trino.metastore.Table)this.metastore.getTable(schemaTableName.getSchemaName(), schemaTableName.getTableName()).orElseThrow(() -> new TableNotFoundException(schemaTableName));
        if (!HiveUtil.isIcebergTable((io.trino.metastore.Table)table)) {
            throw new UnknownTableTypeException(schemaTableName);
        }
        this.metastore.dropTable(schemaTableName.getSchemaName(), schemaTableName.getTableName(), false);
        return table;
    }

    @Override
    public void renameTable(ConnectorSession session, SchemaTableName from, SchemaTableName to) {
        this.metastore.renameTable(from.getSchemaName(), from.getTableName(), to.getSchemaName(), to.getTableName());
        this.invalidateTableCache(from);
    }

    @Override
    public Table loadTable(ConnectorSession session, SchemaTableName schemaTableName) {
        TableMetadata metadata;
        try {
            metadata = (TableMetadata)CacheUtils.uncheckedCacheGet(this.tableMetadataCache, (Object)schemaTableName, () -> ((BaseTable)IcebergUtil.loadIcebergTable(this, this.tableOperationsProvider, session, schemaTableName)).operations().current());
        }
        catch (UncheckedExecutionException e) {
            Throwables.throwIfUnchecked((Throwable)e.getCause());
            throw e;
        }
        return IcebergUtil.getIcebergTableWithMetadata(this, this.tableOperationsProvider, session, schemaTableName, metadata);
    }

    @Override
    public Map<SchemaTableName, List<ColumnMetadata>> tryGetColumnMetadata(ConnectorSession session, List<SchemaTableName> tables) {
        return ImmutableMap.of();
    }

    @Override
    public void updateViewComment(ConnectorSession session, SchemaTableName viewName, Optional<String> comment) {
        this.trinoViewHiveMetastore.updateViewComment(session, viewName, comment);
    }

    @Override
    public void updateViewColumnComment(ConnectorSession session, SchemaTableName viewName, String columnName, Optional<String> comment) {
        this.trinoViewHiveMetastore.updateViewColumnComment(session, viewName, columnName, comment);
    }

    @Override
    public String defaultTableLocation(ConnectorSession session, SchemaTableName schemaTableName) {
        Database database = (Database)this.metastore.getDatabase(schemaTableName.getSchemaName()).orElseThrow(() -> new SchemaNotFoundException(schemaTableName.getSchemaName()));
        String tableNameForLocation = this.createNewTableName(schemaTableName.getTableName());
        String location = (String)database.getLocation().orElseThrow(() -> new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_DATABASE_LOCATION_ERROR, String.format("Database '%s' location is not set", schemaTableName.getSchemaName())));
        return Locations.appendPath((String)location, (String)tableNameForLocation);
    }

    @Override
    public void setTablePrincipal(ConnectorSession session, SchemaTableName schemaTableName, TrinoPrincipal principal) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support setting an owner on a table");
    }

    @Override
    public void createView(ConnectorSession session, SchemaTableName schemaViewName, ConnectorViewDefinition definition, boolean replace) {
        this.trinoViewHiveMetastore.createView(session, schemaViewName, definition, replace);
    }

    @Override
    public void renameView(ConnectorSession session, SchemaTableName source, SchemaTableName target) {
        this.metastore.renameTable(source.getSchemaName(), source.getTableName(), target.getSchemaName(), target.getTableName());
    }

    @Override
    public void setViewPrincipal(ConnectorSession session, SchemaTableName schemaViewName, TrinoPrincipal principal) {
        this.setTablePrincipal(session, schemaViewName, principal);
    }

    @Override
    public void dropView(ConnectorSession session, SchemaTableName schemaViewName) {
        this.trinoViewHiveMetastore.dropView(schemaViewName);
    }

    @Override
    public Optional<ConnectorViewDefinition> getView(ConnectorSession session, SchemaTableName viewName) {
        return this.trinoViewHiveMetastore.getView(viewName);
    }

    @Override
    public void createMaterializedView(ConnectorSession session, SchemaTableName viewName, ConnectorMaterializedViewDefinition definition, Map<String, Object> materializedViewProperties, boolean replace, boolean ignoreExisting) {
        Optional existing = this.metastore.getTable(viewName.getSchemaName(), viewName.getTableName());
        if (existing.isPresent()) {
            if (!ViewReaderUtil.isTrinoMaterializedView((String)((io.trino.metastore.Table)existing.get()).getTableType(), (Map)((io.trino.metastore.Table)existing.get()).getParameters())) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.UNSUPPORTED_TABLE_TYPE, "Existing table is not a Materialized View: " + String.valueOf(viewName));
            }
            if (!replace) {
                if (ignoreExisting) {
                    return;
                }
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, "Materialized view already exists: " + String.valueOf(viewName));
            }
        }
        if (this.hideMaterializedViewStorageTable) {
            Location storageMetadataLocation = this.createMaterializedViewStorage(session, viewName, definition, materializedViewProperties);
            Map<String, String> viewProperties = this.createMaterializedViewProperties(session, storageMetadataLocation);
            Column dummyColumn = new Column("dummy", HiveType.HIVE_STRING, Optional.empty(), (Map)ImmutableMap.of());
            Table.Builder tableBuilder = io.trino.metastore.Table.builder().setDatabaseName(viewName.getSchemaName()).setTableName(viewName.getTableName()).setOwner(this.isUsingSystemSecurity ? Optional.empty() : Optional.of(session.getUser())).setTableType(io.trino.plugin.hive.TableType.VIRTUAL_VIEW.name()).setDataColumns((List)ImmutableList.of((Object)dummyColumn)).setPartitionColumns((List)ImmutableList.of()).setParameters(viewProperties).withStorage(storage -> storage.setStorageFormat(StorageFormat.VIEW_STORAGE_FORMAT)).withStorage(storage -> storage.setLocation("")).setViewOriginalText(Optional.of(IcebergMaterializedViewDefinition.encodeMaterializedViewData(IcebergMaterializedViewDefinition.fromConnectorMaterializedViewDefinition(definition)))).setViewExpandedText(Optional.of("/* Presto Materialized View */"));
            io.trino.metastore.Table table = tableBuilder.build();
            PrincipalPrivileges principalPrivileges = this.isUsingSystemSecurity ? PrincipalPrivileges.NO_PRIVILEGES : MetastoreUtil.buildInitialPrivilegeSet((String)session.getUser());
            try {
                if (existing.isPresent()) {
                    this.metastore.replaceTable(viewName.getSchemaName(), viewName.getTableName(), table, principalPrivileges);
                } else {
                    this.metastore.createTable(table, principalPrivileges);
                }
            }
            catch (RuntimeException e) {
                block12: {
                    try {
                        this.dropMaterializedViewStorage(this.fileSystemFactory.create(session), storageMetadataLocation.toString());
                    }
                    catch (Exception suppressed) {
                        log.warn((Throwable)suppressed, "Failed to clean up metadata '%s' for materialized view '%s'", new Object[]{storageMetadataLocation, viewName});
                        if (e == suppressed) break block12;
                        e.addSuppressed(suppressed);
                    }
                }
                throw e;
            }
            existing.ifPresent(existingView -> this.dropMaterializedViewStorage(session, (io.trino.metastore.Table)existingView));
        } else {
            this.createMaterializedViewWithStorageTable(session, viewName, definition, materializedViewProperties, existing);
        }
    }

    private void createMaterializedViewWithStorageTable(ConnectorSession session, SchemaTableName viewName, ConnectorMaterializedViewDefinition definition, Map<String, Object> materializedViewProperties, Optional<io.trino.metastore.Table> existing) {
        PrincipalPrivileges principalPrivileges;
        SchemaTableName storageTable = this.createMaterializedViewStorageTable(session, viewName, definition, materializedViewProperties);
        Map<String, String> viewProperties = this.createMaterializedViewProperties(session, storageTable);
        Column dummyColumn = new Column("dummy", HiveType.HIVE_STRING, Optional.empty(), Map.of());
        Table.Builder tableBuilder = io.trino.metastore.Table.builder().setDatabaseName(viewName.getSchemaName()).setTableName(viewName.getTableName()).setOwner(this.isUsingSystemSecurity ? Optional.empty() : Optional.of(session.getUser())).setTableType(io.trino.plugin.hive.TableType.VIRTUAL_VIEW.name()).setDataColumns((List)ImmutableList.of((Object)dummyColumn)).setPartitionColumns((List)ImmutableList.of()).setParameters(viewProperties).withStorage(storage -> storage.setStorageFormat(StorageFormat.VIEW_STORAGE_FORMAT)).withStorage(storage -> storage.setLocation("")).setViewOriginalText(Optional.of(IcebergMaterializedViewDefinition.encodeMaterializedViewData(IcebergMaterializedViewDefinition.fromConnectorMaterializedViewDefinition(definition)))).setViewExpandedText(Optional.of("/* Presto Materialized View */"));
        io.trino.metastore.Table table = tableBuilder.build();
        PrincipalPrivileges principalPrivileges2 = principalPrivileges = this.isUsingSystemSecurity ? PrincipalPrivileges.NO_PRIVILEGES : MetastoreUtil.buildInitialPrivilegeSet((String)session.getUser());
        if (existing.isPresent()) {
            String oldStorageTable = (String)existing.get().getParameters().get("storage_table");
            if (oldStorageTable != null) {
                String storageSchema = Optional.ofNullable((String)existing.get().getParameters().get("storage_schema")).orElse(viewName.getSchemaName());
                this.metastore.dropTable(storageSchema, oldStorageTable, true);
            }
            this.metastore.replaceTable(viewName.getSchemaName(), viewName.getTableName(), table, principalPrivileges);
            return;
        }
        this.metastore.createTable(table, principalPrivileges);
    }

    @Override
    public void updateMaterializedViewColumnComment(ConnectorSession session, SchemaTableName viewName, String columnName, Optional<String> comment) {
        io.trino.metastore.Table existing = (io.trino.metastore.Table)this.metastore.getTable(viewName.getSchemaName(), viewName.getTableName()).orElseThrow(() -> new ViewNotFoundException(viewName));
        if (!ViewReaderUtil.isTrinoMaterializedView((String)existing.getTableType(), (Map)existing.getParameters())) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.UNSUPPORTED_TABLE_TYPE, "Existing table is not a Materialized View: " + String.valueOf(viewName));
        }
        ConnectorMaterializedViewDefinition definition = this.doGetMaterializedView(session, viewName).orElseThrow(() -> new ViewNotFoundException(viewName));
        ConnectorMaterializedViewDefinition newDefinition = new ConnectorMaterializedViewDefinition(definition.getOriginalSql(), definition.getStorageTable(), definition.getCatalog(), definition.getSchema(), (List)definition.getColumns().stream().map(currentViewColumn -> Objects.equals(columnName, currentViewColumn.getName()) ? new ConnectorMaterializedViewDefinition.Column(currentViewColumn.getName(), currentViewColumn.getType(), comment) : currentViewColumn).collect(ImmutableList.toImmutableList()), definition.getGracePeriod(), definition.getComment(), definition.getOwner(), definition.getPath());
        this.replaceMaterializedView(session, viewName, existing, newDefinition);
    }

    private void replaceMaterializedView(ConnectorSession session, SchemaTableName viewName, io.trino.metastore.Table view, ConnectorMaterializedViewDefinition newDefinition) {
        Table.Builder viewBuilder = io.trino.metastore.Table.builder((io.trino.metastore.Table)view).setViewOriginalText(Optional.of(IcebergMaterializedViewDefinition.encodeMaterializedViewData(IcebergMaterializedViewDefinition.fromConnectorMaterializedViewDefinition(newDefinition))));
        PrincipalPrivileges principalPrivileges = this.isUsingSystemSecurity ? PrincipalPrivileges.NO_PRIVILEGES : MetastoreUtil.buildInitialPrivilegeSet((String)session.getUser());
        this.metastore.replaceTable(viewName.getSchemaName(), viewName.getTableName(), viewBuilder.build(), principalPrivileges);
    }

    @Override
    public void dropMaterializedView(ConnectorSession session, SchemaTableName viewName) {
        io.trino.metastore.Table view = (io.trino.metastore.Table)this.metastore.getTable(viewName.getSchemaName(), viewName.getTableName()).orElseThrow(() -> new MaterializedViewNotFoundException(viewName));
        if (!ViewReaderUtil.isTrinoMaterializedView((String)view.getTableType(), (Map)view.getParameters())) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.UNSUPPORTED_TABLE_TYPE, "Not a Materialized View: " + String.valueOf(viewName));
        }
        this.dropMaterializedViewStorage(session, view);
        this.metastore.dropTable(viewName.getSchemaName(), viewName.getTableName(), true);
    }

    private void dropMaterializedViewStorage(ConnectorSession session, io.trino.metastore.Table view) {
        SchemaTableName viewName = view.getSchemaTableName();
        String storageTableName = (String)view.getParameters().get("storage_table");
        if (storageTableName != null) {
            String storageSchema = Optional.ofNullable((String)view.getParameters().get("storage_schema")).orElse(viewName.getSchemaName());
            try {
                this.dropTable(session, new SchemaTableName(storageSchema, storageTableName));
            }
            catch (TrinoException e) {
                log.warn((Throwable)e, "Failed to drop storage table '%s.%s' for materialized view '%s'", new Object[]{storageSchema, storageTableName, viewName});
            }
        } else {
            String storageMetadataLocation = (String)view.getParameters().get("metadata_location");
            Preconditions.checkState((storageMetadataLocation != null ? 1 : 0) != 0, (Object)("Storage location missing in definition of materialized view " + String.valueOf(viewName)));
            try {
                this.dropMaterializedViewStorage(this.fileSystemFactory.create(session), storageMetadataLocation);
            }
            catch (IOException e) {
                log.warn((Throwable)e, "Failed to delete storage table metadata '%s' for materialized view '%s'", new Object[]{storageMetadataLocation, viewName});
            }
        }
    }

    @Override
    protected Optional<ConnectorMaterializedViewDefinition> doGetMaterializedView(ConnectorSession session, SchemaTableName viewName) {
        SchemaTableName storageTableName;
        String storageMetadataLocation;
        Optional tableOptional = this.metastore.getTable(viewName.getSchemaName(), viewName.getTableName());
        if (tableOptional.isEmpty()) {
            return Optional.empty();
        }
        io.trino.metastore.Table materializedView = (io.trino.metastore.Table)tableOptional.get();
        if (!ViewReaderUtil.isTrinoMaterializedView((String)materializedView.getTableType(), (Map)materializedView.getParameters())) {
            return Optional.empty();
        }
        String storageTable = (String)materializedView.getParameters().get("storage_table");
        if (storageTable == null == ((storageMetadataLocation = (String)materializedView.getParameters().get("metadata_location")) == null)) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_BAD_DATA, "Materialized view should have exactly one of the %s properties set: %s".formatted(ImmutableList.of((Object)"storage_table", (Object)"metadata_location"), materializedView.getParameters()));
        }
        if (storageTable != null) {
            String storageSchema = Optional.ofNullable((String)materializedView.getParameters().get("storage_schema")).orElse(viewName.getSchemaName());
            storageTableName = new SchemaTableName(storageSchema, storageTable);
        } else {
            storageTableName = new SchemaTableName(viewName.getSchemaName(), IcebergTableName.tableNameWithType(viewName.getTableName(), TableType.MATERIALIZED_VIEW_STORAGE));
        }
        return Optional.of(this.getMaterializedViewDefinition(materializedView.getOwner(), (String)materializedView.getViewOriginalText().orElseThrow(() -> new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, "No view original text: " + String.valueOf(viewName))), storageTableName));
    }

    @Override
    public Optional<BaseTable> getMaterializedViewStorageTable(ConnectorSession session, SchemaTableName viewName) {
        Optional tableOptional = this.metastore.getTable(viewName.getSchemaName(), viewName.getTableName());
        if (tableOptional.isEmpty()) {
            return Optional.empty();
        }
        io.trino.metastore.Table materializedView = (io.trino.metastore.Table)tableOptional.get();
        Verify.verify((boolean)ViewReaderUtil.isTrinoMaterializedView((String)materializedView.getTableType(), (Map)materializedView.getParameters()), (String)"getMaterializedViewStorageTable received a table, not a materialized view", (Object[])new Object[0]);
        SchemaTableName storageTableName = new SchemaTableName(viewName.getSchemaName(), IcebergTableName.tableNameWithType(viewName.getTableName(), TableType.MATERIALIZED_VIEW_STORAGE));
        IcebergTableOperations operations = this.tableOperationsProvider.createTableOperations(this, session, storageTableName.getSchemaName(), storageTableName.getTableName(), Optional.empty(), Optional.empty());
        try {
            TableMetadata metadata = this.getMaterializedViewTableMetadata(session, storageTableName, materializedView);
            operations.initializeFromMetadata(metadata);
            return Optional.of(new BaseTable((TableOperations)operations, IcebergUtil.quotedTableName(storageTableName), (MetricsReporter)TrinoMetricsReporter.TRINO_METRICS_REPORTER));
        }
        catch (UncheckedExecutionException e) {
            if (e.getCause() instanceof NotFoundException) {
                return Optional.empty();
            }
            throw e;
        }
    }

    private TableMetadata getMaterializedViewTableMetadata(ConnectorSession session, SchemaTableName storageTableName, io.trino.metastore.Table materializedView) {
        return (TableMetadata)CacheUtils.uncheckedCacheGet(this.tableMetadataCache, (Object)storageTableName, () -> {
            String storageMetadataLocation = (String)materializedView.getParameters().get("metadata_location");
            Preconditions.checkState((storageMetadataLocation != null ? 1 : 0) != 0, (Object)("Storage location missing in definition of materialized view " + materializedView.getTableName()));
            TrinoFileSystem fileSystem = this.fileSystemFactory.create(session);
            return TableMetadataParser.read((FileIO)new ForwardingFileIo(fileSystem), (String)storageMetadataLocation);
        });
    }

    @Override
    public void renameMaterializedView(ConnectorSession session, SchemaTableName source, SchemaTableName target) {
        this.metastore.renameTable(source.getSchemaName(), source.getTableName(), target.getSchemaName(), target.getTableName());
    }

    private List<String> listNamespaces(ConnectorSession session, Optional<String> namespace) {
        if (namespace.isPresent()) {
            if (HiveUtil.isHiveSystemSchema((String)namespace.get())) {
                return ImmutableList.of();
            }
            return ImmutableList.of((Object)namespace.get());
        }
        return this.listNamespaces(session);
    }

    @Override
    public Optional<CatalogSchemaTableName> redirectTable(ConnectorSession session, SchemaTableName tableName, String hiveCatalogName) {
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(tableName, "tableName is null");
        Objects.requireNonNull(hiveCatalogName, "hiveCatalogName is null");
        if (HiveUtil.isHiveSystemSchema((String)tableName.getSchemaName())) {
            return Optional.empty();
        }
        int metadataMarkerIndex = tableName.getTableName().lastIndexOf(36);
        SchemaTableName tableNameBase = metadataMarkerIndex == -1 ? tableName : SchemaTableName.schemaTableName((String)tableName.getSchemaName(), (String)tableName.getTableName().substring(0, metadataMarkerIndex));
        Optional table = this.metastore.getTable(tableNameBase.getSchemaName(), tableNameBase.getTableName());
        if (table.isEmpty() || ViewReaderUtil.isSomeKindOfAView((io.trino.metastore.Table)((io.trino.metastore.Table)table.get()))) {
            return Optional.empty();
        }
        if (!HiveUtil.isIcebergTable((io.trino.metastore.Table)((io.trino.metastore.Table)table.get()))) {
            return Optional.of(new CatalogSchemaTableName(hiveCatalogName, tableName));
        }
        return Optional.empty();
    }

    @Override
    protected void invalidateTableCache(SchemaTableName schemaTableName) {
        this.tableMetadataCache.invalidate((Object)schemaTableName);
    }
}

