/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog.jdbc;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.ConfigSecuritySensitive;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.util.Optional;

public class IcebergJdbcCatalogConfig {
    private String driverClass;
    private String connectionUrl;
    private String connectionUser;
    private String connectionPassword;
    private String catalogName;
    private String defaultWarehouseDir;
    private SchemaVersion schemaVersion = SchemaVersion.V1;
    private String retryableStatusCodes;

    @NotNull
    public String getDriverClass() {
        return this.driverClass;
    }

    @Config(value="iceberg.jdbc-catalog.driver-class")
    @ConfigDescription(value="JDBC driver class name")
    public IcebergJdbcCatalogConfig setDriverClass(String driverClass) {
        this.driverClass = driverClass;
        return this;
    }

    public String getConnectionUrl() {
        return this.connectionUrl;
    }

    @Config(value="iceberg.jdbc-catalog.connection-url")
    @ConfigDescription(value="The URI to connect to the JDBC server")
    @ConfigSecuritySensitive
    public IcebergJdbcCatalogConfig setConnectionUrl(String connectionUrl) {
        this.connectionUrl = connectionUrl;
        return this;
    }

    @NotNull
    public Optional<String> getConnectionUser() {
        return Optional.ofNullable(this.connectionUser);
    }

    @Config(value="iceberg.jdbc-catalog.connection-user")
    @ConfigDescription(value="User name for JDBC client")
    public IcebergJdbcCatalogConfig setConnectionUser(String connectionUser) {
        this.connectionUser = connectionUser;
        return this;
    }

    @NotNull
    public Optional<String> getConnectionPassword() {
        return Optional.ofNullable(this.connectionPassword);
    }

    @Config(value="iceberg.jdbc-catalog.connection-password")
    @ConfigDescription(value="Password for JDBC client")
    @ConfigSecuritySensitive
    public IcebergJdbcCatalogConfig setConnectionPassword(String connectionPassword) {
        this.connectionPassword = connectionPassword;
        return this;
    }

    @NotEmpty
    public String getCatalogName() {
        return this.catalogName;
    }

    @Config(value="iceberg.jdbc-catalog.catalog-name")
    @ConfigDescription(value="Iceberg JDBC metastore catalog name")
    public IcebergJdbcCatalogConfig setCatalogName(String catalogName) {
        this.catalogName = catalogName;
        return this;
    }

    @NotEmpty
    public String getDefaultWarehouseDir() {
        return this.defaultWarehouseDir;
    }

    @Config(value="iceberg.jdbc-catalog.default-warehouse-dir")
    @ConfigDescription(value="The default warehouse directory to use for JDBC")
    public IcebergJdbcCatalogConfig setDefaultWarehouseDir(String defaultWarehouseDir) {
        this.defaultWarehouseDir = defaultWarehouseDir;
        return this;
    }

    @NotNull
    public SchemaVersion getSchemaVersion() {
        return this.schemaVersion;
    }

    @Config(value="iceberg.jdbc-catalog.schema-version")
    @ConfigDescription(value="JDBC catalog schema version")
    public IcebergJdbcCatalogConfig setSchemaVersion(SchemaVersion schemaVersion) {
        this.schemaVersion = schemaVersion;
        return this;
    }

    @NotNull
    public Optional<String> getRetryableStatusCodes() {
        return Optional.ofNullable(this.retryableStatusCodes);
    }

    @Config(value="iceberg.jdbc-catalog.retryable-status-codes")
    @ConfigDescription(value="On connection error to JDBC metastore, retry if it is one of these JDBC status codes")
    public IcebergJdbcCatalogConfig setRetryableStatusCodes(String retryableStatusCodes) {
        this.retryableStatusCodes = retryableStatusCodes;
        return this;
    }

    public static enum SchemaVersion {
        V0,
        V1;

    }
}

