/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog.jdbc;

import com.google.inject.Binder;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConfigBinder;
import io.trino.plugin.iceberg.catalog.IcebergTableOperationsProvider;
import io.trino.plugin.iceberg.catalog.TrinoCatalogFactory;
import io.trino.plugin.iceberg.catalog.jdbc.IcebergJdbcCatalogConfig;
import io.trino.plugin.iceberg.catalog.jdbc.IcebergJdbcClient;
import io.trino.plugin.iceberg.catalog.jdbc.IcebergJdbcConnectionFactory;
import io.trino.plugin.iceberg.catalog.jdbc.IcebergJdbcTableOperationsProvider;
import io.trino.plugin.iceberg.catalog.jdbc.TrinoJdbcCatalogFactory;
import java.sql.Driver;
import java.util.Objects;
import org.weakref.jmx.guice.ExportBinder;

public class IcebergJdbcCatalogModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        ConfigBinder.configBinder((Binder)binder).bindConfig(IcebergJdbcCatalogConfig.class);
        binder.bind(IcebergTableOperationsProvider.class).to(IcebergJdbcTableOperationsProvider.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(IcebergTableOperationsProvider.class).withGeneratedName();
        binder.bind(TrinoCatalogFactory.class).to(TrinoJdbcCatalogFactory.class).in(Scopes.SINGLETON);
        binder.bind(TrinoJdbcCatalogFactory.class);
        ExportBinder.newExporter((Binder)binder).export(TrinoJdbcCatalogFactory.class).withGeneratedName();
    }

    @Provides
    @Singleton
    public static IcebergJdbcClient createIcebergJdbcClient(IcebergJdbcCatalogConfig config) {
        Driver driver;
        Class<Driver> driverClass;
        String driverClassName = Objects.requireNonNull(config.getDriverClass(), "driver class not configured");
        try {
            driverClass = Class.forName(driverClassName).asSubclass(Driver.class);
        }
        catch (ClassCastException | ClassNotFoundException e) {
            throw new RuntimeException("Failed to load Driver class: " + driverClassName, e);
        }
        try {
            driver = driverClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Failed to create instance of Driver: " + driverClassName, e);
        }
        return new IcebergJdbcClient(new IcebergJdbcConnectionFactory(driver, config.getConnectionUrl(), config.getConnectionUser(), config.getConnectionPassword()), config.getCatalogName(), config.getSchemaVersion());
    }
}

