/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog.jdbc;

import io.trino.plugin.iceberg.catalog.jdbc.IcebergJdbcCatalogConfig;
import io.trino.plugin.iceberg.catalog.jdbc.IcebergJdbcConnectionFactory;
import java.util.Objects;
import java.util.Optional;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.jdbi.v3.core.ConnectionFactory;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Update;

public class IcebergJdbcClient {
    private final IcebergJdbcConnectionFactory connectionFactory;
    private final String catalogName;
    private final IcebergJdbcCatalogConfig.SchemaVersion schemaVersion;

    public IcebergJdbcClient(IcebergJdbcConnectionFactory connectionFactory, String catalogName, IcebergJdbcCatalogConfig.SchemaVersion schemaVersion) {
        this.connectionFactory = Objects.requireNonNull(connectionFactory, "connectionFactory is null");
        this.catalogName = Objects.requireNonNull(catalogName, "catalogName is null");
        this.schemaVersion = Objects.requireNonNull(schemaVersion, "schemaVersion is null");
    }

    public void createTable(String schemaName, String tableName, String metadataLocation) {
        switch (this.schemaVersion) {
            case V0: {
                this.createTableV0(schemaName, tableName, metadataLocation);
                break;
            }
            case V1: {
                this.createTableV1(schemaName, tableName, metadataLocation);
            }
        }
    }

    private void createTableV0(String schemaName, String tableName, String metadataLocation) {
        try (Handle handle = Jdbi.open((ConnectionFactory)this.connectionFactory);){
            ((Update)((Update)((Update)((Update)handle.createUpdate("INSERT INTO iceberg_tables (catalog_name, table_namespace, table_name, metadata_location, previous_metadata_location) VALUES (:catalog, :schema, :table, :metadata_location, null)").bind("catalog", this.catalogName)).bind("schema", schemaName)).bind("table", tableName)).bind("metadata_location", metadataLocation)).execute();
        }
    }

    private void createTableV1(String schemaName, String tableName, String metadataLocation) {
        try (Handle handle = Jdbi.open((ConnectionFactory)this.connectionFactory);){
            ((Update)((Update)((Update)((Update)handle.createUpdate("INSERT INTO iceberg_tables (catalog_name, table_namespace, table_name, metadata_location, previous_metadata_location, iceberg_type) VALUES (:catalog, :schema, :table, :metadata_location, null, 'TABLE')").bind("catalog", this.catalogName)).bind("schema", schemaName)).bind("table", tableName)).bind("metadata_location", metadataLocation)).execute();
        }
    }

    public void alterTable(String schemaName, String tableName, String newMetadataLocation, String previousMetadataLocation) {
        try (Handle handle = Jdbi.open((ConnectionFactory)this.connectionFactory);){
            int updatedRecords = ((Update)((Update)((Update)((Update)((Update)handle.createUpdate("UPDATE iceberg_tables SET metadata_location = :metadata_location, previous_metadata_location = :previous_metadata_location WHERE catalog_name = :catalog AND table_namespace = :schema AND table_name = :table AND metadata_location = :previous_metadata_location").bind("metadata_location", newMetadataLocation)).bind("previous_metadata_location", previousMetadataLocation)).bind("catalog", this.catalogName)).bind("schema", schemaName)).bind("table", tableName)).execute();
            if (updatedRecords != 1) {
                throw new CommitFailedException("Failed to update table due to concurrent updates", new Object[0]);
            }
        }
    }

    public Optional<String> getMetadataLocation(String schemaName, String tableName) {
        try (Handle handle = Jdbi.open((ConnectionFactory)this.connectionFactory);){
            Optional optional = ((Query)((Query)((Query)handle.createQuery("SELECT metadata_location FROM iceberg_tables WHERE catalog_name = :catalog AND table_namespace = :schema AND table_name = :table").bind("catalog", this.catalogName)).bind("schema", schemaName)).bind("table", tableName)).mapTo(String.class).findOne();
            return optional;
        }
    }
}

