/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog.jdbc;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.plugin.iceberg.IcebergConfig;
import io.trino.plugin.iceberg.catalog.IcebergTableOperationsProvider;
import io.trino.plugin.iceberg.catalog.TrinoCatalog;
import io.trino.plugin.iceberg.catalog.TrinoCatalogFactory;
import io.trino.plugin.iceberg.catalog.jdbc.IcebergJdbcCatalogConfig;
import io.trino.plugin.iceberg.catalog.jdbc.IcebergJdbcClient;
import io.trino.plugin.iceberg.catalog.jdbc.TrinoJdbcCatalog;
import io.trino.plugin.iceberg.fileio.ForwardingFileIo;
import io.trino.spi.catalog.CatalogName;
import io.trino.spi.security.ConnectorIdentity;
import io.trino.spi.type.TypeManager;
import jakarta.annotation.PreDestroy;
import java.util.Map;
import java.util.Objects;
import org.apache.iceberg.jdbc.JdbcCatalog;
import org.apache.iceberg.jdbc.JdbcClientPool;

public class TrinoJdbcCatalogFactory
implements TrinoCatalogFactory {
    private final CatalogName catalogName;
    private final TypeManager typeManager;
    private final IcebergTableOperationsProvider tableOperationsProvider;
    private final TrinoFileSystemFactory fileSystemFactory;
    private final IcebergJdbcClient jdbcClient;
    private final String jdbcCatalogName;
    private final String defaultWarehouseDir;
    private final boolean isUniqueTableLocation;
    private final Map<String, String> catalogProperties;
    private final JdbcClientPool clientPool;

    @Inject
    public TrinoJdbcCatalogFactory(CatalogName catalogName, TypeManager typeManager, IcebergTableOperationsProvider tableOperationsProvider, TrinoFileSystemFactory fileSystemFactory, IcebergJdbcClient jdbcClient, IcebergJdbcCatalogConfig jdbcConfig, IcebergConfig icebergConfig) {
        this.catalogName = Objects.requireNonNull(catalogName, "catalogName is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.tableOperationsProvider = Objects.requireNonNull(tableOperationsProvider, "tableOperationsProvider is null");
        this.fileSystemFactory = Objects.requireNonNull(fileSystemFactory, "fileSystemFactory is null");
        this.isUniqueTableLocation = Objects.requireNonNull(icebergConfig, "icebergConfig is null").isUniqueTableLocation();
        this.jdbcClient = Objects.requireNonNull(jdbcClient, "jdbcClient is null");
        this.jdbcCatalogName = jdbcConfig.getCatalogName();
        this.defaultWarehouseDir = jdbcConfig.getDefaultWarehouseDir();
        ImmutableMap.Builder properties = ImmutableMap.builder();
        properties.put((Object)"uri", (Object)jdbcConfig.getConnectionUrl());
        properties.put((Object)"warehouse", (Object)this.defaultWarehouseDir);
        properties.put((Object)"jdbc.schema-version", (Object)jdbcConfig.getSchemaVersion().toString());
        jdbcConfig.getConnectionUser().ifPresent(user -> properties.put((Object)"jdbc.user", user));
        jdbcConfig.getConnectionPassword().ifPresent(password -> properties.put((Object)"jdbc.password", password));
        jdbcConfig.getRetryableStatusCodes().ifPresent(codes -> properties.put((Object)"retryable_status_codes", codes));
        this.catalogProperties = properties.buildOrThrow();
        this.clientPool = new JdbcClientPool(jdbcConfig.getConnectionUrl(), this.catalogProperties);
    }

    @PreDestroy
    public void shutdown() {
        this.clientPool.close();
    }

    @Override
    public TrinoCatalog create(ConnectorIdentity identity) {
        JdbcCatalog jdbcCatalog = new JdbcCatalog(config -> new ForwardingFileIo(this.fileSystemFactory.create(identity)), config -> this.clientPool, false);
        jdbcCatalog.initialize(this.jdbcCatalogName, this.catalogProperties);
        return new TrinoJdbcCatalog(this.catalogName, this.typeManager, this.tableOperationsProvider, jdbcCatalog, this.jdbcClient, this.fileSystemFactory, this.isUniqueTableLocation, this.defaultWarehouseDir);
    }
}

