/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog.nessie;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Binder;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConfigBinder;
import io.trino.plugin.base.ClosingBinder;
import io.trino.plugin.iceberg.catalog.IcebergTableOperationsProvider;
import io.trino.plugin.iceberg.catalog.TrinoCatalogFactory;
import io.trino.plugin.iceberg.catalog.nessie.IcebergNessieCatalogConfig;
import io.trino.plugin.iceberg.catalog.nessie.IcebergNessieTableOperationsProvider;
import io.trino.plugin.iceberg.catalog.nessie.TrinoNessieCatalogFactory;
import java.util.Map;
import org.apache.iceberg.nessie.NessieIcebergClient;
import org.projectnessie.client.NessieClientBuilder;
import org.projectnessie.client.api.NessieApiV1;
import org.projectnessie.client.api.NessieApiV2;
import org.projectnessie.client.auth.BearerAuthenticationProvider;
import org.projectnessie.client.auth.NessieAuthentication;
import org.weakref.jmx.guice.ExportBinder;

public class IcebergNessieCatalogModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        ConfigBinder.configBinder((Binder)binder).bindConfig(IcebergNessieCatalogConfig.class);
        binder.bind(IcebergTableOperationsProvider.class).to(IcebergNessieTableOperationsProvider.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(IcebergTableOperationsProvider.class).withGeneratedName();
        binder.bind(TrinoCatalogFactory.class).to(TrinoNessieCatalogFactory.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(TrinoCatalogFactory.class).withGeneratedName();
        ClosingBinder.closingBinder((Binder)binder).registerCloseable(NessieIcebergClient.class);
    }

    @Provides
    @Singleton
    public static NessieIcebergClient createNessieIcebergClient(IcebergNessieCatalogConfig icebergNessieCatalogConfig) {
        NessieClientBuilder builder = NessieClientBuilder.createClientBuilderFromSystemSettings().withUri(icebergNessieCatalogConfig.getServerUri()).withDisableCompression(!icebergNessieCatalogConfig.isCompressionEnabled()).withReadTimeout(Math.toIntExact(icebergNessieCatalogConfig.getReadTimeout().toMillis())).withConnectionTimeout(Math.toIntExact(icebergNessieCatalogConfig.getConnectionTimeout().toMillis()));
        icebergNessieCatalogConfig.getBearerToken().ifPresent(token -> builder.withAuthentication((NessieAuthentication)BearerAuthenticationProvider.create((String)token)));
        IcebergNessieCatalogConfig.ClientApiVersion clientApiVersion = icebergNessieCatalogConfig.getClientAPIVersion().orElseGet(icebergNessieCatalogConfig::inferVersionFromURI);
        NessieApiV1 api = switch (clientApiVersion) {
            default -> throw new MatchException(null, null);
            case IcebergNessieCatalogConfig.ClientApiVersion.V1 -> (NessieApiV1)builder.build(NessieApiV1.class);
            case IcebergNessieCatalogConfig.ClientApiVersion.V2 -> (NessieApiV2)builder.build(NessieApiV2.class);
        };
        return new NessieIcebergClient(api, icebergNessieCatalogConfig.getDefaultReferenceName(), null, (Map)ImmutableMap.of());
    }
}

