/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog.rest;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.plugin.iceberg.IcebergFileSystemFactory;
import io.trino.plugin.iceberg.catalog.rest.IcebergRestCatalogConfig;
import io.trino.spi.security.ConnectorIdentity;
import java.util.Map;
import java.util.Objects;

public class IcebergRestCatalogFileSystemFactory
implements IcebergFileSystemFactory {
    private static final String VENDED_S3_ACCESS_KEY = "s3.access-key-id";
    private static final String VENDED_S3_SECRET_KEY = "s3.secret-access-key";
    private static final String VENDED_S3_SESSION_TOKEN = "s3.session-token";
    private final TrinoFileSystemFactory fileSystemFactory;
    private final boolean vendedCredentialsEnabled;

    @Inject
    public IcebergRestCatalogFileSystemFactory(TrinoFileSystemFactory fileSystemFactory, IcebergRestCatalogConfig config) {
        this.fileSystemFactory = Objects.requireNonNull(fileSystemFactory, "fileSystemFactory is null");
        this.vendedCredentialsEnabled = config.isVendedCredentialsEnabled();
    }

    @Override
    public TrinoFileSystem create(ConnectorIdentity identity, Map<String, String> fileIoProperties) {
        if (this.vendedCredentialsEnabled && fileIoProperties.containsKey(VENDED_S3_ACCESS_KEY) && fileIoProperties.containsKey(VENDED_S3_SECRET_KEY) && fileIoProperties.containsKey(VENDED_S3_SESSION_TOKEN)) {
            ConnectorIdentity identityWithExtraCredentials = ConnectorIdentity.forUser((String)identity.getUser()).withGroups(identity.getGroups()).withPrincipal(identity.getPrincipal()).withEnabledSystemRoles(identity.getEnabledSystemRoles()).withConnectorRole(identity.getConnectorRole()).withExtraCredentials((Map)ImmutableMap.builder().put((Object)"internal$s3_aws_access_key", (Object)fileIoProperties.get(VENDED_S3_ACCESS_KEY)).put((Object)"internal$s3_aws_secret_key", (Object)fileIoProperties.get(VENDED_S3_SECRET_KEY)).put((Object)"internal$s3_aws_session_token", (Object)fileIoProperties.get(VENDED_S3_SESSION_TOKEN)).buildOrThrow()).build();
            return this.fileSystemFactory.create(identityWithExtraCredentials);
        }
        return this.fileSystemFactory.create(identity);
    }
}

