/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog.rest;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.multibindings.OptionalBinder;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConditionalModule;
import io.airlift.configuration.ConfigBinder;
import io.trino.plugin.iceberg.IcebergConfig;
import io.trino.plugin.iceberg.IcebergFileSystemFactory;
import io.trino.plugin.iceberg.catalog.TrinoCatalogFactory;
import io.trino.plugin.iceberg.catalog.rest.IcebergRestCatalogConfig;
import io.trino.plugin.iceberg.catalog.rest.IcebergRestCatalogFileSystemFactory;
import io.trino.plugin.iceberg.catalog.rest.NoneSecurityModule;
import io.trino.plugin.iceberg.catalog.rest.OAuth2SecurityModule;
import io.trino.plugin.iceberg.catalog.rest.TrinoIcebergRestCatalogFactory;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;

public class IcebergRestCatalogModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        ConfigBinder.configBinder((Binder)binder).bindConfig(IcebergRestCatalogConfig.class);
        this.install(ConditionalModule.conditionalModule(IcebergRestCatalogConfig.class, config -> config.getSecurity() == IcebergRestCatalogConfig.Security.OAUTH2, (Module)new OAuth2SecurityModule(), (Module)new NoneSecurityModule()));
        binder.bind(TrinoCatalogFactory.class).to(TrinoIcebergRestCatalogFactory.class).in(Scopes.SINGLETON);
        OptionalBinder.newOptionalBinder((Binder)binder, IcebergFileSystemFactory.class).setBinding().to(IcebergRestCatalogFileSystemFactory.class).in(Scopes.SINGLETON);
        IcebergConfig icebergConfig = (IcebergConfig)this.buildConfigObject(IcebergConfig.class);
        IcebergRestCatalogConfig restCatalogConfig = (IcebergRestCatalogConfig)this.buildConfigObject(IcebergRestCatalogConfig.class);
        if (restCatalogConfig.isVendedCredentialsEnabled() && icebergConfig.isRegisterTableProcedureEnabled()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Using the `register_table` procedure with vended credentials is currently not supported");
        }
    }
}

