/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog.rest;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import io.trino.plugin.iceberg.catalog.rest.OAuth2SecurityConfig;
import io.trino.plugin.iceberg.catalog.rest.SecurityProperties;
import java.util.Map;
import java.util.Objects;

public class OAuth2SecurityProperties
implements SecurityProperties {
    private final Map<String, String> securityProperties;

    @Inject
    public OAuth2SecurityProperties(OAuth2SecurityConfig securityConfig) {
        Objects.requireNonNull(securityConfig, "securityConfig is null");
        ImmutableMap.Builder propertiesBuilder = ImmutableMap.builder();
        securityConfig.getCredential().ifPresent(credential -> {
            propertiesBuilder.put((Object)"credential", credential);
            securityConfig.getScope().ifPresent(scope -> propertiesBuilder.put((Object)"scope", scope));
        });
        securityConfig.getToken().ifPresent(value -> propertiesBuilder.put((Object)"token", value));
        securityConfig.getServerUri().ifPresent(value -> propertiesBuilder.put((Object)"oauth2-server-uri", (Object)value.toString()));
        this.securityProperties = propertiesBuilder.buildOrThrow();
    }

    @Override
    public Map<String, String> get() {
        return this.securityProperties;
    }
}

