/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog.rest;

import com.google.common.cache.Cache;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import com.google.inject.Inject;
import io.trino.cache.EvictableCacheBuilder;
import io.trino.plugin.hive.NodeVersion;
import io.trino.plugin.iceberg.IcebergConfig;
import io.trino.plugin.iceberg.IcebergFileSystemFactory;
import io.trino.plugin.iceberg.catalog.TrinoCatalog;
import io.trino.plugin.iceberg.catalog.TrinoCatalogFactory;
import io.trino.plugin.iceberg.catalog.rest.IcebergRestCatalogConfig;
import io.trino.plugin.iceberg.catalog.rest.SecurityProperties;
import io.trino.plugin.iceberg.catalog.rest.TrinoRestCatalog;
import io.trino.plugin.iceberg.fileio.ForwardingFileIo;
import io.trino.spi.catalog.CatalogName;
import io.trino.spi.security.ConnectorIdentity;
import io.trino.spi.type.TypeManager;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.rest.HTTPClient;
import org.apache.iceberg.rest.RESTSessionCatalog;

public class TrinoIcebergRestCatalogFactory
implements TrinoCatalogFactory {
    private final IcebergFileSystemFactory fileSystemFactory;
    private final CatalogName catalogName;
    private final String trinoVersion;
    private final URI serverUri;
    private final Optional<String> prefix;
    private final Optional<String> warehouse;
    private final boolean nestedNamespaceEnabled;
    private final IcebergRestCatalogConfig.SessionType sessionType;
    private final boolean vendedCredentialsEnabled;
    private final SecurityProperties securityProperties;
    private final boolean uniqueTableLocation;
    private final TypeManager typeManager;
    private final boolean caseInsensitiveNameMatching;
    private final Cache<Namespace, Namespace> remoteNamespaceMappingCache;
    private final Cache<TableIdentifier, TableIdentifier> remoteTableMappingCache;
    @GuardedBy(value="this")
    private RESTSessionCatalog icebergCatalog;

    @Inject
    public TrinoIcebergRestCatalogFactory(IcebergFileSystemFactory fileSystemFactory, CatalogName catalogName, IcebergRestCatalogConfig restConfig, SecurityProperties securityProperties, IcebergConfig icebergConfig, TypeManager typeManager, NodeVersion nodeVersion) {
        this.fileSystemFactory = Objects.requireNonNull(fileSystemFactory, "fileSystemFactory is null");
        this.catalogName = Objects.requireNonNull(catalogName, "catalogName is null");
        this.trinoVersion = Objects.requireNonNull(nodeVersion, "nodeVersion is null").toString();
        Objects.requireNonNull(restConfig, "restConfig is null");
        this.serverUri = restConfig.getBaseUri();
        this.prefix = restConfig.getPrefix();
        this.warehouse = restConfig.getWarehouse();
        this.nestedNamespaceEnabled = restConfig.isNestedNamespaceEnabled();
        this.sessionType = restConfig.getSessionType();
        this.vendedCredentialsEnabled = restConfig.isVendedCredentialsEnabled();
        this.securityProperties = Objects.requireNonNull(securityProperties, "securityProperties is null");
        Objects.requireNonNull(icebergConfig, "icebergConfig is null");
        this.uniqueTableLocation = icebergConfig.isUniqueTableLocation();
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.caseInsensitiveNameMatching = restConfig.isCaseInsensitiveNameMatching();
        this.remoteNamespaceMappingCache = EvictableCacheBuilder.newBuilder().expireAfterWrite(restConfig.getCaseInsensitiveNameMatchingCacheTtl().toMillis(), TimeUnit.MILLISECONDS).shareNothingWhenDisabled().build();
        this.remoteTableMappingCache = EvictableCacheBuilder.newBuilder().expireAfterWrite(restConfig.getCaseInsensitiveNameMatchingCacheTtl().toMillis(), TimeUnit.MILLISECONDS).shareNothingWhenDisabled().build();
    }

    @Override
    public synchronized TrinoCatalog create(ConnectorIdentity identity) {
        if (this.icebergCatalog == null) {
            ImmutableMap.Builder properties = ImmutableMap.builder();
            properties.put((Object)"uri", (Object)this.serverUri.toString());
            this.warehouse.ifPresent(location -> properties.put((Object)"warehouse", location));
            this.prefix.ifPresent(prefix -> properties.put((Object)"prefix", prefix));
            properties.put((Object)"view-endpoints-supported", (Object)"true");
            properties.put((Object)"trino-version", (Object)this.trinoVersion);
            properties.putAll(this.securityProperties.get());
            if (this.vendedCredentialsEnabled) {
                properties.put((Object)"header.X-Iceberg-Access-Delegation", (Object)"vended-credentials");
            }
            RESTSessionCatalog icebergCatalogInstance = new RESTSessionCatalog(config -> HTTPClient.builder((Map)config).uri((String)config.get("uri")).build(), (context, config) -> {
                ConnectorIdentity currentIdentity = context.wrappedIdentity() != null ? (ConnectorIdentity)context.wrappedIdentity() : ConnectorIdentity.ofUser((String)"fake");
                return new ForwardingFileIo(this.fileSystemFactory.create(currentIdentity, (Map<String, String>)config), (Map<String, String>)config);
            });
            icebergCatalogInstance.initialize(this.catalogName.toString(), (Map)properties.buildOrThrow());
            this.icebergCatalog = icebergCatalogInstance;
        }
        Map credentials = Maps.filterKeys(this.securityProperties.get(), key -> Set.of("token", "credential").contains(key));
        return new TrinoRestCatalog(this.icebergCatalog, this.catalogName, this.sessionType, credentials, this.nestedNamespaceEnabled, this.trinoVersion, this.typeManager, this.uniqueTableLocation, this.caseInsensitiveNameMatching, this.remoteNamespaceMappingCache, this.remoteTableMappingCache);
    }
}

