/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog.snowflake;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.ConfigSecuritySensitive;
import jakarta.validation.constraints.AssertTrue;
import jakarta.validation.constraints.NotNull;
import java.net.URI;
import java.sql.SQLException;
import java.util.Optional;
import net.snowflake.client.jdbc.SnowflakeDriver;

public class IcebergSnowflakeCatalogConfig {
    private URI uri;
    private String user;
    private String password;
    private String database;
    private Optional<String> role = Optional.empty();

    @AssertTrue(message="Invalid JDBC URL for Iceberg Snowflake catalog")
    public @AssertTrue(message="Invalid JDBC URL for Iceberg Snowflake catalog") boolean isUrlValid() throws SQLException {
        SnowflakeDriver driver = new SnowflakeDriver();
        return driver.acceptsURL(this.uri.toString());
    }

    @NotNull
    public URI getUri() {
        return this.uri;
    }

    @Config(value="iceberg.snowflake-catalog.account-uri")
    @ConfigDescription(value="Snowflake JDBC URI")
    public IcebergSnowflakeCatalogConfig setUri(URI uri) {
        this.uri = uri;
        return this;
    }

    @NotNull
    public String getUser() {
        return this.user;
    }

    @Config(value="iceberg.snowflake-catalog.user")
    @ConfigDescription(value="Username for Snowflake")
    public IcebergSnowflakeCatalogConfig setUser(String user) {
        this.user = user;
        return this;
    }

    @NotNull
    public String getPassword() {
        return this.password;
    }

    @Config(value="iceberg.snowflake-catalog.password")
    @ConfigDescription(value="Password for Snowflake")
    @ConfigSecuritySensitive
    public IcebergSnowflakeCatalogConfig setPassword(String password) {
        this.password = password;
        return this;
    }

    public String getDatabase() {
        return this.database;
    }

    @Config(value="iceberg.snowflake-catalog.database")
    @ConfigDescription(value="Snowflake database")
    public IcebergSnowflakeCatalogConfig setDatabase(String database) {
        this.database = database;
        return this;
    }

    public Optional<String> getRole() {
        return this.role;
    }

    @Config(value="iceberg.snowflake-catalog.role")
    @ConfigDescription(value="Name of Snowflake role to use")
    public IcebergSnowflakeCatalogConfig setRole(String role) {
        this.role = Optional.ofNullable(role);
        return this;
    }
}

