/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog.snowflake;

import com.google.inject.Binder;
import com.google.inject.Scopes;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConfigBinder;
import io.trino.plugin.iceberg.IcebergConfig;
import io.trino.plugin.iceberg.IcebergFileFormat;
import io.trino.plugin.iceberg.catalog.IcebergTableOperationsProvider;
import io.trino.plugin.iceberg.catalog.TrinoCatalogFactory;
import io.trino.plugin.iceberg.catalog.snowflake.IcebergSnowflakeCatalogConfig;
import io.trino.plugin.iceberg.catalog.snowflake.SnowflakeIcebergTableOperationsProvider;
import org.apache.iceberg.snowflake.TrinoIcebergSnowflakeCatalogFactory;

public class IcebergSnowflakeCatalogModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        ConfigBinder.configBinder((Binder)binder).bindConfig(IcebergSnowflakeCatalogConfig.class);
        binder.bind(IcebergTableOperationsProvider.class).to(SnowflakeIcebergTableOperationsProvider.class).in(Scopes.SINGLETON);
        binder.bind(TrinoCatalogFactory.class).to(TrinoIcebergSnowflakeCatalogFactory.class).in(Scopes.SINGLETON);
        IcebergConfig icebergConfig = (IcebergConfig)this.buildConfigObject(IcebergConfig.class);
        if (icebergConfig.getFileFormat() != IcebergFileFormat.PARQUET) {
            throw new RuntimeException("Snowflake only supports Iceberg tables that use the Parquet file format");
        }
    }
}

