/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog.snowflake;

import com.google.inject.Inject;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.plugin.iceberg.catalog.IcebergTableOperations;
import io.trino.plugin.iceberg.catalog.IcebergTableOperationsProvider;
import io.trino.plugin.iceberg.catalog.TrinoCatalog;
import io.trino.plugin.iceberg.catalog.snowflake.IcebergSnowflakeCatalogConfig;
import io.trino.plugin.iceberg.catalog.snowflake.TrinoSnowflakeCatalog;
import io.trino.plugin.iceberg.fileio.ForwardingFileIo;
import io.trino.spi.connector.ConnectorSession;
import java.util.Objects;
import java.util.Optional;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.snowflake.SnowflakeIcebergTableOperations;

public class SnowflakeIcebergTableOperationsProvider
implements IcebergTableOperationsProvider {
    private final String snowflakeDatabase;
    private final TrinoFileSystemFactory fileSystemFactory;

    @Inject
    public SnowflakeIcebergTableOperationsProvider(IcebergSnowflakeCatalogConfig icebergSnowflakeCatalogConfig, TrinoFileSystemFactory fileSystemFactory) {
        this.snowflakeDatabase = Objects.requireNonNull(icebergSnowflakeCatalogConfig.getDatabase(), "database is null");
        this.fileSystemFactory = Objects.requireNonNull(fileSystemFactory, "fileSystemFactory is null");
    }

    @Override
    public IcebergTableOperations createTableOperations(TrinoCatalog catalog, ConnectorSession session, String database, String table, Optional<String> owner, Optional<String> location) {
        return new SnowflakeIcebergTableOperations((TrinoSnowflakeCatalog)catalog, (FileIO)new ForwardingFileIo(this.fileSystemFactory.create(session)), session, this.snowflakeDatabase, database, table, owner, location);
    }
}

