/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog.snowflake;

import com.google.common.base.Throwables;
import com.google.common.cache.Cache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.UncheckedExecutionException;
import io.trino.cache.CacheUtils;
import io.trino.cache.EvictableCacheBuilder;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.metastore.TableInfo;
import io.trino.plugin.iceberg.ColumnIdentity;
import io.trino.plugin.iceberg.IcebergUtil;
import io.trino.plugin.iceberg.catalog.AbstractTrinoCatalog;
import io.trino.plugin.iceberg.catalog.IcebergTableOperationsProvider;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.catalog.CatalogName;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorMaterializedViewDefinition;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorViewDefinition;
import io.trino.spi.connector.RelationColumnsMetadata;
import io.trino.spi.connector.RelationCommentMetadata;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.TableNotFoundException;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.spi.type.TypeManager;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import org.apache.iceberg.BaseTable;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.Transaction;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.NoSuchNamespaceException;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.snowflake.SnowflakeCatalog;

public class TrinoSnowflakeCatalog
extends AbstractTrinoCatalog {
    private static final int PER_QUERY_CACHE_SIZE = 1000;
    private static final int NAMESPACE_SCHEMA_LEVEL = 2;
    private final Cache<SchemaTableName, TableMetadata> tableMetadataCache = EvictableCacheBuilder.newBuilder().maximumSize(1000L).build();
    private final SnowflakeCatalog snowflakeCatalog;
    private final String snowflakeDatabase;

    public TrinoSnowflakeCatalog(SnowflakeCatalog snowflakeCatalog, CatalogName catalogName, TypeManager typeManager, TrinoFileSystemFactory trinoFileSystemFactory, IcebergTableOperationsProvider tableOperationsProvider, String snowflakeDatabase) {
        super(catalogName, typeManager, tableOperationsProvider, trinoFileSystemFactory, false);
        this.snowflakeCatalog = Objects.requireNonNull(snowflakeCatalog, "snowflakeCatalog is null");
        this.snowflakeDatabase = Objects.requireNonNull(snowflakeDatabase, "snowflakeDatabase is null");
    }

    public SnowflakeCatalog getSnowflakeCatalog() {
        return this.snowflakeCatalog;
    }

    @Override
    public boolean namespaceExists(ConnectorSession session, String namespace) {
        return this.snowflakeCatalog.namespaceExists(Namespace.of((String[])new String[]{this.snowflakeDatabase, namespace}));
    }

    @Override
    public List<String> listNamespaces(ConnectorSession session) {
        try {
            return this.snowflakeCatalog.listNamespaces(Namespace.of((String[])new String[]{this.snowflakeDatabase})).stream().map(namespace -> namespace.level(1)).toList();
        }
        catch (NoSuchNamespaceException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, "Snowflake database %s is not found".formatted(this.snowflakeDatabase));
        }
    }

    @Override
    public void dropNamespace(ConnectorSession session, String namespace) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Iceberg Snowflake catalog schemas do not support modifications");
    }

    @Override
    public Map<String, Object> loadNamespaceMetadata(ConnectorSession session, String namespace) {
        return ImmutableMap.of();
    }

    @Override
    public Optional<TrinoPrincipal> getNamespacePrincipal(ConnectorSession session, String namespace) {
        return Optional.empty();
    }

    @Override
    public void createNamespace(ConnectorSession session, String namespace, Map<String, Object> properties, TrinoPrincipal owner) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Iceberg Snowflake catalog schemas do not support modifications");
    }

    @Override
    public void setNamespacePrincipal(ConnectorSession session, String namespace, TrinoPrincipal principal) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Iceberg Snowflake catalog schemas do not support modifications");
    }

    @Override
    public void renameNamespace(ConnectorSession session, String source, String target) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Iceberg Snowflake catalog schemas do not support modifications");
    }

    @Override
    public List<TableInfo> listTables(ConnectorSession session, Optional<String> namespace) {
        return namespace.map(Stream::of).orElseGet(() -> this.listNamespaces(session).stream()).flatMap(schema -> {
            try {
                return this.snowflakeCatalog.listTables(Namespace.of((String[])new String[]{this.snowflakeDatabase, schema})).stream().map(table -> new TableInfo(new SchemaTableName(schema, table.name()), TableInfo.ExtendedRelationType.TABLE));
            }
            catch (NoSuchNamespaceException ignored) {
                return Stream.empty();
            }
        }).toList();
    }

    @Override
    public List<SchemaTableName> listIcebergTables(ConnectorSession session, Optional<String> namespace) {
        return (List)this.listTables(session, namespace).stream().map(TableInfo::tableName).collect(ImmutableList.toImmutableList());
    }

    @Override
    public Optional<Iterator<RelationColumnsMetadata>> streamRelationColumns(ConnectorSession session, Optional<String> namespace, UnaryOperator<Set<SchemaTableName>> relationFilter, Predicate<SchemaTableName> isRedirected) {
        return Optional.empty();
    }

    @Override
    public Optional<Iterator<RelationCommentMetadata>> streamRelationComments(ConnectorSession session, Optional<String> namespace, UnaryOperator<Set<SchemaTableName>> relationFilter, Predicate<SchemaTableName> isRedirected) {
        return Optional.empty();
    }

    @Override
    public Transaction newTransaction(Table icebergTable) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Snowflake managed Iceberg tables do not support modifications");
    }

    @Override
    public Transaction newCreateTableTransaction(ConnectorSession session, SchemaTableName schemaTableName, Schema schema, PartitionSpec partitionSpec, SortOrder sortOrder, String location, Map<String, String> properties) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Snowflake managed Iceberg tables do not support modifications");
    }

    @Override
    public Transaction newCreateOrReplaceTableTransaction(ConnectorSession session, SchemaTableName schemaTableName, Schema schema, PartitionSpec partitionSpec, SortOrder sortOrder, String location, Map<String, String> properties) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Snowflake managed Iceberg tables do not support modifications");
    }

    @Override
    public void registerTable(ConnectorSession session, SchemaTableName tableName, TableMetadata tableMetadata) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Snowflake managed Iceberg tables do not support modifications");
    }

    @Override
    public void unregisterTable(ConnectorSession session, SchemaTableName tableName) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Snowflake managed Iceberg tables do not support modifications");
    }

    @Override
    public void dropTable(ConnectorSession session, SchemaTableName schemaTableName) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Snowflake managed Iceberg tables do not support modifications");
    }

    @Override
    public void dropCorruptedTable(ConnectorSession session, SchemaTableName schemaTableName) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Snowflake managed Iceberg tables do not support modifications");
    }

    @Override
    public void renameTable(ConnectorSession session, SchemaTableName from, SchemaTableName to) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Snowflake managed Iceberg tables do not support modifications");
    }

    @Override
    public Table loadTable(ConnectorSession session, SchemaTableName schemaTableName) {
        TableMetadata metadata;
        try {
            metadata = (TableMetadata)CacheUtils.uncheckedCacheGet(this.tableMetadataCache, (Object)schemaTableName, () -> {
                BaseTable baseTable;
                try {
                    baseTable = (BaseTable)this.snowflakeCatalog.loadTable(TableIdentifier.of((String[])new String[]{this.snowflakeDatabase, schemaTableName.getSchemaName(), schemaTableName.getTableName()}));
                }
                catch (NoSuchTableException e) {
                    throw new TableNotFoundException(schemaTableName);
                }
                return new BaseTable(baseTable.operations(), IcebergUtil.quotedTableName(schemaTableName)).operations().current();
            });
        }
        catch (UncheckedExecutionException e) {
            Throwables.throwIfUnchecked((Throwable)e.getCause());
            throw e;
        }
        return IcebergUtil.getIcebergTableWithMetadata(this, this.tableOperationsProvider, session, schemaTableName, metadata);
    }

    @Override
    public Map<SchemaTableName, List<ColumnMetadata>> tryGetColumnMetadata(ConnectorSession session, List<SchemaTableName> tables) {
        return ImmutableMap.of();
    }

    @Override
    public void updateTableComment(ConnectorSession session, SchemaTableName schemaTableName, Optional<String> comment) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Snowflake managed Iceberg tables do not support modifications");
    }

    @Override
    public void updateViewComment(ConnectorSession session, SchemaTableName schemaViewName, Optional<String> comment) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Views are not supported for the Snowflake Iceberg catalog");
    }

    @Override
    public void updateViewColumnComment(ConnectorSession session, SchemaTableName schemaViewName, String columnName, Optional<String> comment) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Views are not supported for the Snowflake Iceberg catalog");
    }

    @Override
    public String defaultTableLocation(ConnectorSession session, SchemaTableName schemaTableName) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Snowflake managed Iceberg tables do not support modifications");
    }

    @Override
    public void setTablePrincipal(ConnectorSession session, SchemaTableName schemaTableName, TrinoPrincipal principal) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Snowflake managed Iceberg tables do not support modifications");
    }

    @Override
    public void createView(ConnectorSession session, SchemaTableName schemaViewName, ConnectorViewDefinition definition, boolean replace) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Views are not supported for the Snowflake Iceberg catalog");
    }

    @Override
    public void renameView(ConnectorSession session, SchemaTableName source, SchemaTableName target) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Views are not supported for the Snowflake Iceberg catalog");
    }

    @Override
    public void setViewPrincipal(ConnectorSession session, SchemaTableName schemaViewName, TrinoPrincipal principal) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Views are not supported for the Snowflake Iceberg catalog");
    }

    @Override
    public void dropView(ConnectorSession session, SchemaTableName schemaViewName) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Views are not supported for the Snowflake Iceberg catalog");
    }

    @Override
    public Map<SchemaTableName, ConnectorViewDefinition> getViews(ConnectorSession session, Optional<String> namespace) {
        return ImmutableMap.of();
    }

    @Override
    public Optional<ConnectorViewDefinition> getView(ConnectorSession session, SchemaTableName viewName) {
        return Optional.empty();
    }

    @Override
    public void createMaterializedView(ConnectorSession session, SchemaTableName viewName, ConnectorMaterializedViewDefinition definition, Map<String, Object> materializedViewProperties, boolean replace, boolean ignoreExisting) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Materialized views are not supported for the Snowflake Iceberg catalog");
    }

    @Override
    public void updateMaterializedViewColumnComment(ConnectorSession session, SchemaTableName schemaViewName, String columnName, Optional<String> comment) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Materialized views are not supported for the Snowflake Iceberg catalog");
    }

    @Override
    public void dropMaterializedView(ConnectorSession session, SchemaTableName viewName) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Materialized views are not supported for the Snowflake Iceberg catalog");
    }

    @Override
    public Optional<ConnectorMaterializedViewDefinition> getMaterializedView(ConnectorSession session, SchemaTableName viewName) {
        return Optional.empty();
    }

    @Override
    public Optional<BaseTable> getMaterializedViewStorageTable(ConnectorSession session, SchemaTableName viewName) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Materialized views are not supported for the Snowflake Iceberg catalog");
    }

    @Override
    public void renameMaterializedView(ConnectorSession session, SchemaTableName source, SchemaTableName target) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Materialized views are not supported for the Snowflake Iceberg catalog");
    }

    @Override
    public void updateColumnComment(ConnectorSession session, SchemaTableName schemaTableName, ColumnIdentity columnIdentity, Optional<String> comment) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Snowflake managed Iceberg tables do not support modifications");
    }

    @Override
    public Optional<CatalogSchemaTableName> redirectTable(ConnectorSession session, SchemaTableName tableName, String hiveCatalogName) {
        return Optional.empty();
    }

    @Override
    protected Optional<ConnectorMaterializedViewDefinition> doGetMaterializedView(ConnectorSession session, SchemaTableName schemaViewName) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Materialized views are not supported for the Snowflake Iceberg catalog");
    }

    @Override
    protected void invalidateTableCache(SchemaTableName schemaTableName) {
        this.tableMetadataCache.invalidate((Object)schemaTableName);
    }
}

