/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.delete;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.SizeOf;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.iceberg.FileContent;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.types.Conversions;
import org.apache.iceberg.types.Type;

public record DeleteFile(FileContent content, String path, FileFormat format, long recordCount, long fileSizeInBytes, List<Integer> equalityFieldIds, Optional<Long> rowPositionLowerBound, Optional<Long> rowPositionUpperBound, long dataSequenceNumber) {
    private static final long INSTANCE_SIZE = SizeOf.instanceSize(DeleteFile.class);

    public DeleteFile {
        Objects.requireNonNull(content, "content is null");
        Objects.requireNonNull(path, "path is null");
        Objects.requireNonNull(format, "format is null");
        equalityFieldIds = ImmutableList.copyOf((Collection)Objects.requireNonNull(equalityFieldIds, "equalityFieldIds is null"));
        Objects.requireNonNull(rowPositionLowerBound, "rowPositionLowerBound is null");
        Objects.requireNonNull(rowPositionUpperBound, "rowPositionUpperBound is null");
    }

    public static DeleteFile fromIceberg(org.apache.iceberg.DeleteFile deleteFile) {
        Optional<Long> rowPositionLowerBound = Optional.ofNullable(deleteFile.lowerBounds()).map(bounds -> (ByteBuffer)bounds.get(MetadataColumns.DELETE_FILE_POS.fieldId())).map(bytes -> (Long)Conversions.fromByteBuffer((Type)MetadataColumns.DELETE_FILE_POS.type(), (ByteBuffer)bytes));
        Optional<Long> rowPositionUpperBound = Optional.ofNullable(deleteFile.upperBounds()).map(bounds -> (ByteBuffer)bounds.get(MetadataColumns.DELETE_FILE_POS.fieldId())).map(bytes -> (Long)Conversions.fromByteBuffer((Type)MetadataColumns.DELETE_FILE_POS.type(), (ByteBuffer)bytes));
        return new DeleteFile(deleteFile.content(), deleteFile.location(), deleteFile.format(), deleteFile.recordCount(), deleteFile.fileSizeInBytes(), Optional.ofNullable(deleteFile.equalityFieldIds()).orElseGet(ImmutableList::of), rowPositionLowerBound, rowPositionUpperBound, deleteFile.dataSequenceNumber());
    }

    public long retainedSizeInBytes() {
        return INSTANCE_SIZE + SizeOf.estimatedSizeOf((String)this.path) + SizeOf.estimatedSizeOf(this.equalityFieldIds, n -> 4L);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.path).add("records", this.recordCount).toString();
    }
}

