/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.delete;

import com.amazonaws.annotation.ThreadSafe;
import com.google.common.base.Verify;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import io.trino.plugin.iceberg.IcebergColumnHandle;
import io.trino.plugin.iceberg.IcebergErrorCode;
import io.trino.plugin.iceberg.IcebergUtil;
import io.trino.plugin.iceberg.delete.DeleteFile;
import io.trino.plugin.iceberg.delete.DeleteFilter;
import io.trino.plugin.iceberg.delete.DeleteManager;
import io.trino.plugin.iceberg.delete.LazyTrinoRow;
import io.trino.plugin.iceberg.delete.RowPredicate;
import io.trino.plugin.iceberg.delete.TrinoRow;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Page;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.Type;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.StructLikeWrapper;
import org.apache.iceberg.util.StructProjection;

public final class EqualityDeleteFilter
implements DeleteFilter {
    private final Schema deleteSchema;
    private final Map<StructLikeWrapper, DataSequenceNumber> deletedRows;

    private EqualityDeleteFilter(Schema deleteSchema, Map<StructLikeWrapper, DataSequenceNumber> deletedRows) {
        this.deleteSchema = Objects.requireNonNull(deleteSchema, "deleteSchema is null");
        this.deletedRows = Objects.requireNonNull(deletedRows, "deletedRows is null");
    }

    @Override
    public RowPredicate createPredicate(List<IcebergColumnHandle> columns, long splitDataSequenceNumber) {
        Schema fileSchema = IcebergUtil.schemaFromHandles(columns);
        if (this.deleteSchema.columns().stream().anyMatch(column -> fileSchema.findField(column.fieldId()) == null)) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_CANNOT_OPEN_SPLIT, "columns list doesn't contain all equality delete columns");
        }
        StructLikeWrapper structLikeWrapper = StructLikeWrapper.forType((Types.StructType)this.deleteSchema.asStruct());
        StructProjection projection = StructProjection.create((Schema)fileSchema, (Schema)this.deleteSchema);
        Type[] types = (Type[])columns.stream().map(IcebergColumnHandle::getType).toArray(Type[]::new);
        return (page, position) -> {
            StructProjection row = projection.wrap((StructLike)new LazyTrinoRow(types, page, position));
            DataSequenceNumber maxDeleteVersion = this.deletedRows.get(structLikeWrapper.set((StructLike)row));
            structLikeWrapper.set(null);
            return maxDeleteVersion == null || maxDeleteVersion.dataSequenceNumber() <= splitDataSequenceNumber;
        };
    }

    public static EqualityDeleteFilterBuilder builder(Schema deleteSchema) {
        return new EqualityDeleteFilterBuilder(deleteSchema);
    }

    @ThreadSafe
    public static class EqualityDeleteFilterBuilder {
        private final Schema deleteSchema;
        private final Map<StructLikeWrapper, DataSequenceNumber> deletedRows;
        private final Map<String, ListenableFutureTask<?>> loadingFiles = new ConcurrentHashMap();

        private EqualityDeleteFilterBuilder(Schema deleteSchema) {
            this.deleteSchema = Objects.requireNonNull(deleteSchema, "deleteSchema is null");
            this.deletedRows = new ConcurrentHashMap<StructLikeWrapper, DataSequenceNumber>();
        }

        public ListenableFuture<?> readEqualityDeletes(DeleteFile deleteFile, List<IcebergColumnHandle> deleteColumns, DeleteManager.DeletePageSourceProvider deletePageSourceProvider) {
            Verify.verify((deleteColumns.size() == this.deleteSchema.columns().size() ? 1 : 0) != 0, (String)"delete columns size doesn't match delete schema size", (Object[])new Object[0]);
            ListenableFutureTask futureTask = this.loadingFiles.computeIfAbsent(deleteFile.path(), key -> ListenableFutureTask.create(() -> this.readEqualityDeletesInternal(deleteFile, deleteColumns, deletePageSourceProvider), null));
            futureTask.run();
            return Futures.nonCancellationPropagating((ListenableFuture)futureTask);
        }

        private void readEqualityDeletesInternal(DeleteFile deleteFile, List<IcebergColumnHandle> deleteColumns, DeleteManager.DeletePageSourceProvider deletePageSourceProvider) {
            DataSequenceNumber sequenceNumber = new DataSequenceNumber(deleteFile.dataSequenceNumber());
            try (ConnectorPageSource pageSource = deletePageSourceProvider.openDeletes(deleteFile, deleteColumns, (TupleDomain<IcebergColumnHandle>)TupleDomain.all());){
                Type[] types = (Type[])deleteColumns.stream().map(IcebergColumnHandle::getType).toArray(Type[]::new);
                StructLikeWrapper wrapper = StructLikeWrapper.forType((Types.StructType)this.deleteSchema.asStruct());
                while (!pageSource.isFinished()) {
                    Page page = pageSource.getNextPage();
                    if (page == null) continue;
                    for (int position = 0; position < page.getPositionCount(); ++position) {
                        TrinoRow row = new TrinoRow(types, page, position);
                        this.deletedRows.merge(wrapper.copyFor((StructLike)row), sequenceNumber, (existing, newValue) -> {
                            if (existing.dataSequenceNumber() > newValue.dataSequenceNumber()) {
                                return existing;
                            }
                            return newValue;
                        });
                    }
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        public EqualityDeleteFilter build() {
            return new EqualityDeleteFilter(this.deleteSchema, this.deletedRows);
        }
    }

    private record DataSequenceNumber(long dataSequenceNumber) {
    }
}

